function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Vikram N 
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/videoDriver/rc/live/PanTiltControl
 */
define(['baja!', 'baja!videoDriver:VideoPanTiltEnum', 'bajaux/commands/Command', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/videoDriver/rc/live/PanTiltStage', 'nmodule/webEditors/rc/fe/BaseWidget'], function (baja, types, Command, rpc, PanTiltStage, BaseWidget) {
  'use strict';

  var move = rpc.move;
  var tpl = function tpl(_ref) {
    var width = _ref.width,
      height = _ref.height;
    return "\n    <svg class=\"panTiltStage\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 ".concat(width, " ").concat(height, "\" preserveAspectRatio=\"none\"></svg>\n  ");
  };

  /**
   * Pant and Tilt support to applicable cameras
   *  
   * @class
   * @alias module:nmodule/videoDriver/rc/live/PanTiltControl
   * @extends {module:nmodule/webEditors/rc/fe/BaseWidget}
   */
  var PanTiltControl = /*#__PURE__*/function (_BaseWidget) {
    function PanTiltControl() {
      _classCallCheck(this, PanTiltControl);
      return _callSuper(this, PanTiltControl, arguments);
    }
    _inherits(PanTiltControl, _BaseWidget);
    return _createClass(PanTiltControl, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.addClass('PanTiltControl').html(tpl({
          height: PanTiltStage.STAGE_HEIGHT,
          width: PanTiltStage.STAGE_WIDTH
        }));
        this.panTiltCommands = this.$makeCommands();
        dom.on(PanTiltStage.MOVE_EVENT, function (e, moveAction) {
          return _this.$move(moveAction);
        });

        // Make a the pan tilt svg stage
        var panTiltStage = this.panTiltStage = new PanTiltStage(this.jq());
        panTiltStage.setMoveInterval(this.properties().getValue('moveInterval'));
        panTiltStage.initStage();
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PanTiltControl');
      }
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        if (name === 'moveInterval') {
          this.panTiltStage.setMoveInterval(value);
        }
      }
    }, {
      key: "getPanTiltCommands",
      value: function getPanTiltCommands() {
        return this.panTiltCommands;
      }
    }, {
      key: "$getSvgDOMElement",
      value: function $getSvgDOMElement() {
        return this.jq().find('.panTiltStage')[0];
      }
    }, {
      key: "$getMoveInterval",
      value: function $getMoveInterval() {
        return this.properties().getValue('moveInterval');
      }

      /**
       * Make all the pan-tilt commands
       * 
       * @private
       */
    }, {
      key: "$makeCommands",
      value: function $makeCommands() {
        var _this2 = this;
        var panTiltRange = baja.$('videoDriver:VideoPanTiltEnum').getRange();
        var commandsMap = new baja.OrderedMap();
        panTiltRange.getOrdinals().forEach(function (ordinal) {
          var ptEnum = panTiltRange.get(ordinal);
          var cmd = new Command({
            displayName: ptEnum.getDisplayTag(),
            func: function func() {
              if (!_this2.isEnabled()) {
                return;
              }
              return move(_this2.value().getNavOrd(), ptEnum.getTag());
            }
          });
          commandsMap.put(ptEnum.getTag(ordinal), cmd);
        });
        return commandsMap;
      }

      /**
       * @private
       * @param {baja.FrozenEnum} moveAction a 'videoDriver:VideoPanTiltEnum' enum
       * @returns {Promise}
       */
    }, {
      key: "$move",
      value: function $move(moveAction) {
        return this.panTiltCommands.get(moveAction.getTag()).invoke();
      }
    }]);
  }(BaseWidget);
  return PanTiltControl;
});
