function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 *  Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/WebSurveillanceViewer
 */

define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'bajaux/events', 'jquery', 'Promise', 'bajaux/commands/Command', 'bajaux/util/SaveCommand', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget', 'nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget', 'nmodule/videoDriver/rc/fe/surveillance/SurveillanceViewerGrid', 'lex!videoDriver', 'baja!videoDriver:VideoPlaybackMultistream'], function (baja, Widget, subscriberMixIn, events, $, Promise, Command, SaveCommand, CommandButton, BaseWidget, fe, userData, DeviceListWidget, SurveillanceOptionsWidget, SurveillanceViewerGrid, lexs, types) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var tpl = function tpl() {
    return "\n  <div class=\"WebSurveillanceViewerContainer\">\n    <div class=\"wrapperContainer leftContainerVisible\"> \n      <div class=\"leftContainer\"> \n        <div class=\"DeviceListWidget\"></div>\n        <div class=\"SurveillanceOptionsWidget\"></div>\n        <div class=\"SaveAndRefreshContainer\">\n          <button type=\"button\" class=\"saveButton\" />\n          <button type=\"button\" class=\"refreshButton\" /> \n        </div>\n      </div>\n      <div class=\"rightContainer\" />\n    </div>\n   </div>\n  ";
  };

  /**
   * Widget for surveillance of video from the camera. Provides surveillance view options like
   * viewing cameras in the station, changing values like frame rate, compression, resolution,
   * compression and layout.
   *
   * @private
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/WebSurveillanceViewer
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function WebSurveillanceViewer(params) {
      var _this;
      _classCallCheck(this, WebSurveillanceViewer);
      _this = _callSuper(this, WebSurveillanceViewer, [params]);
      _this.$saveCommand = new SaveCommand();
      _this.$refreshCommand = new Command({
        module: 'videoDriver',
        lex: 'refreshCommand',
        func: function func() {
          return _this.$doRefresh();
        }
      });
      _this.$collapseCommand = new Command({
        module: 'videoDriver',
        lex: 'collapseCommand',
        func: function func() {
          return _this.$invokeToggle();
        }
      });
      _this.getCommandGroup().add(_this.$saveCommand, _this.$refreshCommand, _this.$collapseCommand);
      subscriberMixIn(_this);
      return _this;
    }

    /**
     * Initializes the dom.
     *
     * @param {jquery} dom
     * @returns {Promise}
     */
    _inherits(WebSurveillanceViewer, _BaseWidget);
    return _createClass(WebSurveillanceViewer, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.html(tpl()).addClass('WebSurveillanceViewer');
        // Reload the grid only if the Options Widget is modified.
        dom.on(events.MODIFY_EVENT, '.SurveillanceOptionsWidget', function () {
          _this2.setModified(true);
          Promise.resolve(_this2.$reloadGrid())["catch"](baja.error);
          return false;
        }).on(events.MODIFY_EVENT, '.rightContainer', function () {
          // If the grid is changed via a drag drop, then just save.
          _this2.setModified(true);
          return false;
        });
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: dom.find('.saveButton'),
          value: this.$saveCommand
        }), fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: dom.find('.refreshButton'),
          value: this.$refreshCommand
        })]);
      }

      /**
       * Loads the DeviceListWidget and SurveillanceOptionsWidget
       *
       * @param {baja.Component} value - the agent value on which WebSurveillanceViewer
       * is registered on.
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;
        if (baja.hasType(value, 'videoDriver:VideoPlaybackMultistream')) {
          var promArray = [];
          promArray.push(fe.buildFor({
            formFactor: 'mini',
            type: DeviceListWidget,
            dom: this.$getCameraListElement(),
            value: value
          }), fe.buildFor({
            formFactor: 'mini',
            type: SurveillanceOptionsWidget,
            dom: this.$getSurveillanceOptionsElement(),
            value: value
          }));
          if (!this.value().getPermissions().hasAdminWrite()) {
            promArray.push(this.$saveCommand.setEnabled(false));
          }
          promArray.push(userData.get(this.$getProfileKey()).then(JSON.parse));
          return Promise.all(promArray).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 3),
              cameraListContainer = _ref2[0],
              surveillanceOptionsWidget = _ref2[1],
              isLeftContainerVisible = _ref2[2];
            _this3.$cameraListContainer = cameraListContainer;
            _this3.$surveillanceOptionsWidget = surveillanceOptionsWidget;
            if (!isLeftContainerVisible) {
              _this3.$hideLeftContainer();
            }
            return _this3.$doLoadGridView(value);
          });
        } else {
          throw new Error('Invalid Type');
        }
      }

      /**
       * @private
       * @returns {string}
       */
    }, {
      key: "$getProfileKey",
      value: function $getProfileKey() {
        return 'survLeftContainerisVisible';
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$isLeftContainerVisible",
      value: function $isLeftContainerVisible() {
        return this.jq().find('.leftContainer').is(':visible');
      }

      /**
       * @private
       */
    }, {
      key: "$hideLeftContainer",
      value: function $hideLeftContainer() {
        this.jq().find('.wrapperContainer').toggleClass('leftContainerVisible', false);
        this.jq().find('.wrapperContainer').toggleClass('leftContainerHidden', true);
        this.$collapseCommand.setIcon(lex.get('restoreCommand.icon'));
        this.$collapseCommand.setDescriptionFormat(lex.get('restoreCommand.description'));
        this.$collapseCommand.setDisplayNameFormat(lex.get('restoreCommand.displayName'));
        this.jq().find('.leftContainer').animate({
          width: 'toggle'
        });
      }

      /**
       * @private
       */
    }, {
      key: "$showLeftContainer",
      value: function $showLeftContainer() {
        this.jq().find('.wrapperContainer').toggleClass('leftContainerHidden', false);
        this.jq().find('.wrapperContainer').toggleClass('leftContainerVisible', true);
        this.$collapseCommand.setIcon(lex.get('collapseCommand.icon'));
        this.$collapseCommand.setDescriptionFormat(lex.get('collapseCommand.description'));
        this.$collapseCommand.setDisplayNameFormat(lex.get('collapseCommand.displayName'));
        this.jq().find('.leftContainer').animate({
          width: 'toggle'
        });
      }

      /**
       * Invokes the toggle command action.
       *
       * @private
       */
    }, {
      key: "$invokeToggle",
      value: function $invokeToggle() {
        var isLeftContainerVisible = this.$isLeftContainerVisible();
        if (isLeftContainerVisible) {
          this.$hideLeftContainer();
        } else {
          this.$showLeftContainer();
        }
        // Reload the grid when there's a change in layout size.
        Promise.all([userData.put(this.$getProfileKey(), JSON.stringify(!isLeftContainerVisible)), this.$reloadGrid()])["catch"](baja.error);
      }

      /**
       * Reloads the surveillance viewer grid.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$reloadGrid",
      value: function $reloadGrid() {
        var _this4 = this;
        return this.read().then(function (value) {
          return _this4.$doLoadGridView(value);
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doLoadGridView",
      value: function $doLoadGridView(value) {
        return fe.buildFor({
          formFactor: 'mini',
          type: SurveillanceViewerGrid,
          dom: this.$getSurveillanceGridElement(),
          value: value,
          properties: {
            layoutType: value.getLayout()
          }
        });
      }

      /**
       * Reads the surveillance options widget.
       *
       * @returns {Promise}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return this.$surveillanceOptionsWidget.read();
      }

      /**
       * Saves all child widgets
       *
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        return this.getChildWidgets().saveAll();
      }

      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('WebSurveillanceViewer');
        return this.getChildWidgets().destroyAll();
      }

      /**
       * Layout the widgets in web surveillance Viewer
       * @returns {Promise}
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }

      /**
       * Using window.location to reload the page.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$reload",
      value: function $reload() {
        return window.niagara.env.reload();
      }

      /**
       * Refreshes the page.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doRefresh",
      value: function $doRefresh() {
        return this.$reload();
      }

      /**
       * @private
       * @returns {jquery}
       */
    }, {
      key: "$getCameraListElement",
      value: function $getCameraListElement() {
        return this.jq().find('.DeviceListWidget');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget}
       */
    }, {
      key: "$getDeviceListWidget",
      value: function $getDeviceListWidget() {
        return Widget["in"](this.$getCameraListElement());
      }

      /**
       * @private
       * @returns {jquery}
       */
    }, {
      key: "$getSurveillanceOptionsElement",
      value: function $getSurveillanceOptionsElement() {
        return this.jq().find('.SurveillanceOptionsWidget');
      }

      /**
       * @private
       * @returns {jquery}
       */
    }, {
      key: "$getSurveillanceGridElement",
      value: function $getSurveillanceGridElement() {
        return this.jq().find('.rightContainer');
      }

      /**
       * @private
       * @returns {jquery}
       */
    }, {
      key: "$getSurveillanceGridWidget",
      value: function $getSurveillanceGridWidget() {
        return Widget["in"](this.$getSurveillanceGridElement());
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget}
       */
    }, {
      key: "$getSurveillanceOptionsWidget",
      value: function $getSurveillanceOptionsWidget() {
        return Widget["in"](this.$getSurveillanceOptionsElement());
      }
    }]);
  }(BaseWidget);
});
