function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module module/videoDriver/rc/fe/binding/UxHoldDownButtonBinding
 */
define(['baja!', 'nmodule/bajaui/rc/baja/binding/Binding'], function (baja, Binding) {
  'use strict';

  var DEFAULT_INTERVAL = 1000;

  /**
   * A bajaux implementation of HoldDownPxBinding of the Mouse Down widget in
   * the video driver module, carries out the functionalities in the Ux Media
   * view in the Browser.
   *
   * @class
   * @alias module/videoDriver/rc/fe/binding/UxHoldDownButtonBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  return /*#__PURE__*/function (_Binding) {
    function UxHoldDownButtonBinding() {
      _classCallCheck(this, UxHoldDownButtonBinding);
      return _callSuper(this, UxHoldDownButtonBinding, arguments);
    }
    _inherits(UxHoldDownButtonBinding, _Binding);
    return _createClass(UxHoldDownButtonBinding, [{
      key: "addListeners",
      value:
      /**
       * Add event listeners for the widget:
       *
       * - mousedown : mouse pressed down
       * - mouseup : mouse released
       *
       * @param {module:bajaux/Widget} widget
       */
      function addListeners(widget) {
        var _this = this;
        _superPropGet(UxHoldDownButtonBinding, "addListeners", this, 3)([widget]);
        var events = {
          mousedown: function mousedown() {
            _this.$active = true;
            return _this.$engageMouseDown();
          },
          mouseup: function mouseup() {
            _this.$active = false;
            return _this.$engageMouseUp();
          }
        };
        this.addWidgetEvents(widget, events);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$engageMouseDown",
      value: function $engageMouseDown() {
        var _this2 = this;
        var pointSlot = this.getOnMouseDown().get("slot").substring(1);
        var pointValue = this.getOnMouseDown().getValue();
        return baja.Ord.make(this.getOrd()).get().then(function (point) {
          var downSlot = point.getSlot(pointSlot);
          if (downSlot.isAction()) {
            return point.invoke({
              slot: pointSlot,
              value: pointValue
            });
          }
          if (downSlot.isTopic()) {
            return point.fire({
              slot: pointSlot,
              value: pointValue
            });
          }
          if (downSlot.isProperty()) {
            return point.set({
              slot: pointSlot,
              value: pointValue
            });
          }
        }).then(function () {
          setTimeout(function () {
            if (_this2.$active) {
              _this2.$engageMouseDown();
            }
          }, _this2.$getInterval());
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$engageMouseUp",
      value: function $engageMouseUp() {
        var pointSlot = this.getOnMouseRelease().get("slot").substring(1);
        var pointValue = this.getOnMouseRelease().getValue();
        return baja.Ord.make(this.getOrd()).get().then(function (point) {
          var releaseSlot = point.getSlot(pointSlot);
          if (releaseSlot.isAction()) {
            return point.invoke({
              slot: pointSlot,
              value: pointValue
            });
          }
          if (releaseSlot.isTopic()) {
            return point.fire({
              slot: pointSlot,
              value: pointValue
            });
          }
          if (releaseSlot.isProperty()) {
            return point.set({
              slot: pointSlot,
              value: pointValue
            });
          }
        });
      }
      /**
       * @private
       * @returns {number}
       */
    }, {
      key: "$getInterval",
      value: function $getInterval() {
        return this.getWidget().properties().getValue("keepDownInterval").getMillis() || DEFAULT_INTERVAL;
      }
    }]);
  }(Binding);
});
