/*  
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * Tree JavaScript support.
 *
 * @author    Andy Frank
 * @creation  22 Aug 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// Tree
////////////////////////////////////////////////////////////////

var tree = new Tree();
function Tree() {
  ////////////////////////////////////////////////////////////////
  // Expansion
  ////////////////////////////////////////////////////////////////

  /**
   * Select/deselect all rows in table.
   */
  this.toggleExpansion = function (event) {
    // Get target element
    var elem = !event.target ? window.event.srcElement : event.target;
    elem = elem.parentNode;

    // If no children, bail out
    if (elem.childNodes.length < 5) return;

    // Determine opposite state
    var first = elem.childNodes[4];
    var vis = "visible";
    var dis = "block";
    if (first.style.visibility == "visible") {
      vis = "hidden";
      dis = "none";
    }

    // Toggle childrens state
    for (var i = 3; i < elem.childNodes.length; i++) {
      var c = elem.childNodes[i];
      if (c.nodeName != "DIV") continue;
      c.style.visibility = vis;
      c.style.display = dis;
    }
  };
}
