/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/menu/DayScheduleContextMenu
 */
define(['bajaux/commands/CommandGroup', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu'], function (CommandGroup, CommandGroupContextMenu) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // DayScheduleContextMenu
  ////////////////////////////////////////////////////////////////

  /**
   * Context menu support for a `DayEditor`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/menu/DayScheduleContextMenu
   * @extends module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/schedule/rc/fe/DayEditor} dayEditor
   */
  var DayScheduleContextMenu = function DayScheduleContextMenu(dayEditor) {
    CommandGroupContextMenu.apply(this, arguments);
  };
  DayScheduleContextMenu.prototype = Object.create(CommandGroupContextMenu.prototype);
  DayScheduleContextMenu.prototype.constructor = DayScheduleContextMenu;

  /**
   * Assemble the appropriate `Command`s for a right click on a week editor.
   * Includes one or more of `Delete Event`, `All Day Event`, `Clear Day`,
   * and/or `Schedule Defaults`, depending on the right-clicked day's
   * configuration.
   *
   * @returns {Promise.<module:bajaux/commands/CommandGroup>} resolved to a
   * `bajaux:CommandGroup`
   */
  DayScheduleContextMenu.prototype.toContextMenu = function () {
    var selectedDay = this.$ed;
    return selectedDay.readScheduleBlocks().then(function (scheduleBlocks) {
      var blockSelected = !!selectedDay.$getSelectedBlock(),
        hasBlocks = !!scheduleBlocks.length,
        commands = [];
      if (selectedDay.isEnabled() && !selectedDay.isReadonly()) {
        if (blockSelected) {
          commands.push(selectedDay.$getDeleteCommand());
        }
        commands.push(selectedDay.$getAllDayCommand());
        if (hasBlocks) {
          commands.push(selectedDay.$getClearCommand());
        }
        commands.push(selectedDay.$getScheduleDefaultsCommand());
      }
      if (blockSelected) {
        commands.push(selectedDay.$getEditCommand());
      }
      return new CommandGroup({
        commands: commands
      });
    });
  };

  /**
   * Arm a right click listener for the backing `WeekEditor`'s DOM.
   * Context menu will appear only when right-clicking a `DayEditor`.
   */
  DayScheduleContextMenu.prototype.arm = function () {
    return CommandGroupContextMenu.prototype.arm.call(this, {
      selector: '.blocksContainer'
    });
  };
  return DayScheduleContextMenu;
});
