/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/ScheduleSummaryView
 */
define(['baja!', 'lex!schedule', 'Promise', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/schedule/rc/baja/fe/ActiveDatesCalendar', 'nmodule/schedule/rc/servlets/ssc', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/util/ListSelection'], function (baja, lexs, Promise, switchboard, ActiveDatesCalendar, ssc, scheduleUtils, BaseWidget, fe, JsonObjectPropertyColumn, Row, TableModel, Table, ListSelection) {
  'use strict';

  var scheduleLex = lexs[0];
  var tpl = function tpl(ed) {
    return "\n      <div class=\"activeDates\"></div>\n      <div class=\"summaryEventsList ux-select-none\"></div>";
  };

  ////////////////////////////////////////////////////////////////
  // Schedule Summary View
  ////////////////////////////////////////////////////////////////

  /**
   * View for the Summary tab of a `WeeklySchedule`.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/schedule/rc/fe/ScheduleSummaryView
   */
  var ScheduleSummaryView = function ScheduleSummaryView(params) {
    BaseWidget.apply(this, arguments);
    switchboard(this, {
      '$onSelect': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
    this.$lastSelection = baja.Date.today();
  };
  ScheduleSummaryView.prototype = Object.create(BaseWidget.prototype);
  ScheduleSummaryView.prototype.constructor = ScheduleSummaryView;
  ScheduleSummaryView.prototype.doInitialize = function (dom) {
    var _this = this;
    dom.addClass('ScheduleSummaryView').html(tpl(this));
    function toColumn(name) {
      var column = new JsonObjectPropertyColumn(name, {
        displayName: scheduleLex.get("summary.".concat(name))
      });
      column.setSortable(false);
      return column;
    }
    var columns = ['timestamp', 'output', 'source'].map(toColumn);
    this.$model = new TableModel({
      columns: columns
    });
    var selection = new ListSelection();
    this.$activeDatesCalendar = new ActiveDatesCalendar({
      readonly: false,
      properties: {
        select: true,
        refBase: this.properties().getValue("refBase"),
        sourceOrd: this.properties().getValue("sourceOrd")
      }
    });
    this.$activeDatesCalendar.on('selectedDateChanged', function (selection) {
      _this.$lastSelection = selection;
      _this.$onSelect(selection)["catch"](baja.error);
    });
    return Promise.all([this.$activeDatesCalendar.initialize(dom.find('.activeDates')), fe.buildFor({
      dom: this.jq().find('.summaryEventsList'),
      type: Table,
      value: this.$getModel(),
      selection: selection,
      properties: {
        fixedHeaders: true
      }
    }).then(function (table) {
      _this.$table = table;
    })]);
  };
  ScheduleSummaryView.prototype.doLayout = function () {
    return this.$getActiveDatesCalendar().layout();
  };
  ScheduleSummaryView.prototype.doLoad = function (value) {
    var that = this;
    return that.$getActiveDatesCalendar().load(value).then(function () {
      return that.$getActiveDatesCalendar().selectDate(that.$lastSelection.getJsDate());
    });
  };
  ScheduleSummaryView.prototype.doDestroy = function () {
    this.jq().removeClass('ScheduleSummaryView');
    return this.getChildWidgets().destroyAll();
  };
  ScheduleSummaryView.prototype.$getActiveDatesCalendar = function () {
    return this.$activeDatesCalendar;
  };
  ScheduleSummaryView.prototype.$getTable = function () {
    return this.$table;
  };
  ScheduleSummaryView.prototype.$getModel = function () {
    return this.$model;
  };

  /**
   * Handle selectedDateChanged event from ActiveDatesCalendar.
   *
   * This function does a server side call to get the
   * @private
   * @param {baja.Date} selection - selected date
   * @return {Promise} resolves
   */
  ScheduleSummaryView.prototype.$onSelect = function (selection) {
    var _this2 = this;
    var jsEnd = selection.getJsDate();
    jsEnd.setDate(jsEnd.getDate() + 1);
    var end = baja.Date.make({
      jsDate: jsEnd
    });
    return ssc.getSummary(this.properties().getValue("sourceOrd"), scheduleUtils.appendRefBase(this.value(), this.properties().getValue('refBase')), selection, end, baja.Facets.make(this.properties().getValue('facets') || {})).then(function (summary) {
      return _this2.$getModel().removeRows(_this2.$getModel().getRows()).then(function () {
        return _this2.$getModel().insertRows(summary.map(function (summaryItem) {
          var row = new Row(summaryItem);
          row.data('output', summaryItem.output);
          row.data('source', summaryItem.source);
          row.data('timestamp', summaryItem.timestamp);
          return row;
        }));
      });
    });
  };
  return ScheduleSummaryView;
});
