/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/CustomScheduleEditor
 */
define(['nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/schedule/rc/baja/fe/DayOfMonthScheduleEnumSetEditor', 'nmodule/schedule/rc/baja/fe/MonthScheduleEnumSetEditor', 'nmodule/schedule/rc/baja/fe/WeekdayScheduleEnumSetEditor', 'nmodule/schedule/rc/baja/fe/WeekOfMonthScheduleEnumSetEditor', 'nmodule/schedule/rc/baja/fe/YearScheduleEditor', 'css!nmodule/schedule/rc/fe/schedule'], function (CompositeEditor, CompositeBuilder, DayOfMonthScheduleEnumSetEditor, MonthScheduleEnumSetEditor, WeekdayScheduleEnumSetEditor, WeekOfMonthScheduleEnumSetEditor, YearScheduleEditor) {
  'use strict';

  var tpl = function tpl(ed) {
    return "\n    <div class=\"composite-schedule-editor\">\n      <div class=\"daysOfMonth-schedule-editor\"></div>\n      <div class=\"months-schedule-editor\"></div>\n      <div class=\"weekdays-schedule-editor\"></div>\n      <div class=\"weeksOfMonth-schedule-editor\"></div>\n      <div class=\"year-schedule-editor\"></div>\n    </div>";
  };

  /**
   * Editor for a `schedule:CustomSchedule`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/CustomScheduleEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var CustomScheduleEditor = function CustomScheduleEditor() {
    CompositeEditor.apply(this, arguments);
  };
  CustomScheduleEditor.prototype = Object.create(CompositeEditor.prototype);
  CustomScheduleEditor.prototype.constructor = CustomScheduleEditor;
  CustomScheduleEditor.prototype.doInitialize = function (dom) {
    dom.html(tpl(this));
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  CustomScheduleEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['daysOfMonth', 'months', 'weekdays', 'weeksOfMonth', 'year'];
    };
    builder.getDomFor = function (key) {
      return that.jq().find('.' + key + '-schedule-editor');
    };
    builder.getValueFor = function (key) {
      var customSchedule = this.getDataSource();
      if (key === 'year') {
        return customSchedule.get('year').get('year');
      }
      return customSchedule.get(key).get('set');
    };
    var editorTypeForKey = {
      'daysOfMonth': DayOfMonthScheduleEnumSetEditor,
      'months': MonthScheduleEnumSetEditor,
      'weekdays': WeekdayScheduleEnumSetEditor,
      'weeksOfMonth': WeekOfMonthScheduleEnumSetEditor
    };
    builder.getConfigFor = function (key) {
      var customSchedule = this.getDataSource(),
        formFactor = that.getFormFactor();
      if (key === 'year') {
        return {
          complex: customSchedule.get(key),
          slot: 'year',
          type: YearScheduleEditor,
          formFactor: formFactor
        };
      }
      return {
        complex: customSchedule.get(key),
        slot: 'set',
        type: editorTypeForKey[key],
        formFactor: formFactor,
        properties: {
          singleSelection: false,
          includeGroups: key === 'daysOfMonth' || key === 'months'
        }
      };
    };
    return builder;
  };
  return CustomScheduleEditor;
});
