function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/BajaDayEditor
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/gx/rc/util/colorUtils', 'nmodule/schedule/rc/baja/fe/TimeScheduleEditor', 'nmodule/schedule/rc/baja/model/ScheduleTranslator', 'nmodule/schedule/rc/baja/util/scheduleColorUtils', 'nmodule/schedule/rc/fe/DayEditor', 'nmodule/schedule/rc/model/TimeOfDay', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, Promise, _, colorUtils, TimeScheduleEditor, ScheduleTranslator, scheduleColorUtils, DayEditor, TimeOfDay, feDialogs) {
  'use strict';

  var toRgbCssString = colorUtils.toRgbCssString,
    hsvToRgb = colorUtils.hsvToRgb,
    rgbToHsv = colorUtils.rgbToHsv,
    getStatusValueColor = scheduleColorUtils.getStatusValueColor;

  /**
   * This is a specialization of `DayEditor` that follows Niagara-specific
   * rules when creating and editing schedule blocks.
   *
   * It supports the following `bajaux` `Properties`:
   *
   * - `effectiveValue`: {baja.Struct} the currently set effective value (i.e.
   *   the value that will be set on the next created schedule block)
   * - `facets`: {baja.Facets} facets configuration data, typically from the
   *   parent Schedule, used for formatting the display text of schedule blocks.
   *
   * @class
   * @alias module:nmodule/schedule/rc/baja/fe/BajaDayEditor
   * @extends module:nmodule/schedule/rc/fe/DayEditor
   */
  var BajaDayEditor = function BajaDayEditor() {
    DayEditor.apply(this, arguments);
  };
  BajaDayEditor.prototype = Object.create(DayEditor.prototype);
  BajaDayEditor.prototype.constructor = BajaDayEditor;
  BajaDayEditor.prototype.makeBuilder = function () {
    var _this = this;
    var builder = DayEditor.prototype.makeBuilder.apply(this, arguments),
      getConfigFor = builder.getConfigFor;
    builder.getConfigFor = function (key) {
      return Promise.resolve(getConfigFor.call(builder, key)).then(function (config) {
        var scheduleBlock = builder.getValueFor(key);
        config.properties = {
          background: _this.$getBlockBackground(scheduleBlock),
          foreground: 'contrast'
        };
        return config;
      });
    };
    return builder;
  };

  /**
   * Create a new ScheduleBlock, ensuring that the value is a `baja:StatusValue`
   * and properly formatting the display string.
   *
   * @param {module:nmodule/schedule/rc/model/TimeOfDay} start
   * @param {module:nmodule/schedule/rc/model/TimeOfDay} finish
   * @param {baja.Struct} value (must be `baja:StatusValue`)
   * @returns {Promise.<module:nmodule/schedule/rc/model/ScheduleBlock>}
   */
  BajaDayEditor.prototype.createScheduleBlock = function (start, finish, value) {
    var effectiveValue = value || this.$getDefaultEffectiveValue(),
      translator = this.$getTranslator();
    return validateArgs(start, finish, effectiveValue).then(function () {
      return Promise.all([translator.fromModel(start), translator.fromModel(finish)]);
    }).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        startTime = _ref2[0],
        finishTime = _ref2[1];
      return translator.toModel(baja.$('schedule:TimeSchedule', {
        start: startTime,
        finish: finishTime,
        effectiveValue: effectiveValue.newCopy()
      }));
    });
  };

  /**
   * Edit the schedule block's start, finish, and value using a Property Sheet
   * in a dialog.
   * @param {module:nmodule/schedule/rc/fe/ScheduleBlockEditor} blockEditor
   * @returns {Promise} promise to be resolved when the user has finished
   * editing the block and its value has been updated
   */
  BajaDayEditor.prototype.editScheduleBlock = function (blockEditor) {
    var _this2 = this;
    var translator = this.$getTranslator();
    //TODO: if !translator

    return blockEditor.read().then(function (block) {
      return translator.fromModel(block);
    }).then(function (timeSchedule) {
      var facets = _this2.$getFacets();
      timeSchedule.setFacets({
        slot: 'effectiveValue',
        facets: facets
      });
      var copy = timeSchedule.newCopy();
      return feDialogs.showFor({
        properties: _.extend(_this2.$getMergedFacets().toObject(), {
          dayEditor: _this2,
          editedBlock: {
            value: blockEditor.value()
          }
        }),
        value: timeSchedule,
        type: TimeScheduleEditor,
        readonly: _this2.isReadonly(),
        enabled: _this2.isEnabled()
      }).then(function (result) {
        if (result && !timeSchedule.equivalent(copy)) {
          return _this2.$loadTimeScheduleIntoBlock(blockEditor, timeSchedule).then(function () {
            _this2.$setDefaultEffectiveValue(blockEditor.value().getValue());
            _this2.setModified(true);
          });
        }
      });
    });
  };

  /**
   * When the `facets` property changes, reload all child schedule editors so
   * their display values are properly formatted.
   */
  BajaDayEditor.prototype.doChanged = function (name, value) {
    switch (name) {
      case 'facets':
        {
          return this.$reloadScheduleBlocks();
        }
    }
  };
  BajaDayEditor.prototype.doReadonly = function (readonly) {
    var _this3 = this;
    return DayEditor.prototype.doReadonly.apply(this, arguments).then(function () {
      return _this3.$reloadScheduleBlocks();
    });
  };

  /**
   * @private
   * @returns {Promise}
   */
  BajaDayEditor.prototype.$reloadScheduleBlocks = function () {
    var _this4 = this;
    var translator = this.$getTranslator(),
      blocks = this.getChildWidgets();
    return Promise.all(blocks.map(function (block) {
      var timeSchedule = translator.fromModel(block.value());
      return _this4.$loadTimeScheduleIntoBlock(block, timeSchedule);
    }));
  };

  /**
   * @private
   * @param {module:nmodule/schedule/rc/fe/ScheduleBlockEditor} blockEditor
   * @param {baja.Component} timeSchedule a `schedule:TimeSchedule`
   */
  BajaDayEditor.prototype.$loadTimeScheduleIntoBlock = function (blockEditor, timeSchedule) {
    var _this5 = this;
    var translator = this.$getTranslator();
    return translator.toModel(timeSchedule).then(function (scheduleBlock) {
      var background = _this5.$getBlockBackground(scheduleBlock);
      blockEditor.properties().setValue('background', background);
      return blockEditor.load(scheduleBlock);
    }).then(function () {
      return _this5.$setDefaultEffectiveValue(timeSchedule.get('effectiveValue'));
    });
  };
  BajaDayEditor.prototype.$getBlockBackground = function (block) {
    var rgb = getStatusValueColor(this.$getFacets(), block.getValue());
    if (this.isReadonly()) {
      var hsv = rgbToHsv(rgb);
      hsv[1] = hsv[1] * 0.75;
      hsv[2] = hsv[2] * 0.75;
      rgb = hsvToRgb(hsv);
    }
    return toRgbCssString(rgb);
  };

  /**
   * @returns {baja.Facets}
   */
  BajaDayEditor.prototype.$getFacets = function () {
    return this.properties().getValue('facets') || baja.Facets.DEFAULT;
  };

  /**
   * @returns {baja.Facets}
   */
  BajaDayEditor.prototype.$getMergedFacets = function () {
    var toPropagate = this.properties().subset(['showSeconds', 'showMilliseconds']).toValueMap();
    return baja.Facets.make(this.$getFacets(), toPropagate);
  };
  BajaDayEditor.prototype.$getTranslator = function () {
    return new ScheduleTranslator(this.$getMergedFacets());
  };
  function validateArgs(start, finish, effectiveValue) {
    if (!(start instanceof TimeOfDay)) {
      return reject('TimeOfDay start required');
    }
    if (!(finish instanceof TimeOfDay)) {
      return reject('TimeOfDay finish required');
    }
    if (!baja.hasType(effectiveValue, 'baja:StatusValue')) {
      return reject('effectiveValue must be a baja:StatusValue');
    }
    return Promise.resolve();
  }
  function reject(msg) {
    return Promise.reject(new Error(msg));
  }
  return BajaDayEditor;
});
