function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/user/AuthenticatorMgrColumn
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/servlets/password', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, Promise, _, BaseEditor, typeUtils, password, PropertySheet, MgrColumn, PropertyMgrColumn) {
  'use strict';

  var allSameType = typeUtils.allSameType;
  var SHOULD_VALIDATE = BaseEditor.SHOULD_VALIDATE,
    VALIDATE_ON_SAVE = BaseEditor.VALIDATE_ON_SAVE;

  /**
   * Recursively set all all non-Password properties from value on target, adding if not present on target.
   *
   * @param {baja.Component} target
   * @param {baja.Complex} value
   * @param {baja.comm.Batch} batch
   * @returns {Promise}
   */
  function doSet(target, value, batch) {
    var sets = [];
    //TODO: ComplexDiff should work here, but with filtering capability to non-Passwords
    value.getSlots().properties().each(function (slot) {
      if (slot.getType().isComplex()) {
        var targetValue = target.get(slot.getName());
        if (targetValue) {
          sets.push(doSet(targetValue, value.get(slot), batch));
        } else {
          sets.push(target.add({
            slot: slot.getName(),
            value: value.get(slot).newCopy(true),
            batch: batch
          }));
        }
      } else if (!slot.getType().is('baja:Password')) {
        if (target.getSlot(slot.getName())) {
          sets.push(target.set({
            slot: slot.getName(),
            value: value.get(slot),
            batch: batch
          }));
        } else {
          sets.push(target.add({
            slot: slot.getName(),
            value: value.get(slot),
            batch: batch
          }));
        }
      }
    });
    return Promise.all(sets);
  }

  /**
   * Manager column for the `authenticator` property.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   * @alias module:nmodule/webEditors/rc/wb/util/user/AuthenticatorMgrColumn
   */
  var AuthenticatorMgrColumn = function AuthenticatorMgrColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };
  AuthenticatorMgrColumn.prototype = Object.create(PropertyMgrColumn.prototype);

  /**
   * Check to see if the user has made any modifications to a particular slot.
   * @private
   * @param {module:nmodule/webEditors/rc/wb/PropertySheetRow} sheetRow
   * @param slot the name of the slot to check
   * @returns {boolean}
   */
  AuthenticatorMgrColumn.prototype.$isPropertyChanged = function (sheetRow, slot) {
    var subSheet = sheetRow && sheetRow.$getSubPropertySheet(),
      ed = subSheet && subSheet.getBuilder().getEditorFor(slot);
    return ed && ed.isModified();
  };

  /**
   * If all rows share the same authenticator type, then a property sheet should
   * be shown to edit them as a group. Otherwise they should not be editable.
   *
   * @param {module:bajaux/Widget} ed
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @returns {boolean}
   */
  AuthenticatorMgrColumn.prototype.isEditorSuitable = function (ed, rows) {
    var _this = this;
    var authenticators = rows.map(function (row) {
      return _this.getValueFor(row);
    });
    return allSameType(authenticators) === ed instanceof PropertySheet;
  };

  /**
   * Ensure alwaysExpand is true and shouldValidate is on save.
   *
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @returns {Object}
   */
  AuthenticatorMgrColumn.prototype.getConfigFor = function (rows) {
    var config = PropertyMgrColumn.prototype.getConfigFor.apply(this, arguments);
    config.properties = _defineProperty({
      alwaysExpand: true,
      showHiddenSlots: true
    }, SHOULD_VALIDATE, VALIDATE_ON_SAVE);
    return config;
  };

  /**
   * When committing changes to an authenticator, take one of two paths
   * depending on whether we're editing an existing user, or creating a new one.
   *
   *
   * If editing an existing user, the editor's saveToComplex function is responsible
   * for handling the actual password save.
   *
   * If creating a new user, we go ahead and set the `authenticator` slot
   * wholesale. The password will be wiped off the user when writing it up
   * to the station; only after the user is created will the password itself
   * be sent to the servlet. See `UserManagerMgrModel#addInstances`.
   *
   * @param {baja.Component} authenticator the authenticator component read
   * from the `baja:PasswordAuthenticator` complex editor
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {Object} params
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise}
   */
  AuthenticatorMgrColumn.prototype.commit = function (authenticator, row, params) {
    params = params || {};
    var user = row.getSubject(),
      progressCallback = params.progressCallback;
    if (typeof authenticator.getPassword !== "function") {
      return finish(user.set({
        slot: 'authenticator',
        value: authenticator
      }));
    }
    function finish(prom) {
      if (progressCallback) {
        progressCallback(MgrColumn.COMMIT_READY);
      }
      return prom;
    }
    if (user.isMounted()) {
      // for a mounted user, we no longer need to set the passwordConfig properties outright,
      // this is currently the responsibility of UserPasswordEditor.saveToComplex.
      return finish(doSet(user.get('authenticator'), authenticator, params.batch));
    } else {
      // for a brand new user, just write everything to the authenticator
      // instance, including the password. it will get reset and validated
      // in UserManagerMgrModel#addInstances().
      return finish(user.set({
        slot: 'authenticator',
        value: authenticator
      }));
    }
  };

  /**
   * Ensure the proposed passwords meet the password strength.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel} model
   * @param {Array.<baja.Component>} auths proposed
   * `baja:AbstractAuthenticator`s
   * @param {Object} [params]
   * @returns {Promise}
   */
  AuthenticatorMgrColumn.prototype.mgrValidate = function (model, auths, params) {
    var schemes = [],
      usernames = [],
      passwords = [],
      users = [],
      rows = model.getRows(),
      nameCol = model.getColumn('__name'),
      schemeCol = model.getColumn('authenticationSchemeName'),
      hasPasswordChanges = this.$isPropertyChanged(params && params.editor, 'password');
    _.each(rows, function (row, i) {
      var user = row.getSubject();
      users.push(user);

      //for the unmounted case, an unmodified authenticator can be trouble (no password) so make sure to validate this scenario too.
      if (!user.isMounted() && !auths[i]) {
        schemes.push(schemeCol.getProposedValueFor(row));
        passwords.push('');
        usernames.push(nameCol.getProposedValueFor(row));
      }

      // we can let an invalid password slide if not modified, but only if the
      // user is already mounted
      if (auths[i] && auths[i].has('password')) {
        if (user.isMounted() && !hasPasswordChanges) {
          schemes.push(null);
          usernames.push(null);
          passwords.push(null);
        } else {
          var auth = auths[i],
            pw = auth ? auth.get('password') : '';
          schemes.push(schemeCol.getProposedValueFor(row));
          usernames.push(nameCol.getProposedValueFor(row));
          passwords.push(pw);
        }
      }
    });
    return Promise.all(passwords).then(function (passwords) {
      passwords = _.map(passwords, function (password) {
        return password === null ? null : password.encodeToString();
      });
      for (var i = 0; i < passwords.length; i++) {
        if (passwords[i] !== null) {
          return password.validatePasswords(schemes, usernames, passwords, users[i]);
        }
      }
    });
  };
  return AuthenticatorMgrColumn;
});
