function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 *
 * @module nmodule/webEditors/rc/wb/util/category/ClearConfiguredCommand
 */

define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/servlets/category', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/tree/nodeUtils', 'bajaux/commands/Command'], function (baja, $, Promise, _, feDialogs, compUtils, spaceUtils, subscriberUtils, category, PropertySheet, nodeUtils, Command) {
  'use strict';

  var partial = _.partial;
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var getCategoryService = leaseWhenNeeded(partial(resolveService, 'baja:CategoryService'));
  var getStationName = compUtils.getStationName;
  var CategoryMask = require('bajaScript/baja/obj/CategoryMask');

  /**
   * Command for clearing the configured nodes from a given node.
   * @class
   * @extends module:bajaux/commands/Command
   * @since Niagara 4.14
   * @alias module:nmodule/webEditors/rc/wb/util/category/ClearConfiguredCommand
   * @param {Object} [params] the Object Literal for the method's arguments.
   * @param {String} [params.module='wbutil'] the module to look up the command's lexicon entry.
   * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} [params.selectedNode] the node on which the command was invoked.
   * @param {module:nmodule/webEditors/rc/wb/util/category/CategoryBrowser} [params.categoryBrowser] categoryBrowser widget.
   */
  var ClearConfiguredCommand = /*#__PURE__*/function (_Command) {
    function ClearConfiguredCommand() {
      var _this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'wbutil' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'category.clearConfigured' : _ref$lex,
        _ref$selectedNode = _ref.selectedNode,
        selectedNode = _ref$selectedNode === void 0 ? null : _ref$selectedNode,
        _ref$categoryBrowser = _ref.categoryBrowser,
        categoryBrowser = _ref$categoryBrowser === void 0 ? null : _ref$categoryBrowser;
      _classCallCheck(this, ClearConfiguredCommand);
      _this = _callSuper(this, ClearConfiguredCommand, [{
        module: module,
        lex: lex,
        enabled: true,
        func: function func() {
          return _this.$clearConfiguredRows(categoryBrowser.$getTable());
        }
      }]);
      _this.$selectedNode = selectedNode;
      _this.$categoryBrowser = categoryBrowser;
      return _this;
    }

    /**
     * @private
     * @param {module:nmodule/webEditors/rc/wb/table/Table} table
     * @returns {Promise}
     */
    _inherits(ClearConfiguredCommand, _Command);
    return _createClass(ClearConfiguredCommand, [{
      key: "$clearConfiguredRows",
      value: function $clearConfiguredRows(table) {
        var _this2 = this;
        this.$categoryBrowser.updateConfiguredOrds(this.$selectedNode.$ord);
        this.$modifiedRows = [];
        var node = this.$selectedNode;
        this.$resetRow(table, node);
        return this.$resetKids(table, node).then(function () {
          table.getModel().emit('rowsChanged', _this2.$modifiedRows);
          table.setModified(true);
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
       */
    }, {
      key: "$resetRow",
      value: function $resetRow(table, node) {
        var rows = table.getModel().getRows();
        if (node.$compMask !== null && node.$compMask !== undefined) {
          //get the row
          var row = _.find(rows, function (row) {
            return row.getTreeNode().$ord === node.$ord;
          });
          if (row) {
            var treeNode = row.getTreeNode();
            //reset the row, if there is no parent then its root Node and root node category mask
            //cannot be empty and hence set to 1
            var isRoot = !node.getParent();
            var mask = node.getParent() && node.getParent().$compMask || CategoryMask.make("1");
            treeNode.$parentMask = mask;
            treeNode.$compMask = mask;
            if (!isRoot) {
              treeNode.$isInherited = true;
            }
            treeNode.$clearConfigured = true;
            this.$modifiedRows.push(row);
          }
        }
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
       * @returns {Promise}
       */
    }, {
      key: "$resetKids",
      value: function $resetKids(table, node) {
        var _this3 = this;
        if (node.$kidsLoaded) {
          return node.getKids().then(function (kids) {
            return Promise.all(kids.map(function (kid) {
              if (kid.$compMask !== null) {
                _this3.$resetRow(table, kid);
                // recursively traverse the tree
                return _this3.$resetKids(table, kid);
              }
            }));
          });
        } else {
          return Promise.resolve([]);
        }
      }

      /** Clears all the configured nodes on which the clearConfigured command was invoked.
       * @static
       * @param {module:nmodule/webEditors/rc/wb/util/category/CategoryBrowser} categoryBrowser
       * @returns {Promise.<Object>}
       */
    }], [{
      key: "clearAll",
      value: function clearAll(categoryBrowser) {
        var promises = [];
        var clearConfiguredOrds = categoryBrowser.getClearConfiguredOrds();
        var rootNodeType = categoryBrowser.value().getType();
        if (rootNodeType.is('baja:CategoryService') || rootNodeType.is('baja:Component')) {
          promises.push(ClearConfiguredCommand.clearComponentNodes(clearConfiguredOrds, categoryBrowser));
          promises.push(ClearConfiguredCommand.clearNonComponentNodes(clearConfiguredOrds));
          return Promise.all(promises).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 2),
              compNodes = _ref3[0],
              nonCompNodes = _ref3[1];
            return {
              compNodes: compNodes.compNodes,
              nonCompNodes: nonCompNodes.nonCompNodes
            };
          });
        } else {
          return ClearConfiguredCommand.clearNonComponentNodes(clearConfiguredOrds);
        }
      }
    }, {
      key: "clearComponentNodes",
      value: function clearComponentNodes(clearConfiguredOrds, widget) {
        var configuredComponentOrds = [];
        var rootNodeType = widget.value().getType();
        var rootOrd = rootNodeType.is('baja:CategoryService') ? 'station:|slot:/|' : widget.value().getParent().getNavOrd() + "|";
        //Traverse through each configured node and check if it belongs to the node on which clearConfigured command was invoked
        // reset the category mask
        return baja.Ord.make(rootOrd + "bql:select navOrd from baja:Component where not categoryMask.isNull").get({
          cursor: {
            each: function each(ord) {
              configuredComponentOrds.push(baja.Ord.make(category.toCategorizableOrd(ord.get('navOrd'))).relativizeToSession().toString());
            },
            limit: -1
          }
        }).then(function () {
          return Promise.all(configuredComponentOrds.map(function (ord) {
            if (clearConfiguredOrds.some(function (clearOrd) {
              return ord.startsWith(clearOrd);
            })) {
              return ord;
            }
          })).then(function (ords) {
            ords = _.compact(ords);
            return {
              compNodes: {
                ords: ords,
                masks: ords.map(function (o) {
                  return "";
                })
              }
            };
          });
        });
      }
    }, {
      key: "clearNonComponentNodes",
      value: function clearNonComponentNodes(clearConfiguredOrds) {
        return Promise.all([getCategoryService(), getStationName()]).then(function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 2),
            service = _ref5[0],
            stationName = _ref5[1];
          var map = service.getOrdMap();
          var ords = [],
            masks = [];
          var _loop = function _loop() {
            var ord = map.getOrd(i);
            var query = ord.parse(),
              history = query.get('history');
            var ordStr = ord.toString(),
              lowerCaseOrdStr = ordStr.toLowerCase();
            var caseSensitiveMatch = ordStr !== lowerCaseOrdStr;
            // history ord is stored in `history:^loghistory` format in ordMap,
            // but navTree stores in history:/stationName/ format
            // in case of bajaui, this conversion is done as part of HistoryCategoryUtil.convertToShorthand
            if (ordStr.startsWith('history:^')) {
              ordStr = 'history:/' + stationName.toLowerCase() + history.getBody().replace(/^\^/, '/');
              lowerCaseOrdStr = ordStr.toLowerCase();
            }
            // some ORDs saved to the CategoryService's ordMap (like history ORDs and file ORDs) are
            // in lowercase form
            // check to see if the ord in the ordMap is a descendent of a node on which ClearConfigured Command was invoked.
            if (!clearConfiguredOrds.some(function (clearOrd) {
              return caseSensitiveMatch ? ordStr.startsWith(clearOrd) : lowerCaseOrdStr.startsWith(clearOrd.toLowerCase());
            })) {
              ords.push(ord);
              masks.push(map.getCategoryMask(i));
            }
          };
          for (var i = 0, len = map.size(); i < len; ++i) {
            _loop();
          }
          return {
            nonCompNodes: {
              ords: ords,
              masks: masks
            }
          };
        });
      }
    }]);
  }(Command);
  return ClearConfiguredCommand;
});
