function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/*jshint browser: true*/

/**
 * API Status: **Private**
 *
 * Loads the Search Sidebar.
 *
 * @module nmodule/webEditors/rc/wb/profile/searchSideBar
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.profile.searchSideBar', 'Promise', 'nmodule/webEditors/rc/fe/fe', "nmodule/webEditors/rc/wb/shell/TitlePane"], function (baja, log, Promise, fe, TitlePane) {
  'use strict';

  var logError = log.severe.bind(log);

  /**
   * Loads the Search Sidebar.
   *
   * @inner
   * @private
   *
   * @param  {JQuery} dom The jQuery DOM wrapper for the DOM to load the Sidebar into.
   */
  return function load(dom) {
    dom.one("sidebar-layout", function () {
      var titlePane = new TitlePane();
      return Promise.all([fe.makeFor({
        moduleName: 'search',
        keyName: 'SearchWidget',
        type: 'search:SearchWidget',
        formFactor: 'compact'
      }), baja.Ord.make('service:search:SearchService').get(), titlePane.initialize(dom)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          searchWidget = _ref2[0],
          searchService = _ref2[1];
        return titlePane.setContentWidget(searchWidget).then(function () {
          return searchWidget.load(searchService);
        });
      })["catch"](logError);
    });
  };
});
