function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/LazyTableMixin
 */
define(['log!nmodule.webEditors.rc.wb.mixin.LazyTableMixin', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/util/ListSelection', 'nmodule/webEditors/rc/wb/mixin/mixinUtils', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel'], function (log, $, Promise, _, switchboard, ListSelection, mixinUtils, Table, TableModel) {
  'use strict';

  var MIXIN_NAME = 'LazyTable';
  var throttle = _.throttle,
    first = _.first,
    last = _.last,
    noop = _.noop;
  var applyMixin = mixinUtils.applyMixin;
  var logSevere = log.severe.bind(log);
  var SCROLL_THROTTLE_INTERVAL = 16; // 60fps

  /**
   * Adds lazy rendering behavior to a table, ensuring that only visible rows get rendered.
   *
   * There is a significant overloading of the word "row" here - throughout this class I'll use
   * "row" to mean a Row in a TableModel, and "tr" to mean a row element in an HTML table.
   *
   * @mixin
   * @alias module:nmodule/webEditors/rc/wb/mixin/LazyTableMixin
   * @extends module:nmodule/webEditors/rc/wb/table/Table
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @param {object} [params]
   * @param {function(module:nmodule/webEditors/rc/wb/table/model/Row, boolean): Promise} [params.beforeRenderingRow] optional
   * callback to run before an individual row is rendered. It will receive the Row instance, and a
   * boolean set to true if the row is rendering as a result of initially loading the Table.
   */
  var LazyTableMixin = function LazyTableMixin(table) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (!applyMixin(table, MIXIN_NAME, LazyTableMixin.prototype)) {
      return;
    }
    var _params$beforeRenderi = params.beforeRenderingRow,
      beforeRenderingRow = _params$beforeRenderi === void 0 ? noop : _params$beforeRenderi;
    switchboard(table, {
      '$setWindow': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
    table.$beforeRenderingRow = beforeRenderingRow;
    table.$predictedTrHeight = 31;
    table.on('initialized', function () {
      table.$getTableContainer().prepend('<div class="-t-LazyTableMixin-spacer-before"></div>').append('<div class="-t-LazyTableMixin-spacer-after"></div>');
      table.$getTableContainer().on('scroll', throttle(function () {
        table.$rerender()["catch"](logSevere);
      }, SCROLL_THROTTLE_INTERVAL));
    });

    // Table method overrides get applied here. methods specific to LazyTableMixin go on the prototype.
    var $doHandleRowEvent = table.$doHandleRowEvent,
      doLayout = table.doLayout;
    table.$getSelection().$getIndexFromElement = function (el) {
      return table.$trIndexToRowIndex($(el).index());
    };

    /**
     * @private
     * @override
     * @param {number} rowIndex
     * @returns {number}
     */
    table.$rowIndexToTrIndex = function (rowIndex) {
      return rowIndex - table.$currStart;
    };

    /**
     * @private
     * @override
     * @param {number} trIndex
     * @returns {number}
     */
    table.$trIndexToRowIndex = function (trIndex) {
      return trIndex + table.$currStart;
    };

    /**
     * When a row event comes through, ensure that changes get either immediately reflected or
     * marked for lazy rendering later.
     *
     * @private
     * @override
     * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} tableModel
     * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
     * @param {string} eventName
     * @param {Array.<*>} args
     * @returns {Promise}
     */
    table.$doHandleRowEvent = function (tableModel, rows, eventName, args) {
      switch (eventName) {
        case 'rowsReordered':
        case 'rowsFiltered':
          {
            var visibleRows = tableModel.$getRowsUnsafe().slice(table.$currStart, table.$currEnd);
            return table.$rebuildRowContents(tableModel, visibleRows).then(function () {
              return table.$rerender(false);
            });
          }
      }
      return $doHandleRowEvent.call(table, tableModel, rows, eventName, args).then(function () {
        return table.$rerender(false);
      });
    };

    /**
     * @override
     * @private
     * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} tableModel
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @returns {number} the index in the `tbody` of the `tr` corresponding to the given row,
     * offset by how far we've scrolled
     */
    table.$rowToTrIndex = function (tableModel, row) {
      return tableModel.getRowIndex(row) - table.$currStart;
    };

    /**
     * @override
     * @private
     * @returns {Promise}
     */
    table.$rebuildTbody = function (tableModel) {
      var firstRender = this.$getTbody(tableModel)[0].childNodes.length === 0;
      return table.$rerender(firstRender);
    };
    table.doLayout = function () {
      var _arguments = arguments;
      return table.$rerender(false).then(function () {
        return doLayout.apply(table, _arguments);
      });
    };
  };

  /**
   * @private
   * @returns {boolean} true if infinite scrolling is functional
   */
  LazyTableMixin.prototype.$isInfiniteScrolling = function () {
    return !!this.$getTableContainer().length && this.value() instanceof TableModel;
  };

  /**
   * @private
   * @returns {{start: number, end: number}} the start and end indices of rows we want to consider
   * visible
   */
  LazyTableMixin.prototype.$getPredictedVisibleRowInterval = function (tableModel) {
    var _this$$getScrollWindo = this.$getScrollWindow(),
      top = _this$$getScrollWindo.top,
      bottom = _this$$getScrollWindo.bottom;
    var trHeight = this.$getPredictedTrHeight();
    var numberOfRows = Math.floor((bottom - top) / trHeight) + 1;
    var start = Math.max(0, Math.min(tableModel.getRowCount(), Math.floor(top / trHeight)));
    return {
      start: start,
      end: start + numberOfRows
    };
  };

  /**
   * @private
   * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} tableModel
   * @param {number} start
   * @param {number} end
   * @param {boolean} firstRender
   * @returns {Promise}
   */
  LazyTableMixin.prototype.$setWindow = function (tableModel, start, end, firstRender) {
    var _this = this;
    var prevStart = typeof this.$currStart === 'number' ? this.$currStart : 0;
    var prevEnd = this.$currEnd;
    var tbody = this.$getTbody(tableModel);
    var tableContainer = this.$getTableContainer();
    var renderedTrs = tbody.children();
    var renderedRows = renderedTrs.map(function (i, el) {
      return $(el).data('row');
    }).get();
    var renderedRowIndices = renderedRows.map(function (row) {
      return tableModel.getRowIndex(row);
    });

    // excluding any rows that are currently rendered, but have been removed from the TableModel
    var stillPresentRenderedIndices = renderedRowIndices.filter(function (i) {
      return i >= 0;
    });
    var lastRowIndex = tableModel.getRowCount();
    var renderBuffer = this.$getRenderBuffer();
    if (stillPresentRenderedIndices.length) {
      // when comparing against the previous render, "bring it in" in case rows were added or
      // removed. like if i rendered 0-5, but row 5 is now gone, consider myself as having rendered
      // 0-4.
      prevStart = Math.max(prevStart, first(stillPresentRenderedIndices));
      prevEnd = Math.min(prevEnd, last(stillPresentRenderedIndices) + 1);
    }
    var firstIndexToRender = start - renderBuffer;
    var lastIndexToRender = end + renderBuffer;

    // if the render window is off the top or bottom, shift it towards the center, so we always
    // render the maximum number of rows.
    if (firstIndexToRender < 0) {
      lastIndexToRender -= firstIndexToRender;
      firstIndexToRender = 0;
    } else if (lastIndexToRender > lastRowIndex) {
      var delta = lastIndexToRender - lastRowIndex;
      lastIndexToRender -= delta;
      firstIndexToRender -= delta;
    }
    lastIndexToRender = Math.min(lastIndexToRender, lastRowIndex);
    var trIndicesToDestroy = [];
    renderedRowIndices.forEach(function (renderedIndex, i) {
      if (renderedIndex < 0 || renderedIndex < firstIndexToRender || renderedIndex >= lastIndexToRender) {
        trIndicesToDestroy.push(i);
      }
    });
    var rowIndicesToPrepend;
    var rowIndicesToAppend;
    if (typeof prevEnd !== 'number') {
      // first render
      rowIndicesToPrepend = [];
      rowIndicesToAppend = range(firstIndexToRender, lastIndexToRender);
    } else {
      rowIndicesToPrepend = range(firstIndexToRender, Math.min(prevStart, lastIndexToRender));
      rowIndicesToAppend = range(Math.max(prevEnd, firstIndexToRender), lastIndexToRender);
    }
    var afterTableUpdated = function afterTableUpdated() {
      var numberOfUnrenderedRowsAbove = firstIndexToRender;
      var numberOfUnrenderedRowsBelow = lastRowIndex - lastIndexToRender;
      var numberOfRenderedRows = tbody.children().length;
      var trHeight;
      if (numberOfRenderedRows) {
        trHeight = _this.$predictedTrHeight = tbody.innerHeight() / numberOfRenderedRows;
      } else {
        trHeight = _this.$predictedTrHeight;
      }
      tableContainer.children('.-t-LazyTableMixin-spacer-before').css('height', numberOfUnrenderedRowsAbove * trHeight + 'px');
      tableContainer.children('.-t-LazyTableMixin-spacer-after').css('height', numberOfUnrenderedRowsBelow * trHeight + 'px');
    };
    var prom = this.$renderTableRows({
      tableModel: tableModel,
      tbody: tbody,
      rowIndicesToPrepend: rowIndicesToPrepend,
      rowIndicesToAppend: rowIndicesToAppend,
      trIndicesToDestroy: trIndicesToDestroy,
      firstRender: firstRender,
      afterTableUpdated: afterTableUpdated
    });

    // set this AFTER because $removeRows etc. rely on it still being set to the previous value.
    this.$currStart = firstIndexToRender;
    this.$currEnd = lastIndexToRender;
    return prom;
  };

  /**
   * Perform the work of adding/removing/rebuilding rows to show the current values.
   *
   * @private
   * @param {object} params
   * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} params.tableModel
   * @param {JQuery} params.tbody
   * @param {number[]} params.rowIndicesToPrepend
   * @param {number[]} params.rowIndicesToAppend
   * @param {number[]} params.trIndicesToDestroy
   * @param {boolean} params.firstRender
   * @param {function} params.afterTableUpdated
   * @returns {Promise}
   */
  LazyTableMixin.prototype.$renderTableRows = function (_ref) {
    var _this2 = this;
    var tableModel = _ref.tableModel,
      tbody = _ref.tbody,
      rowIndicesToPrepend = _ref.rowIndicesToPrepend,
      rowIndicesToAppend = _ref.rowIndicesToAppend,
      trIndicesToDestroy = _ref.trIndicesToDestroy,
      firstRender = _ref.firstRender,
      afterTableUpdated = _ref.afterTableUpdated;
    var columns = tableModel.getColumns();
    var selection = this.$getSelection();
    var rowsToPrepend = rowIndicesToPrepend.map(function (i) {
      return tableModel.getRow(i);
    });
    var rowsToAppend = rowIndicesToAppend.map(function (i) {
      return tableModel.getRow(i);
    });
    var allRowsToAdd = rowsToPrepend.concat(rowsToAppend);
    var toTableRow = function toTableRow(rowIndex) {
      return _this2.$toTableRow(tableModel, columns, tableModel.getRow(rowIndex), selection.isSelected(rowIndex));
    };
    return Promise.all(allRowsToAdd.map(function (row) {
      return _this2.$beforeRenderingRow(row, firstRender);
    })).then(function () {
      return Promise.all([Promise.all(rowIndicesToPrepend.map(toTableRow)), Promise.all(rowIndicesToAppend.map(toTableRow)), _this2.$removeRows(tableModel, trIndicesToDestroy)]);
    }).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        trsToPrepend = _ref3[0],
        trsToAppend = _ref3[1];
      function rebuildIfPossible(existingTr, newTrs, rowIndicesToRender) {
        var row = $(existingTr).data('row');
        var existingIndex = tableModel.getRowIndex(row);
        if (rowIndicesToRender.includes(existingIndex)) {
          var renderedIndex = rowIndicesToRender.indexOf(existingIndex);
          $(existingTr).replaceWith(newTrs[renderedIndex]);
          rowIndicesToRender.splice(renderedIndex, 1);
          newTrs.splice(renderedIndex, 1);
          return true;
        }
      }
      tbody.children().each(function (i, existingTr) {
        if (!rebuildIfPossible(existingTr, trsToPrepend, rowIndicesToPrepend)) {
          rebuildIfPossible(existingTr, trsToAppend, rowIndicesToAppend);
        }
      });
      tbody.prepend(trsToPrepend);
      tbody.append(trsToAppend);
      afterTableUpdated();
    });
  };

  /**
   * How many extra rows on each side should we render to minimize pop-in?
   * @private
   * @returns {number}
   */
  LazyTableMixin.prototype.$getRenderBuffer = function () {
    return 10;
  };

  /**
   * @private
   * @param {boolean} [firstRender]
   * @returns {Promise}
   */
  LazyTableMixin.prototype.$rerender = function (firstRender) {
    var tableModel = this.getModel();
    if (!tableModel) {
      return Promise.resolve(); // not loaded yet
    }
    var _this$$getPredictedVi = this.$getPredictedVisibleRowInterval(tableModel),
      start = _this$$getPredictedVi.start,
      end = _this$$getPredictedVi.end;
    return this.$setWindow(tableModel, start, end, firstRender);
  };

  /**
   * @private
   * @returns {number}
   */
  LazyTableMixin.prototype.$getPredictedTrHeight = function () {
    // TODO: calculate
    // TODO: what happens when row height is not uniform?
    return this.$predictedTrHeight;
  };

  /**
   * @private
   * @returns {{top: number, bottom: number}} top and bottom pixels of the current table scroll
   * window
   */
  LazyTableMixin.prototype.$getScrollWindow = function () {
    var tableContainer = this.$getTableContainer();
    var top = tableContainer.scrollTop();
    var bottom = top + tableContainer.outerHeight();
    return {
      top: top,
      bottom: bottom
    };
  };

  /**
   * @param {number} start
   * @param {number} end
   * @returns {number[]} empty if start >= end (cannot use underscore for this behavior)
   */
  function range(start, end) {
    var arr = [];
    for (var i = start; i < end; ++i) {
      arr.push(i);
    }
    return arr;
  }
  return LazyTableMixin;
});
