/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/SelectAllCommand
 */
define(['baja!', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/mgrUtils'], function (baja, Promise, _, Command, feDialogs, BatchComponentEditor, mgrUtils) {
  'use strict';

  var getLearnTableSelection = mgrUtils.getLearnTableSelection;

  /**
   * Command for selecting all discovered items.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/SelectAllCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} mgr
   */
  var SelectAllCommand = function SelectAllCommand(mgr) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.selectAll',
      enabled: true,
      // no flags configured, because SelectAllCommand is injected by MgrLearn itself

      /**
       * When this command is invoked, all the rows in the discovery table should be selected
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/SelectAllCommand#invoke
       */
      func: function func() {
        var rowCnt = mgr.getLearnModel().getRowCount();
        var selection = getLearnTableSelection(mgr);
        selection.select(0, rowCnt);
      }
    });
  };
  SelectAllCommand.prototype = Object.create(Command.prototype);
  SelectAllCommand.prototype.constructor = SelectAllCommand;
  return SelectAllCommand;
});
