function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/NewCommand
 */
define(['baja!', 'lex!webEditors', 'bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn'], function (baja, lexs, Command, Promise, _, compUtils, feDialogs, PropertySheet, MgrCommand, BatchComponentEditor, MgrTypeInfo, MgrModel, TypeMgrColumn) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var ALL_BARS = MgrCommand.flags.ALL_BARS;

  /**
   * Command for adding new components to a Manager view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/NewCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager the manager that is this
   * NewCommand is for
   */
  var NewCommand = /*#__PURE__*/function (_Command) {
    function NewCommand(manager) {
      var _this;
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'webEditors' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'commands.mgr.new' : _ref$lex;
      _classCallCheck(this, NewCommand);
      return _this = _callSuper(this, NewCommand, [{
        module: module,
        lex: lex,
        flags: ALL_BARS,
        /**
         * Add new components to the Manager view. First shows a dialog asking
         * for the type of component to add and how many, then a manager editor
         * allowing the components to be configured before adding.
         *
         * @alias module:nmodule/webEditors/rc/wb/mgr/commands/NewCommand#invoke
         * @returns {Promise}
         */
        func: function func() {
          var mgrModel = manager.getModel();
          return manager.getOrdBase().then(function (ordBase) {
            return Promise.resolve(_this.$createInstancesToAdd(manager, ordBase)).then(function (result) {
              if (!result) {
                return;
              }
              var newInstances = result.newInstances,
                params = result.params;
              return newInstances && _this.$editNewComponents(manager, newInstances, ordBase, params);
            }).then(function (comps) {
              return comps && mgrModel.addInstances(comps);
            });
          })["catch"](feDialogs.error);
        }
      }]);
    }

    /**
     * Creates the new instances that are to be added to the manager's model.  By default, it creates
     * a PropertySheet that it uses to prompt for the type and number of instances, but can be
     * modified to prompt for other information or if the type and number is known can just return the
     * new instance(s) to be added.
     * @private
     * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager the manager that is attached to
     * this NewCommand
     * @param {baja.Component} [ordBase]
     * @returns {Promise<{newInstances: Array<baja.Value>, params:NewCommand~params}|undefined>}
     */
    _inherits(NewCommand, _Command);
    return _createClass(NewCommand, [{
      key: "$createInstancesToAdd",
      value: function $createInstancesToAdd(manager, ordBase) {
        var _this2 = this;
        var model = manager.getModel();
        var newTypes = model.getNewTypes();
        MgrTypeInfo.markDuplicates(newTypes);
        var comp = this.$makeComponent(newTypes);
        var instanceParams;
        return feDialogs.showFor({
          value: comp,
          type: PropertySheet,
          properties: {
            showHeader: false,
            showControls: false,
            ordBase: ordBase
          },
          buttons: {
            ok: function ok(dialog, event, editor) {
              return editor.save().then(function () {
                return _this2.$getValues(newTypes, comp);
              }).then(function (params) {
                instanceParams = params;
                return _this2.$makeNewInstances(manager, params);
              }).then(function (newInstances) {
                return {
                  newInstances: newInstances,
                  params: instanceParams
                };
              })["catch"](function (error) {
                dialog.keepOpen();
                feDialogs.error(error);
              });
            },
            cancel: {}
          }
        });
      }

      /**
       * To query the user for what type of new components to create, and how
       * many, a PropertySheet will be shown in a dialog. This component contains
       * the necessary fields to load into that PropertySheet.
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>} newTypes an
       * array of `MgrTypeInfo` instances, for the types that will be presented to the
       * user to choose from.
       * @returns {baja.Component}
       */
    }, {
      key: "$makeComponent",
      value: function $makeComponent(newTypes) {
        var newTypesEnum = baja.DynamicEnum.make({
          range: baja.EnumRange.make({
            ordinals: _.map(newTypes, function (type, i) {
              return i;
            }),
            tags: _.map(_.invoke(newTypes, 'getDisplayName'), baja.SlotPath.escape)
          })
        });
        var comp = baja.$('baja:Component', {
          newTypes: newTypesEnum,
          count: baja.Integer.make(1),
          displayNames: baja.NameMap.make({
            newTypes: webEditorsLex.get('commands.mgr.add.type'),
            count: webEditorsLex.get('commands.mgr.add.count')
          })
        });
        comp.setFacets({
          slot: 'count',
          facets: baja.Facets.make({
            min: 1,
            max: 100
          })
        });
        comp.setFacets({
          slot: 'newTypes',
          facets: baja.Facets.make({
            uxFieldEditor: 'webEditors:FrozenEnumEditor'
          })
        });
        comp.setFlags({
          slot: 'displayNames',
          flags: baja.Flags.HIDDEN
        });

        // noinspection JSValidateTypes
        return comp;
      }

      /**
       * This is the parameterized result of the `$getValues` method which is passed to various other methods
       * to obtain any extra parameters.
       * @typedef {Object} NewCommand~params
       * @property {Number} count
       * @property {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
       */

      /**
       * Returns the values that the user entered as an object
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>} newTypes the
       * new types to choose from
       * @param {baja.Component} comp the component the values were entered into
       * @returns {NewCommand~params} the return values
       */
    }, {
      key: "$getValues",
      value: function $getValues(newTypes, comp) {
        var object = compUtils.toObject(comp, {
          filter: function filter(slot) {
            var name = slot.getName();
            return !(name === 'newTypes' || name === 'displayNames');
          }
        });
        object.count = object.count.valueOf();
        object.typeInfo = newTypes[comp.get('newTypes').getOrdinal()];
        return object;
      }

      /**
       * When loading up the `BatchComponentEditor`, a secondary `MgrModel` will be
       * constructed solely for the components being edited. After editing the
       * components, they will be applied back to the original `MgrModel`.
       * @private
       * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} mgr the `Manager` to
       * which we're adding components
       * @param {NewCommand~params} params parameters passed to ManagerModel.newInstances that control the type,
       * how many and any other parameters that are needed to create new instances for the model.
       * @returns {Promise.<Array.<baja.Value>>} promise to be resolved with a new array containing the
       * instances to be added.
       */
    }, {
      key: "$makeNewInstances",
      value: function $makeNewInstances(mgr, params) {
        var mgrModel = mgr.getModel();
        return mgrModel.newInstances(params);
      }

      /**
       * After determining what type of components to add and how many, show a
       * `BatchComponentEditor` allowing the user to make changes to the new
       * instances.
       * @inner
       * @param {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel} mgrModel The manger model used
       * as a template for creating a model used for editing.
       * @param {Array<baja.Value>} instances The array that holds the new instances that have been
       * created
       * @param {baja.Component} [ordBase]
       * @param {NewCommand~params} params
       * @returns {Promise<Array<baja.Component>>} promise to be resolved with an array of
       * new `Component` instances, or `null` if `BatchComponentEditor` dialog was
       * canceled
       */
    }, {
      key: "$editNewComponents",
      value: function $editNewComponents(mgrModel, instances, ordBase, params) {
        return this.$makeModelFromNewInstances(mgrModel, instances, params).then(function (model) {
          return feDialogs.showFor({
            value: model,
            properties: {
              ordBase: ordBase
            },
            type: BatchComponentEditor
          });
        }).then(function (model) {
          return model && _.map(model.getRows(), function (row) {
            return row.getSubject();
          });
        });
      }

      /**
       * Takes the new instances as an array and converts them into a Manger Model for editing
       * in a batch component editor
       * @private
       * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} mgr the `Manager` to
       * which we're adding components
       * @param {Promise.<Array.<baja.Value>>} instances an array containing the new instances to be added
       * @param {NewCommand~params} params
       * @returns {Promise<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>} promise to be resolved
       * with a new MgrModel` containing the new instances to edit
       */
    }, {
      key: "$makeModelFromNewInstances",
      value: function $makeModelFromNewInstances(mgr, instances, params) {
        var _this3 = this;
        var mgrModel = mgr.getModel();
        var newTypes = mgrModel.getNewTypes();
        var origContainer = mgr.value();
        var source = baja.$('baja:Folder');
        return Promise.all(instances.map(function (instance, index) {
          return MgrTypeInfo.make({
            from: [instance.getType().getTypeSpec()],
            concreteTypes: false
          }).then(function (typeInfo) {
            var slotName;
            var defaultSlotName = _this3.$makeDefaultSlotName(instance, typeInfo[0], params, index);
            var uniqueName = origContainer.getUniqueName(defaultSlotName);
            var slotNum = uniqueName.match(/\d*$/)[0] || 0;
            uniqueName = uniqueName.replace(/\d*$/, '');
            while (origContainer.has(slotName = uniqueName + (slotNum || '')) || source.has(slotName = uniqueName + (slotNum || ''))) {
              slotNum++;
            }
            return source.add({
              slot: slotName,
              value: instance
            });
          });
        })).then(function () {
          var model = new MgrModel({
            componentSource: source,
            columns: mgrModel.getEditableColumns()
          });
          _.each(model.getRows(), function (row) {
            TypeMgrColumn.setAvailableTypes(row, newTypes);
          });
          return model;
        });
      }

      /**
       * @private
       * @param {baja.Value} instance
       * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
       * @param {NewCommand~params} params the params generated from the initial dialog
       * @param {Number} index index of component to add
       * @returns {String}
       */
    }, {
      key: "$makeDefaultSlotName",
      value: function $makeDefaultSlotName(instance, typeInfo, params, index) {
        return typeInfo.toSlotName();
      }
    }]);
  }(Command);
  return NewCommand;
});
