/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/DiscoverCommand
 */
define(['bajaux/commands/Command', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (Command, MgrCommand) {
  'use strict';

  var ALL_BARS = MgrCommand.flags.ALL_BARS;

  /**
   * Command type for kicking off the learn process on a manager view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/DiscoverCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} manager
   */
  var DiscoverCommand = function DiscoverCommand(manager) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.discover',
      flags: ALL_BARS,
      /**
       * Call the discover() function on the manager. This will in turn call
       * the user provided doDiscover() function.
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/DiscoverCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        return manager.discover();
      }
    });
  };
  DiscoverCommand.prototype = Object.create(Command.prototype);
  DiscoverCommand.prototype.constructor = DiscoverCommand;
  return DiscoverCommand;
});
