/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 */

/* jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/AllDescendantsCommand
 */
define(['baja!', 'lex!webEditors', 'underscore', 'Promise', 'dialogs', 'bajaux/commands/ToggleCommand', 'nmodule/webEditors/rc/wb/mixin/mixinUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'baja!baja:Folder'], function (baja, lexs, _, Promise, dialogs, ToggleCommand, mixinUtils, MgrCommand) {
  'use strict';

  var _MgrCommand$flags = MgrCommand.flags,
    MENU_BAR = _MgrCommand$flags.MENU_BAR,
    TOOL_BAR = _MgrCommand$flags.TOOL_BAR;

  /**
   * Reload the manager's model for a change in the required depth. Will show the loading
   * dialog if necessary.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} mgr - the manager
   * @param {boolean} flattened - whether or not to load the flattened folder hierarchy.
   *
   * @returns {Promise.<*>}
   */
  function reloadModelDepth(mgr, flattened) {
    var model = mgr.getModel(),
      promise;
    promise = model.setAllDescendants(mgr, flattened).then(function () {
      return model.reloadForNewFolderDepth();
    }).then(function () {
      return mgr.resubscribeForNewFolderDepth();
    });
    dialogs.showLoading(500, promise);
    return promise;
  }

  /**
   * Command for toggling a flattened/non-flattened view of the components
   * within a hierarchy of folders.
   *
   * This command requires the folder manager mixin to be applied to the
   * manager model; an error will be thrown if it is not.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/AllDescendantsCommand
   * @extends module:bajaux/commands/ToggleCommand
   * @mixes module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager - the manager
   */
  var AllDescendantsCommand = function AllDescendantsCommand(manager) {
    var that = this;
    ToggleCommand.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.allDescendants',
      selected: manager ? manager.isAllDescendantsSelected() : false,
      enabled: true,
      flags: MENU_BAR | TOOL_BAR,
      func: function func() {
        if (!mixinUtils.hasMixin(manager.getModel(), 'FOLDER_MGR_MODEL')) {
          throw new Error('Manager model must have the folderMgrModelMixin applied');
        }
        that.toggle();
        manager.setAllDescendantsSelected(that.isSelected());
        return reloadModelDepth(manager, that.isSelected());
      }
    });
  };
  AllDescendantsCommand.prototype = Object.create(ToggleCommand.prototype);
  AllDescendantsCommand.prototype.constructor = AllDescendantsCommand;
  return AllDescendantsCommand;
});
