function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/links/OrdChooser
 */
define(['baja!', 'jquery', 'lex!baja,webEditors', 'log!nmodule.webEditors.rc.wb.links.OrdChooser', 'bajaux/commands/Command', 'bajaux/events', 'bajaux/util/CommandButton', 'bajaux/util/CommandButtonGroup', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/util/textUtils', 'nmodule/webEditors/rc/wb/commands/GoToCommand', 'nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode', 'nmodule/webEditors/rc/wb/tree/BajaNavTreeNode', 'nmodule/webEditors/rc/wb/tree/NavTree', 'nmodule/webEditors/rc/wb/tree/nodeUtils', 'nmodule/webEditors/rc/wb/tree/stationTree', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'hbs!nmodule/webEditors/rc/wb/links/template/OrdChooser'], function (baja, $, lexs, log, Command, events, CommandButton, CommandButtonGroup, Widget, Promise, _, switchboard, fe, BaseEditor, BooleanEditor, IconEditor, spaceUtils, htmlUtils, textUtils, GoToCommand, BajaComplexTreeNode, BajaNavTreeNode, NavTree, nodeUtils, stationTree, TreeNode, tplOrdChooser) {
  'use strict';

  var ordUtil = require('bajaScript/baja/ord/ordUtil');
  var NavNodeContainer = require('bajaScript/baja/nav/NavNodeContainer');
  var VALUE_READY_EVENT = BaseEditor.VALUE_READY_EVENT,
    SESSION_NODE_NAME = stationTree.SESSION_NODE_NAME,
    DEFAULT_ORD = baja.Ord.DEFAULT,
    makeOrd = baja.Ord.make,
    bajaLex = lexs[0],
    webEditorsLex = lexs[1],
    logError = log.severe.bind(log),
    resolveStation = spaceUtils.resolveStation,
    selectOnFocus = htmlUtils.selectOnFocus,
    selectAll = htmlUtils.selectAll,
    ROOT_NODE_PROPERTY = 'rootNode',
    SELECT_FILTER_PROPERTY = 'selectFilter',
    DISPLAY_FILTER_PROPERTY = 'displayFilter',
    getDisplayName = textUtils.ordTargetToDisplayName,
    MODIFY_EVENT = events.MODIFY_EVENT,
    getOrdViewQuerySplit = ordUtil.getOrdViewQuerySplit;
  var isNavNode = nodeUtils.isNavNode,
    ordToPath = nodeUtils.ordToPath,
    navNodeToTreeNode = nodeUtils.navNodeToTreeNode,
    ordToTreeNode = nodeUtils.ordToTreeNode;

  ////////////////////////////////////////////////////////////////
  // Utility functions
  ////////////////////////////////////////////////////////////////
  function getIcon(ordTarget) {
    var object = ordTarget.object,
      slot = ordTarget.slot;
    //TODO: baja.File#getNavIcon
    if (isNavNode(object) && object.getNavIcon) {
      return object.getNavIcon();
    }
    return object || slot;
  }

  /**
   * Get the ORD described by an ORD target.
   *
   * @param {Object} ordTarget ORD target (from `baja.Ord#resolve`)
   * @returns {baja.Ord}
   */
  function getTargetOrd(ordTarget) {
    var comp = ordTarget.getComponent() || ordTarget.getObject(),
      ord = String(comp && comp.getNavOrd());
    if (ordTarget.propertyPath) {
      if (ord.charAt(ord.length - 1) !== '/') {
        ord += '/';
      }
      ord += ordTarget.propertyPath.join('/');
    } else if (ordTarget.slot) {
      if (ord.charAt(ord.length - 1) !== '/') {
        ord += '/';
      }
      ord += ordTarget.slot;
    }
    return makeOrd(ord);
  }

  /**
   * Takes the provided ord and resolves the handle ord if one is available.
   *
   * If not, the provided ord will be resolved.
   *
   * @param {baja.Ord} providedOrd
   * @returns {Promise.<baja.Ord>}
   */
  function resolveHandleOrd(providedOrd) {
    if (!isSlotOrd(providedOrd)) {
      return Promise.resolve(providedOrd);
    }
    return providedOrd.get().then(function (obj) {
      if (!baja.hasType(obj, 'baja:Component')) {
        return providedOrd;
      }
      return makeOrd('h:' + obj.getHandle());
    });
  }

  /**
   * @param {baja.Ord} ord
   * @returns {boolean}
   */
  function isHierarchyOrd(ord) {
    try {
      return !!ord.parse().get('hierarchy');
    } catch (e) {
      return false;
    }
  }

  /**
   * @param {baja.Ord} ord
   * @returns {boolean}
   */
  function isHistoryOrd(ord) {
    try {
      return !!ord.parse().get('history');
    } catch (e) {
      return false;
    }
  }

  /**
   * @param {baja.Ord} ord
   * @returns {boolean}
   */
  function isSlotOrd(ord) {
    try {
      return !!ord.parse().get('slot');
    } catch (e) {
      return false;
    }
  }

  /**
   * @since Niagara 4.14
   * @param {baja.Ord} ord
   * @returns {boolean}
   */
  function isModuleOrd(ord) {
    try {
      return !!ord.parse().get('module');
    } catch (e) {
      return false;
    }
  }

  /**
   * @param {baja.Ord} ord
   * @returns {boolean}
   */
  function isLastQueryAHandleQuery(ord) {
    try {
      var ordWithoutViewQuery = getOrdViewQuerySplit(ord).ord;
      var list = ordWithoutViewQuery.parse(),
        listSize = list.size();
      if (listSize === 0) {
        return false;
      }
      return list.get(listSize - 1).getSchemeName() === 'h';
    } catch (e) {
      return false;
    }
  }

  /**
   * Get the raw ORD display string.
   *
   * @param {Object} ordTarget ORD target (from `baja.Ord#resolve`)
   * @param {baja.Ord} origOrd the ORD from which the target was resolved
   * @returns {string}
   */
  function getOrdDisplay(ordTarget, origOrd) {
    var ord;
    if (isHierarchyOrd(origOrd) || isHistoryOrd(origOrd)) {
      //for a history or hierarchy ord, always use the original, not an ord derived from
      //the resolved component in the station
      ord = origOrd;
    } else {
      ord = getTargetOrd(ordTarget);
      ord = sanitizeOrd(ord);
    }
    return String(relativize(ord));
  }

  /**
   * Find the path to a NavNode with the given Ord.
   *
   * @param {baja.Ord} ord the ord we are searching for
   * @param {baja.NavNode} parent the parent node to search on
   * @param {Array.<String>} path strings representing the name of the nodes already traversed
   * @returns {Promise.<Array.<String>>} the names of the nodes traversed to get to the matching
   * node if found
   */
  function resolvePathFromNavNode(ord, parent) {
    var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [SESSION_NODE_NAME];
    if (parent.getNavOrd().equals(ord)) {
      return Promise.resolve(path.concat(parent.getNavName()));
    } else {
      return parent.getNavChildren().then(function (kids) {
        if (!kids) {
          return null;
        }
        return Promise.all(kids.map(function (kid) {
          return resolvePathFromNavNode(ord, kid, path.concat(parent.getNavName()));
        }));
      }).then(_.find);
    }
  }

  /**
   * Given a tree node (gotten from the component tree when a node is selected
   * by the user), convert it to the corresponding ORD.
   *
   * @param {module:nmodule/webEditors/rc/wb/tree/BajaNavTreeNode} node
   * @param {baja.Ord} [baseOrd]
   * @param {boolean} [showModules] optional flag to remove the duplicate root
   * @returns {baja.Ord|undefined} ORD derived from the selected node's path,
   * or undefined if no actual ORD is selected
   */
  function nodeToOrd(node, baseOrd, showModules) {
    var value = node.value();
    if (isNavNode(value) && typeof value.getNavOrd === 'function') {
      return relativize(value.getNavOrd());
    }
    var path = node.getFullPath();
    if (showModules) {
      path = path.slice(1);
    }
    var ord = path[1]; //start from index 1 - skip root node from stationTree

    switch (ord) {
      case 'file':
        ord = 'file:^';
        break;
    }
    if (!ord) {
      return DEFAULT_ORD;
    } else {
      if (baseOrd) {
        ord = baseOrd.toString() + "/";
      }
      var fullPath = ord + path.slice(2).join('/');
      if (fullPath.charAt(fullPath.length - 1) === '/') {
        fullPath = fullPath.substr(0, fullPath.length - 1);
      }
      return relativize(fullPath);
    }
  }

  /**
   * @param {baja.Ord|string} ord
   * @returns {baja.Ord}
   */
  function relativize(ord) {
    return makeOrd(ord).relativizeToSession();
  }

  /**
   * Return true if the given ORD can be resolved against the station.
   *
   * @param {baja.Ord} ord
   * @param {boolean} isUnMountedRootNode
   * @returns {boolean}
   */
  function shouldResolve(ord, isUnMountedRootNode) {
    // For remote config space we don't want to resolve the Ord
    if (!ord || isUnMountedRootNode) {
      return false;
    }
    try {
      var list = ord.parse();
      return !!(list.get('slot') || list.get('h') || list.get('file') || list.get('hierarchy') || list.get('history'));
    } catch (e) {
      return false;
    }
  }

  /**
   * Removes all queries that come after a file: query.
   *
   * @param {baja.Ord} ord
   * @returns {baja.Ord}
   */
  function sanitizeOrd(ord) {
    var queries = ord.parse();
    if (!queries.get('file')) {
      return ord;
    } else {
      // for file queries remove all the other queries that come file: query
      // as ordChooser needs to show only the file
      var fileIndex = -1;
      //get the file query index
      for (var i = 0; i < queries.size(); ++i) {
        if (queries.get(i).getSchemeName() === 'file') {
          fileIndex = i;
          break;
        }
      }
      //remove all the other queries
      var startIndex = fileIndex + 1;
      while (queries.size() > startIndex) {
        queries.remove(startIndex);
      }
      return makeOrd(queries.toString());
    }
  }

  ////////////////////////////////////////////////////////////////
  // Commands
  ////////////////////////////////////////////////////////////////

  var ChangeCommand = function ChangeCommand(ordChooser) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'OrdChooser.changeCommand',
      func: function func() {
        return ordChooser.$toggleNavTree();
      }
    });
  };
  ChangeCommand.prototype = Object.create(Command.prototype);
  ChangeCommand.prototype.constructor = ChangeCommand;
  var HyperlinkCommand = function HyperlinkCommand(ordChooser) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'OrdChooser.hyperlinkCommand',
      func: function func() {
        return ordChooser.read().then(function (ord) {
          return niagara.env.hyperlink(String(ord));
        });
      }
    });
  };
  HyperlinkCommand.prototype = Object.create(Command.prototype);
  HyperlinkCommand.prototype.constructor = HyperlinkCommand;

  ////////////////////////////////////////////////////////////////
  // OrdChooser definition
  ////////////////////////////////////////////////////////////////

  /**
   * Editor to allow the user to choose an ORD using a component tree retrieved
   * from the station.
   *
   * It supports the following bajaux properties:
   *
   * - `showOrdText`: set to `false` to cause the raw text of the ORD to be
   *   hidden. The user will not be able to type an ORD but must select one
   *   from the tree. Only the name of the tree node will be shown. Note that
   *   this property only applies with form factor `compact`.
   * - `rootNode`:  An ord, ord string to target a specific part of the station, files,
   *    or hierarchy. Example: file:^folder would make folder the top level node
   *    for OrdChooser. Alternatively, can also be the Nav Node itself, and be directly used
   *    to display its Nav children.  If this is set the NavTree, if there is one, will have its
   *    hideRoot property set to true, unless hideRoot is set. Then hideRoot will be used.
   * - `selectFilter`: A function that returns a promise that resolves if an
   *    element meets selection criteria, and it rejects if not.
   * - `displayFilter`: A function that returns true if an element should be
   *    displayed, false if not. Parameters are as follows:
   *    function({module:nmodule/webEditors/rc/wb/tree/TreeNode} : parent,
   *            {module:nmodule/webEditors/rc/wb/tree/TreeNode} : child)
   * - 'hideRoot' : A boolean that tells the NavTree if it should hide root or not.  This is
   *    passed to the NavTree.
   * - 'showModules' : An optional boolean that can be set to `false` to hide the modules portion of the tree.
   *    The default value is to show the modules (true).
   * - 'forceOrdType' : An optional string that can be used to force the ord type selecion type.
   *    Options include 'slot', 'handle' and ''. If no string is provided then the ordType can be
   *    modified by the user.
   * - 'hideOrdType' : An optional boolean that tells the editor if it should hide the ord type
   *    selector(true) or maintain the default behaviour(false)
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/wb/links/OrdChooser
   *
   */
  var OrdChooser = function OrdChooser() {
    BaseEditor.apply(this, arguments);
    switchboard(this, {
      '$initializeNavTree': {
        allow: 'once',
        onRepeat: 'returnLast'
      },
      '$loadOrdIntoNavTree': {
        allow: 'oneAtATime',
        onRepeat: 'queue'
      },
      '$updateDisplay': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
    this.getCommandGroup().add(new ChangeCommand(this), new HyperlinkCommand(this));
    this.validators().add(function (ord) {
      if (ord.equals(DEFAULT_ORD)) {
        return;
      }
      ord.parse(); //ORD does not need to exist, but should be parseable
    });
  };
  OrdChooser.prototype = Object.create(BaseEditor.prototype);
  OrdChooser.prototype.constructor = OrdChooser;

  ////////////////////////////////////////////////////////////////
  // Private methods
  ////////////////////////////////////////////////////////////////

  OrdChooser.prototype.$getChangeCommand = function () {
    return this.getCommandGroup().get(0);
  };
  OrdChooser.prototype.$getHyperlinkCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * Get the element containing the ORD display information.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getDisplayElement = function () {
    return this.jq().children('.display');
  };

  /**
   * Get the element containing the icon for the Type of the object the ORD
   * points to.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getIconElement = function () {
    return this.$getDisplayElement().children('.icon');
  };

  /**
   * Get the editor showing the Ord target's icon.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/IconEditor}
   */
  OrdChooser.prototype.$getIconEditor = function () {
    // noinspection JSValidateTypes
    return Widget["in"](this.$getIconElement());
  };

  /**
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getCommandGroupElement = function () {
    return this.jq().children('.edit').children('.buttons');
  };

  /**
   * @private
   * @returns {module:bajaux/util/CommandButtonGroup}
   */
  OrdChooser.prototype.$getCommandButtonGroup = function () {
    // noinspection JSValidateTypes
    return Widget["in"](this.$getCommandGroupElement());
  };

  /**
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getOrdTypeContainer = function () {
    return this.jq().children('.edit-ord-type');
  };

  /**
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getOrdTypeEditorElement = function () {
    return this.$getOrdTypeContainer().children('.ord-type');
  };

  /**
   * @private
   * @returns {module:bajaux/Widget}
   */
  OrdChooser.prototype.$getOrdTypeEditor = function () {
    return Widget["in"](this.$getOrdTypeEditorElement());
  };

  /**
   * Get the element containing the display name for the object the ORD
   * points to.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getDisplayNameElement = function () {
    return this.$getDisplayElement().children('.displayName');
  };

  /**
   * Get the element containing display details about the ORD itself.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getDetailsElement = function () {
    return this.jq().children('.details');
  };

  /**
   * Get the element containing the raw text display of the ORD.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getOrdElement = function () {
    return this.$getDetailsElement().children('.ord');
  };
  OrdChooser.prototype.$getGoToCommand = function () {
    return Widget["in"](this.$getGoToCommandElement()).value();
  };
  OrdChooser.prototype.$getGoToCommandElement = function () {
    return this.$getDetailsElement().children('.hyperlink');
  };

  /**
   * Get the element containing edit controls.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getEditElement = function () {
    return this.jq().children('.edit');
  };

  /**
   * Get the element containing the component tree.
   *
   * @private
   * @returns {JQuery}
   */
  OrdChooser.prototype.$getNavTreeElement = function () {
    return this.$getEditElement().children('.tree');
  };

  /**
   * Get the loaded NavTree instance for the component tree.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/tree/NavTree|undefined} the
   * loaded NavTree instance, or `undefined` if the tree has not yet loaded
   */
  OrdChooser.prototype.$getNavTree = function () {
    // noinspection JSValidateTypes
    return Widget["in"](this.$getNavTreeElement());
  };
  OrdChooser.prototype.$selectAll = function () {
    selectAll(this.$getOrdElement());
  };

  /**
   * @private
   * @param {baja.Ord|String} ordDisplay the ORD text to display
   * @param {String} displayName the display name of the nav node the ORD points to
   */
  OrdChooser.prototype.$setText = function (ordDisplay, displayName) {
    this.$getOrdElement().val(String(ordDisplay));
    this.$getDisplayNameElement().text(displayName).attr('title', ordDisplay);
  };

  /**
   * Update the contents of all display elements to reflect the new ORD.
   *
   * @private
   * @param {baja.Ord} ord
   * @param {Array.<String>} [icon]
   * @returns {Promise} promise to be resolved after the ORD has been
   * resolved and queried for display information
   */
  OrdChooser.prototype.$updateDisplay = function (ord, icon) {
    var that = this,
      iconEditor = that.$getIconEditor();
    function setText(ordDisplay, displayName) {
      return that.$setText(ordDisplay, displayName);
    }
    if (that.getFormFactor() === Widget.formfactor.mini) {
      return setText(ord, '');
    }
    if (ord === DEFAULT_ORD) {
      that.$toggleOrdTypeSelector(ord);
      return Promise.resolve(setText('null', 'null'));
    } else if (shouldResolve(ord, that.$isUnMountedRootNode())) {
      return ord.resolve({
        base: baja.station
      })["catch"](function (err) {
        setText(ord, '');
        throw err;
      }).then(function (target) {
        return Promise.all([target, that.$updateOrdTypeEditor(target)]);
      }).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
          target = _ref2[0];
        return Promise.all([getDisplayName(target), target, that.$getOrdTypeEditor().read()]);
      }).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 3),
          displayName = _ref4[0],
          target = _ref4[1],
          isSlotOrdSelected = _ref4[2];
        var isHandleOrd = !isSlotOrdSelected && baja.hasType(target.getObject(), 'baja:Component'),
          displayOrd = isHandleOrd ? 'h:' + target.getComponent().getHandle() : getOrdDisplay(target, ord);
        setText(displayOrd, displayName);
        return iconEditor.load(icon || getIcon(target));
      })["catch"](logError);
    } else if (isNavNode(that.$getRootNode()) || isModuleOrd(ord)) {
      var selectedNodes = that.$getNavTree().getSelectedNodes();
      var selectedNode = selectedNodes.length ? selectedNodes[0] : null;
      if (!selectedNode) {
        return setText(ord, '');
      }
      return Promise.all([selectedNode.toDisplay(), iconEditor.load(selectedNode.getIcon())]).then(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 1),
          name = _ref6[0];
        if (isModuleOrd(ord)) {
          that.$toggleOrdTypeSelector(ord);
        }
        setText(ord, name);
      });
    } else {
      return Promise.resolve(setText(ord, ''));
    }
  };

  /**
   * Updates whether or not the ord type editor is readonly / visible based
   * upon the provided ord target.
   *
   * @private
   *
   * @param {module:baja/ord/OrdTarget} target
   * @returns {Promise}
   */
  OrdChooser.prototype.$updateOrdTypeEditor = function (target) {
    var that = this,
      targetObj = target.getObject(),
      ordTypeEditor = this.$getOrdTypeEditor(),
      isComponentSelected = baja.hasType(targetObj, 'baja:Component'),
      wasReadonlyBefore = ordTypeEditor.isReadonly();
    ordTypeEditor.setReadonly(!isComponentSelected);
    this.$toggleOrdTypeSelector(target.getOrd());
    if (ordTypeEditor.isEnabled() && !isComponentSelected) {
      return ordTypeEditor.load(true);
    }
    if (!wasReadonlyBefore) {
      return Promise.resolve();
    }
    if (ordTypeEditor.isEnabled() && that.$preferHandleOrd) {
      return ordTypeEditor.load(false);
    }
    return Promise.resolve();
  };

  /**
   * Gets the root node if set.
   *
   * @private
   * @returns {baja.Ord|String|baja.Value|null} if the return value is baja.Value,
   * it should be an instance of baja:INavNode
   *
   */
  OrdChooser.prototype.$getRootNode = function () {
    return this.properties().getValue(ROOT_NODE_PROPERTY);
  };

  /**
   * Returns true if the rootNode is a baja.INavNode but not mounted.
   *
   * @private
   * @returns {boolean}
   */
  OrdChooser.prototype.$isUnMountedRootNode = function () {
    var rootNode = this.$getRootNode();
    if (!rootNode) {
      return false;
    }
    if (!isNavNode(rootNode)) {
      return false;
    }
    if (!_.isFunction(rootNode.isMounted)) {
      return true;
    }
    return !rootNode.isMounted();
  };

  /**
   * Conditionally hide/show the Ord type toggler.
   * If a rootNode is passed and it is not mounted don't show the toggle editor at all.
   * @private
   */
  OrdChooser.prototype.$toggleOrdTypeSelector = function (ord) {
    var props = this.properties();
    var hideOrdType = props.get('hideOrdType');
    if (hideOrdType || this.$isUnMountedRootNode()) {
      this.$getOrdTypeContainer().toggle(false);
    } else {
      if (ord === DEFAULT_ORD) {
        this.$getOrdTypeContainer().toggle(true);
      } else {
        this.$getOrdTypeContainer().toggle(isSlotOrd(ord) || isLastQueryAHandleQuery(ord));
      }
    }
  };

  //TODO: c.f. LinkEditor: can we root the picker at a different node other than 'local'?
  //e.g. "pick a node somewhere in the services container"
  /**
   * Resolve the root node to use to instantiate the component chooser tree.
   *
   * @private
   * @returns {Promise} promise to be resolved with the component
   * instance at which to root the tree
   */
  OrdChooser.prototype.$resolveStationTreeNode = function () {
    var offline = baja.isOffline();
    var that = this;
    var rootNode = this.$getRootNode();
    function makeStationNode() {
      return that.getOrdBase().then(resolveStation).then(function (station) {
        return new BajaComplexTreeNode(station);
      });
    }
    var resolveNode = function resolveNode(node) {
      return isNavNode(node) ? navNodeToTreeNode(node) : ordToTreeNode(node);
    };
    return Promise.all([(offline || !rootNode) && makeStationNode(), !offline && !rootNode && stationTree.makeFileSpaceNode(), !offline && !rootNode && stationTree.makeHierarchySpaceNode(), !offline && !rootNode && stationTree.makeHistorySpaceNode(), !offline && rootNode && resolveNode(rootNode)]).then(function (nodes) {
      return stationTree.makeSessionNode(_.compact(nodes));
    });
  };

  /**
   * @private
   * @since Niagara 4.14
   * @returns {Promise}
   */
  OrdChooser.prototype.$makeModuleSpaceNode = function () {
    // Never load kids on the module space during first load
    var ModuleSpaceTreeNode = /*#__PURE__*/function (_BajaNavTreeNode) {
      function ModuleSpaceTreeNode() {
        var _this;
        _classCallCheck(this, ModuleSpaceTreeNode);
        _this = _callSuper(this, ModuleSpaceTreeNode, arguments);
        _this.$preLoad = false;
        return _this;
      }
      _inherits(ModuleSpaceTreeNode, _BajaNavTreeNode);
      return _createClass(ModuleSpaceTreeNode);
    }(BajaNavTreeNode);
    var moduleNavContainer = new NavNodeContainer({
      navName: "module",
      icon: "module://icons/x16/modules.png",
      ord: "local:|module:",
      typeSpec: "baja:ModuleSpace",
      displayName: bajaLex.get('nav.modules')
    });
    return moduleNavContainer.init().then(function (moduleContainer) {
      var node = new ModuleSpaceTreeNode(moduleContainer);
      return node;
    });
  };

  /**
   * @private
   * @since Niagara 4.14
   * @returns {boolean}
   */
  OrdChooser.prototype.$hasShowModules = function () {
    var props = this.properties();
    var rootNode = props.get('rootNode'),
      showModules = props.getValue('showModules', true);
    if (rootNode) {
      return false;
    }
    return showModules;
  };

  /**
   * One-time instantiation of the nav tree to use as a node picker.
   * @private
   * @returns {Promise}
   */
  OrdChooser.prototype.$initializeNavTree = function () {
    var that = this;
    var props = that.properties();
    var rootNode = props.get('rootNode'),
      showModules = that.$hasShowModules();
    var hideRoot = props.get('hideRoot');
    hideRoot = hideRoot === undefined || hideRoot === null ? !!rootNode : hideRoot;
    return Promise.all([that.$resolveStationTreeNode(), showModules && that.$makeModuleSpaceNode()]).then(function (_ref7) {
      var _ref8 = _slicedToArray(_ref7, 2),
        stationTreeNode = _ref8[0],
        moduleSpaceNode = _ref8[1];
      var treeNode = stationTreeNode;
      if (moduleSpaceNode) {
        treeNode = new TreeNode(SESSION_NODE_NAME, '', [stationTreeNode, moduleSpaceNode]);
      }
      return stationTree.createNavTree({
        value: treeNode,
        dom: that.$getNavTreeElement(),
        properties: {
          displayFilter: that.properties().getValue(DISPLAY_FILTER_PROPERTY),
          hideRoot: hideRoot || showModules
        }
      });
    });
  };

  /**
   * Ensure that the nav tree is loaded and ready to display. Will resolve
   * the tree root, instantiate and load the component chooser tree, and
   * pre-select a node in the tree to reflect the currently loaded ORD.
   *
   * @private
   * @param {baja.Ord} [ord]
   * @returns {Promise} promise to be resolved once the tree has loaded
   * and has a node pre-selected
   */
  OrdChooser.prototype.$loadOrdIntoNavTree = function (ord) {
    var _this2 = this;
    var that = this,
      invalidOrd,
      targetOrd = DEFAULT_ORD,
      showModules = that.$hasShowModules();
    var rootNode = that.$getRootNode();
    if (isHierarchyOrd(ord) || isHistoryOrd(ord)) {
      targetOrd = ord;
    } else if (shouldResolve(ord, that.$isUnMountedRootNode())) {
      targetOrd = ord.resolve({
        base: baja.station
      }).then(getTargetOrd)["catch"](function () {
        invalidOrd = true;
        return DEFAULT_ORD;
      });
    } else {
      try {
        targetOrd = relativize(ord);
      } catch (ignore) {
        //invalid ORD, so use DEFAULT
      }
    }
    return Promise.all([isNavNode(rootNode) ? resolvePathFromNavNode(ord, rootNode) : Promise.resolve(targetOrd).then(ordToPath), that.$initializeNavTree(), rootNode && !isNavNode(rootNode) && ordToPath(rootNode)]).then(function (_ref9) {
      var _ref10 = _slicedToArray(_ref9, 3),
        path = _ref10[0],
        tree = _ref10[1],
        rootOrdParts = _ref10[2];
      if (rootOrdParts && !isModuleOrd(ord)) {
        var rootElementIndex = rootOrdParts.length - 1;
        path.splice(1, rootElementIndex - 1);
      }

      // If it is a station tree node and showModules is turned on then path is one level deeper
      if (showModules && !isModuleOrd(ord)) {
        path && path.unshift(SESSION_NODE_NAME);
      }
      return tree.setSelectedPath(path, {
        silent: true
      }).then(function (element) {
        _this2.$selectedPathElement = element;
      })["catch"](function () {
        invalidOrd = true;
      });
    }).then(function () {
      return invalidOrd ? that.$setText(ord, '') : that.$commitSelectedNode();
    });
  };

  /**
   * Hides the nav tree (but does not unload it).
   *
   * @private
   */
  OrdChooser.prototype.$hideNavTree = function () {
    this.$getNavTreeElement().hide();
  };

  /**
   * Hides/shows the nav tree depending on whether it is currently shown.
   *
   * @private
   * @returns {Promise} promise to be resolved once the nav tree has
   * been toggled
   */
  OrdChooser.prototype.$toggleNavTree = function (ord) {
    var that = this;
    return that.$loadOrdIntoNavTree(ord).then(function () {
      that.$getNavTreeElement().toggle();
    });
  };

  /**
   * Read the ORD from the selected node in the tree and write it back to the
   * OrdChooser's text field.
   *
   * @private
   * @returns {Promise.<baja.Ord|null>} resolves the newly written ORD, or null
   * if no node was selected
   */
  OrdChooser.prototype.$commitSelectedNode = function () {
    var that = this,
      selectedNodes = that.$getNavTree().getSelectedNodes(),
      showModules = that.$hasShowModules();
    if (selectedNodes.length) {
      var node = selectedNodes[0],
        baseOrd = getBaseOrd(that.$getRootNode()),
        ord = nodeToOrd(node, baseOrd, showModules);
      ord = sanitizeOrd(ord);
      return that.$updateDisplay(ord, node.getIcon()).then(_.constant(ord));
    }
    return Promise.resolve(null);
  };

  ////////////////////////////////////////////////////////////////
  // OrdChooser bajaux implementation
  ////////////////////////////////////////////////////////////////

  OrdChooser.prototype.requestFocus = function () {
    var element = this.$selectedPathElement;
    if (element) {
      element.scrollIntoView({
        block: "nearest",
        inline: "nearest"
      });
    }
    BaseEditor.prototype.requestFocus.apply(this, arguments);
    this.$selectAll();
  };

  /**
   * Builds up the ORD chooser DOM and arms event handlers for the change button
   * and nav tree events.
   *
   * @param {JQuery} dom
   */
  OrdChooser.prototype.doInitialize = function (dom) {
    var that = this;
    var props = that.properties();
    var selectFilterProperty = props.getValue(SELECT_FILTER_PROPERTY);
    var forceOrdType = props.getValue('forceOrdType');
    var ordTypeEnabled = true;
    var ordType = true;
    if (forceOrdType && (forceOrdType === 'slot' || forceOrdType === 'handle')) {
      ordTypeEnabled = false;
      ordType = forceOrdType === 'slot';
    }
    if (selectFilterProperty) {
      this.validators().add(selectFilterProperty);
    }
    dom.html(tplOrdChooser({
      ordTypeLabel: webEditorsLex.get('OrdChooser.ordType')
    })).addClass('OrdChooser').toggleClass('hideOrdText', props.getValue('showOrdText') === false);
    dom.on(NavTree.SELECTED_EVENT, '.tree', function () {
      that.$commitSelectedNode()["catch"](logError)["finally"](function () {
        that.setModified(true);
      });
    });
    dom.on(NavTree.ACTIVATED_EVENT, '.tree', function () {
      that.$commitSelectedNode().then(function (ord) {
        if (ord) {
          return that.validate().then(function (ord) {
            dom.trigger(VALUE_READY_EVENT, [ord]);
            that.$hideNavTree();
          })["catch"](function (err) {
            that.setModified(true);
            throw err;
          });
        }
      })["catch"](logError);
    });
    dom.on('input', '.ord', function () {
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.edit-ord-type', function () {
      that.$commitSelectedNode()["catch"](logError)["finally"](function () {
        that.setModified(true);
      });
      return false;
    });
    selectOnFocus(that, 'input', function () {
      return that.$selectAll();
    });
    var goToDom = $('<button type="button" class="hyperlink ux-btn-tb"></button>');
    return Promise.all([new IconEditor().initialize(that.$getIconElement()), fe.buildFor({
      dom: dom.children('.edit-ord-type').children('.ord-type'),
      value: ordType,
      type: BooleanEditor,
      properties: {
        trueText: webEditorsLex.get('OrdChooser.ordType.slot'),
        falseText: webEditorsLex.get('OrdChooser.ordType.handle'),
        falseIcon: bajaLex.get('neutral.icon'),
        trueIcon: bajaLex.get('neutral.icon')
      }
    }), fe.buildFor({
      dom: dom.children('.edit').children('.buttons'),
      value: that.getCommandGroup(),
      type: CommandButtonGroup
    }), that.$canAddGoToCommand() && fe.buildFor({
      dom: goToDom.appendTo(dom.children('.details')),
      value: new GoToCommand(that),
      type: CommandButton
    })]).then(function (results) {
      return that.$getOrdTypeEditor().setEnabled(ordTypeEnabled).then(function () {
        return results;
      });
    });
  };

  /**
   * Interrogates the loaded ORD and updates display elements with the
   * relevant information.
   *
   * @param {baja.Ord|string} value
   * @returns {Promise} promise to be resolved when all display elements
   * are updated
   */
  OrdChooser.prototype.doLoad = function (value) {
    var that = this;
    var ordTypeEditor = that.$getOrdTypeEditor();
    that.$preferHandleOrd = isLastQueryAHandleQuery(value);
    if (that.getFormFactor() === Widget.formfactor.compact) {
      if (ordTypeEditor.isEnabled()) {
        return ordTypeEditor.load(!that.$preferHandleOrd).then(function () {
          return that.$loadOrdIntoNavTree(makeOrd(value));
        }).then(function () {
          that.$getNavTreeElement().show();
          that.$toggleOrdTypeSelector(value);
        });
      } else {
        return that.$loadOrdIntoNavTree(makeOrd(value)).then(function () {
          that.$getNavTreeElement().show();
          that.$toggleOrdTypeSelector(value);
        });
      }
    } else {
      return that.$updateDisplay(makeOrd(value));
    }
  };

  /**
   * Resolves the currently selected ORD.
   *
   * @returns {baja.Ord} the currently selected `baja.Ord`.
   */
  OrdChooser.prototype.doRead = function () {
    var inputOrd = makeOrd(this.$getOrdElement().val());
    return this.$getOrdTypeEditor().read().then(function (isSlotSelected) {
      if (isSlotSelected) {
        return inputOrd;
      }
      if (isLastQueryAHandleQuery(inputOrd)) {
        return inputOrd;
      }
      return resolveHandleOrd(inputOrd);
    });
  };

  /**
   * Removes `OrdChooser` class and destroys child widgets.
   */
  OrdChooser.prototype.doDestroy = function () {
    this.jq().removeClass('OrdChooser hideOrdText');
    return Promise.all([this.$getIconEditor().destroy(), this.$getCommandButtonGroup().destroy()]);
  };

  /**
   * Enables/disables change button.
   *
   * @param readonly
   */
  OrdChooser.prototype.doReadonly = function (readonly) {
    return Promise.all([this.$getOrdElement().prop('readonly', readonly), this.$getChangeCommand().setEnabled(this.isEnabled() && !readonly), this.getChildWidgets().setAllReadonly(readonly)]);
  };

  /**
   * Enables/disables change button.
   *
   * @param enabled
   */
  OrdChooser.prototype.doEnabled = function (enabled) {
    return Promise.all([this.$getOrdElement().prop('disabled', !enabled), this.$getChangeCommand().setEnabled(!this.isReadonly() && enabled), this.getChildWidgets().setAllEnabled(enabled)]);
  };

  /**
   * Determines if the GoToCommand can be added for this editor
   * when viewed via the "mini" formFactor
   * @private
   * @returns {boolean}
   */
  OrdChooser.prototype.$canAddGoToCommand = function () {
    if (this.getFormFactor() !== Widget.formfactor.mini) {
      return false;
    }
    return GoToCommand.canAdd(this.properties().toObject());
  };

  /**
   *
   * @param {String|baja.Ord|baja.Value|null} rootNode
   * @returns {*|null}
   */
  function getBaseOrd(rootNode) {
    if (isNavNode(rootNode)) {
      return String(rootNode.getNavOrd());
    }
    return rootNode;
  }
  return OrdChooser;
});
