/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/job/JobEditor
 */
define(['Promise', 'nmodule/webEditors/rc/wb/job/JobBar', 'hbs!nmodule/webEditors/rc/wb/job/template/JobEditor'], function (Promise, JobBar, tplJobEditor) {
  "use strict";

  /**
   * An extension of the `JobBar` intended to be used as an editor on a property
   * sheet. This uses a slightly different template to the regular `JobBar`, to arrange
   * the items more suitably.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/job/JobBar
   */
  var JobEditor = function JobEditor(params) {
    JobBar.call(this, arguments);
  };
  JobEditor.prototype = Object.create(JobBar.prototype);
  JobEditor.prototype.constructor = JobEditor;

  /**
   * Load the template for the widget. As an editor, this uses a slightly different template
   * to the regular job bar.
   *
   * @private
   * @param {JQuery} dom
   */
  JobEditor.prototype.loadTemplate = function (dom) {
    dom.html(tplJobEditor({}));
  };

  /**
   * Initialize the widget.
   *
   * @param {JQuery} dom the DOM element to load the widget into.
   */
  JobEditor.prototype.doInitialize = function (dom) {
    return JobBar.prototype.doInitialize.call(this, dom).then(function () {
      dom.addClass('JobEditor');
    });
  };

  /**
   * Destroy the widget.
   *
   * @returns {Promise|*}
   */
  JobEditor.prototype.doDestroy = function () {
    var that = this;
    return Promise.resolve(JobBar.prototype.doDestroy.call(this)).then(function () {
      that.jq().removeClass('JobEditor');
    });
  };
  return JobEditor;
});
