function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/RoleManager
 */
define(['baja!', 'baja!baja:RoleService,baja:Role,baja:AdminRole,baja:PermissionsMap,hierarchy:RoleHierarchies,baja:CategoryService', 'Promise', 'underscore', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/mgrAgents', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource', 'nmodule/webEditors/rc/wb/util/role/RoleNameMgrColumn', 'nmodule/webEditors/rc/wb/util/role/PermissionsMapMgrColumn'], function (baja, types, Promise, _, subscriberMixIn, addContextMenuSupport, DepthSubscriber, Manager, Column, spaceUtils, subscriberUtils, MgrTypeInfo, MgrModel, mgrAgents, ContainerComponentSource, RoleNameMgrColumn, PermissionsMapMgrColumn) {
  'use strict';

  var EDITABLE = Column.flags.EDITABLE;
  var ROLE = 'baja:Role';
  var ROLE_TYPE = baja.lt(ROLE);
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var getCategoryService = leaseWhenNeeded(_.partial(resolveService, 'baja:CategoryService'));

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/RoleManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   */
  var RoleManager = function RoleManager(params) {
    var that = this;
    Manager.call(that, {
      moduleName: 'webEditors',
      keyName: 'RoleManager'
    });
    that.$subscriber = new DepthSubscriber(3);
    subscriberMixIn(that);
    addContextMenuSupport(that);
  };
  RoleManager.prototype = Object.create(Manager.prototype);
  RoleManager.prototype.constructor = RoleManager;

  /**
   * Get the command to edit the selected user(s).
   *
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  RoleManager.prototype.$getEditCommand = function () {
    return this.getCommandGroup().get(1);
  };

  ////////////////////////////////////////////////////////////
  //Context Menu Support
  ////////////////////////////////////////////////////////////

  /**
   * Trigger context menus specifically on table row right clicks
   * @override
   * @returns {string}
   */
  RoleManager.prototype.getContextMenuSelector = function () {
    return 'tr';
  };

  /**
   * Ensure that rows are updated when a category name changes.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  RoleManager.prototype.doInitialize = function (dom) {
    var that = this,
      args = arguments;
    return that.$getCategoryService().then(function (categoryService) {
      // check for changes to the Category names
      that.getSubscriber().attach('renamed', function () {
        that.getModel().emit('rowsChanged', that.getModel().getRows());
      });
      return that.getSubscriber().subscribe(categoryService);
    }).then(function () {
      return Manager.prototype.doInitialize.apply(that, args);
    });
  };
  RoleManager.prototype.$makeColumns = function (categories) {
    return [new RoleNameMgrColumn({
      flags: EDITABLE
    }), new PermissionsMapMgrColumn({
      flags: EDITABLE,
      categories: categories
    })];
  };

  /**
   * Create a `RoleManagerMgrModel` instance with the appropriate columns.
   *
   * @param {baja.Component} roleService
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
   */
  RoleManager.prototype.makeModel = function (roleService) {
    var that = this;
    return Promise.all([MgrTypeInfo.make([baja.lt(ROLE)]), that.$getCategories(), mgrAgents.getMixInColumns(ROLE_TYPE)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        newTypes = _ref2[0],
        categories = _ref2[1],
        mixinCols = _ref2[2];
      return new MgrModel({
        componentSource: new ContainerComponentSource({
          filter: [ROLE],
          // prevents the admin role from showing
          container: roleService
        }),
        newTypes: newTypes,
        columns: that.$makeColumns(categories).concat(mixinCols)
      });
    });
  };
  RoleManager.prototype.$getCategories = function () {
    var that = this;
    return that.$getCategoryService().then(function (categoryService) {
      return categoryService.getSlots().is('baja:Category').toValueArray();
    })["catch"](function () {
      return _.constant([]);
    });
  };
  RoleManager.prototype.$getCategoryService = function () {
    return this.getOrdBase().then(getCategoryService);
  };
  RoleManager.prototype.doDestroy = function () {
    var that = this,
      args = arguments;
    return that.getSubscriber().unsubscribeAll().then(function () {
      return Manager.prototype.doDestroy.apply(that, args);
    });
  };

  /**
   * Overrides the default onMainTableDblClicked and invokes the EditCommand
   * @inheritDoc
   */
  RoleManager.prototype.onMainTableDblClicked = function (event, subjects) {
    return this.$getEditCommand().invoke();
  };

  /**
   * In addtion to the default onTableSelectionChanged logic, this enables/disables the EditCommand
   * @inheritDoc
   */
  RoleManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var _this = this;
    return Manager.prototype.onTableSelectionChanged.call(this, arguments).then(function () {
      var mainTableSelection = selectedSubjects.mainTableSelection;
      _this.$getEditCommand().setEnabled(!(mainTableSelection.length === 0));
    });
  };
  return RoleManager;
});
