function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint-env browser */ /*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/PropertySheet
 */
define(['baja!', 'baja!baja:Link', 'lex!bajaux,webEditors', 'log!nmodule.webEditors.rc.wb.PropertySheet', 'jquery', 'Promise', 'underscore', 'bajaux/Properties', 'bajaux/mixin/responsiveMixIn', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder', 'nmodule/webEditors/rc/fe/registry/servletViews', 'nmodule/webEditors/rc/util/Switchboard', 'nmodule/webEditors/rc/wb/PropertySheetRow', 'nmodule/webEditors/rc/wb/commands/ActionsCommand', 'nmodule/webEditors/rc/wb/mixin/AttachableSupport', 'bajaux/util/SaveCommand', 'hbs!nmodule/webEditors/rc/wb/template/PropertySheet'], function (baja, types, lexs, log, $, Promise, _, Properties, responsive, subscribable, CompositeEditor, BaseEditor, DisplayOnlyEditor, slotUtils, typeUtils, CompositeBuilder, ComplexCompositeBuilder, servletViews, Switchboard, PropertySheetRow, ActionsCommand, addAttachableSupport, SaveCommand, tplPropertySheet) {
  'use strict';

  var VALIDATE_FAIL_KEY = 'CompositeEditor.validate.failSlot',
    UNSUBSCRIBE_DELAY = 2000,
    ENTER_KEY = 13,
    //specify which properties should propagate to child sheets - other
    //properties such as 'max' cause problems (c.f. NCCB-25979)
    INHERITED_PROPERTIES = ['allowHyperlink', 'allowSelection', 'alt', 'showActionsAndTopics', 'showHiddenSlots', 'slotMode'],
    CompositeError = CompositeBuilder.$CompositeError,
    isUiVisible = slotUtils.isUiVisible,
    toCssClass = slotUtils.toCssClass,
    getSuperTypeChain = typeUtils.getSuperTypeChain,
    isComplex = typeUtils.isComplex,
    bajauxLex = lexs[0],
    webEditorsLex = lexs[1],
    logSevere = log.severe.bind(log);
  var HideMeWidget = function HideMeWidget() {
    BaseEditor.apply(this, arguments);
  };
  HideMeWidget.prototype = Object.create(BaseEditor.prototype);
  HideMeWidget.prototype.constructor = HideMeWidget;
  HideMeWidget.prototype.doInitialize = function (dom) {
    dom.css('display', 'none');
  };

  /**
   * Applies "even" and "odd" classes to child rows.
   * @inner
   * @param sheet
   */
  function applyEvenOdd(sheet) {
    _.each(sheet.$getKidRows(), function (row, i) {
      row.jq().toggleClass('even', i % 2 === 0).toggleClass('odd', i % 2 === 1);
    });
  }

  /**
   * In response to a baja reordered event, sort the dynamic rows in the
   * property sheet to match the current order of slots in the component.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/wb/PropertySheet} propSheet
   */
  function doReorder(propSheet) {
    //TODO: we are guaranteed that dynamic slots are at the end right?
    var complex = propSheet.value(),
      dynamicSlots = complex.getSlots().dynamic().toArray(),
      tableBody = propSheet.$getTableBody(),
      stillInitializing = false,
      dynamicElems = tableBody.children().filter(function () {
        var $this = $(this),
          row = $this.data('widget') || $this.prev().data('widget');

        // when dropping a slot into the slot list, we'll sometimes get
        // the reordered event before the new row has finished initializing.
        // in this case we have to back off, wait for the row, and then
        // reorder.

        if (stillInitializing || !row) {
          stillInitializing = true;
          return;
        }
        var slot = row.getSlot();
        return !(slot && slot.isFrozen());
      }),
      sortedElems = [];
    if (stillInitializing) {
      return setTimeout(function () {
        doReorder(propSheet);
      }, 50);
    }
    _.each(dynamicSlots, function (slot) {
      var row = dynamicElems.filter('.' + toCssClass(slot)),
        next = row.next(),
        nextWidget = next.data('widget');
      sortedElems.push(row);
      if (!(nextWidget instanceof PropertySheetRow) && !(nextWidget instanceof HideMeWidget)) {
        sortedElems.push(next);
      }
    });
    dynamicElems.detach();
    tableBody.append(sortedElems);
  }

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  //TODO: fix display name
  /**
   * A property sheet editor for working with `Complex`es.
   *
   * Assembles all visible properties of the `Complex` into a `<table>`
   * with slot display names in one column, and field editors in another.
   *
   * This editor uses the following Widget Properties:
   *
   * - `allowHyperlink`: set to `false` to prevent rows for nav children from
   *   creating hyperlinks to those components
   * - `allowSelection`: set to `false` to prevent individual rows in the
   *   sheet from being highlighted
   * - `displayOnly`: set to `true` to cause every row to be shown as plain
   *   text. This allows for showing the values of a Complex (say, in an
   *   informational dialog), without having to use the readonly flag and get
   *   less-readable, greyed-out editors. (since Niagara 4.8)
   * - `showActionsAndTopics`: set to `true` to show Actions and Topics as well
   *   as Properties.
   * - `showHiddenSlots`: set to `true` to show hidden slots like `Link`s and
   *   `wsAnnotations` as well as slots with the `HIDDEN` flag set.
   * - `showControls`: set to `true` to show a controls div to allow toggling
   *   in and out of slot mode and showing/hiding actions and topics.
   * - `showHeader`: set to `true` to show column headers.
   * - `slotMode`: set to `true` to toggle the property sheet into slot detail
   *   mode.
   * - `readBehavior: (since Niagara 4.13) a string that controls how the property
   *   sheet implements the read() function.  The default is "diff" which only returns the
   *   difference or changes made by the user.  The other option is "copy" which
   *   returns a copy of the component with all the changed and original values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/webEditors/rc/wb/PropertySheet
   * @param {Object} [params]
   */
  var PropertySheet = function PropertySheet(params) {
    var that = this;
    params = params || {};
    CompositeEditor.call(that, _.extend({}, params, {
      keyName: 'PropertySheet',
      properties: _.extend({
        hideCommandBar: {
          value: false,
          hidden: true,
          "transient": true,
          readonly: true
        },
        nested: false,
        showControls: false,
        showHeader: true,
        showFooter: false,
        readBehavior: {
          value: "diff",
          hidden: true
        }
      }, params.properties)
    }));
    that.getCommandGroup().add(new SaveCommand(), new ActionsCommand(that));
    new Switchboard(that).allow('$filterChanged').oneAtATime().onRepeat().preempt();
    addAttachableSupport(that);
    subscribable(that);
    responsive(that, {
      'tablet-portrait-up': {
        minWidth: 800
      }
    });
  };
  PropertySheet.prototype = Object.create(CompositeEditor.prototype);
  PropertySheet.prototype.constructor = PropertySheet;

  //TODO: this is hacky. need better solution to mark a slot as being "temporarily hidden" vs. "never show ever"
  PropertySheet.$HideMeWidget = HideMeWidget;

  /**
   * @private
   * @returns {module:bajaux/util/SaveCommand} the Save command
   */
  PropertySheet.prototype.$getSaveCommand = function () {
    // noinspection JSValidateTypes
    return this.getCommandGroup().get(0);
  };

  /**
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/commands/ActionsCommand} the
   * Actions command
   */
  PropertySheet.prototype.$getActionsCommand = function () {
    // noinspection JSValidateTypes
    return this.getCommandGroup().get(1);
  };

  /**
   * A `PropertySheet` can show any slot.
   *
   * @returns {Function}
   */
  PropertySheet.prototype.getSlotFilter = function () {
    var that = this;
    return function (slot) {
      return that.properties().getValue('displayOnly') ? {
        type: DisplayOnlyEditor
      } : {
        type: that.$getRowConstructor()
      };
    };
  };

  /**
   * Return true if the slot should be shown (not hidden, not displayNames,
   * etc.) By default, a `PropertySheet` will only show Properties.
   *
   * @private
   * @param {baja.Slot} slot
   * @returns {Boolean}
   */
  PropertySheet.prototype.$shouldShowSlot = function (slot) {
    return slot.isProperty() && (this.isShowHiddenSlots() || isUiVisible(slot, false));
  };

  /**
   * Return true if hidden slots should currently be shown.
   *
   * @returns {Boolean}
   */
  PropertySheet.prototype.isShowHiddenSlots = function () {
    return !!this.properties().getValue('showHiddenSlots');
  };

  /**
   * Set whether hidden slots should currently be shown.
   *
   * @param {Boolean} showHiddenSlots
   * @returns {Promise} promise to be resolved after hidden slots are
   * torn down or rebuilt
   */
  PropertySheet.prototype.setShowHiddenSlots = function (showHiddenSlots) {
    if (showHiddenSlots === this.isShowHiddenSlots()) {
      return Promise.resolve();
    }
    this.properties().setValue('showHiddenSlots', !!showHiddenSlots);
    return this.$filterChanged();
  };

  /**
   * Get all `PropertySheetRow` children currently loaded.
   *
   * @private
   * @returns {Array.<module:nmodule/webEditors/rc/wb/PropertySheetRow>}
   */
  PropertySheet.prototype.$getKidRows = function () {
    return this.getChildEditors({
      type: PropertySheetRow
    });
  };
  PropertySheet.prototype.$getExpandedPropertySheets = function () {
    return this.$getKidRows().map(function (row) {
      return row.$getSubPropertySheet();
    }).filter(_.identity);
  };
  PropertySheet.prototype.doLayout = function () {
    return Promise.all(this.$getExpandedPropertySheets().map(function (sheet) {
      return sheet.layout();
    }));
  };

  /**
   * Get the `PropertySheetRow` for a particular key.
   *
   * @private
   * @param {baja.Slot|String} slot
   * @returns {module:nmodule/webEditors/rc/wb/PropertySheetRow} the row editor,
   * or `undefined` if not found
   */
  PropertySheet.prototype.$getRowForKey = function (slot) {
    return this.$getTableBody().children('.' + toCssClass(slot)).data('widget');
  };

  /**
   * Get the table body element (where `PropertySheetRow`s should be
   * instantiated).
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheet.prototype.$getTableBody = function () {
    return this.$tableBody || (this.$tableBody = $(document.createDocumentFragment()));
  };

  /**
   * Gets an array of the slots on the component whose rows are currently
   * selected by the user.
   *
   * @private
   * @returns {Array.<baja.Slot>}
   */
  PropertySheet.prototype.$getSelectedSlots = function () {
    return _.map(this.$getKidRows(), function (row) {
      if (row.$isSelected()) {
        return row.jq().data('slot');
      }
    });
  };

  /**
   * Creates a table row to hold an instance of `PropertySheetRow`.
   *
   * @private
   * @returns {jQuery} the table row into which to load the field editor
   */
  PropertySheet.prototype.$buildSubEditorDom = function (key) {
    var tbody = this.$getTableBody(),
      existing = tbody.children('.' + toCssClass(key));
    if (existing.length) {
      return existing;
    }
    return $('<tr class="ux-table-row"/>').appendTo(tbody);
  };

  /**
   * Override this method to allow different subclasses of `PropertySheetRow`
   * to be instantiated by default.
   *
   * @private
   * @returns {Function}
   */
  PropertySheet.prototype.$getRowConstructor = function () {
    return PropertySheetRow;
  };
  PropertySheet.prototype.$rebuildForSlot = function (slot) {
    if (!slot) {
      return;
    }
    var that = this,
      builder = that.getBuilder(),
      kid = that.$getRowForKey(slot),
      isHidden = kid instanceof HideMeWidget,
      shouldHide = !that.$shouldShowSlot(slot);
    if (shouldHide === isHidden) {
      return; //no rebuild necessary
    }
    return Promise.resolve(!isHidden && kid.$setSelected(false)) //NCCB-9679
    .then(function () {
      return builder.destroyFor(slot);
    }).then(function () {
      return builder.$loadFor(slot);
    }).then(function () {
      builder.getEditorFor(slot).jq().toggle(!shouldHide);
    });
  };
  PropertySheet.prototype.$filterChanged = function () {
    var that = this,
      complex = that.value(),
      slots = complex.getSlots().toArray();
    return Promise.all(slots.map(function (slot) {
      return that.$rebuildForSlot(slot);
    })).then(function () {
      applyEvenOdd(that);
    });
  };

  /**
   * Subscribe child components of the loaded Complex. This is split out,
   * rather than delegated to `subscriberMixIn`, for two reasons: 1, we want to
   * be able to render the property sheet to the DOM immediately rather than
   * waiting for subscription calls to complete, and 2, using batched
   * subscription as required by `subscriberMixIn` results in multiple
   * `loadTypes` calls.
   *
   * @private
   * @param {baja.Complex} complex the complex value being loaded into the
   * property sheet
   * @returns {Promise}
   */
  PropertySheet.prototype.$subscribeKids = function (complex) {
    var that = this,
      kids = isComplex(complex) && complex.getSlots().is('baja:Component').toValueArray(),
      mountedKids = kids && _.filter(kids, function (kid) {
        return kid.isMounted();
      }),
      sub = that.$kidSubscriber;
    if (!sub) {
      sub = that.$kidSubscriber = new baja.Subscriber();
    }
    return Promise.resolve(mountedKids && sub.subscribe(mountedKids));
  };

  /**
   * Release the subscription on child components acquired in
   * `$subscribeKids`.
   *
   * @private
   * @returns {Promise}
   */
  PropertySheet.prototype.$unsubscribeKids = function () {
    var sub = this.$kidSubscriber;
    return Promise.resolve(sub && sub.unsubscribeAll());
  };
  PropertySheet.prototype.makeBuilder = function () {
    var sheet = this,
      builder = new ComplexCompositeBuilder({
        removeOnDestroy: false
      }),
      getConfigFor = builder.getConfigFor,
      setDataSource = builder.setDataSource,
      buildAll = builder.buildAll;
    builder.getDomFor = function (key) {
      return sheet.$buildSubEditorDom(key);
    };
    builder.setDataSource = function (complex) {
      var that = this;
      return setDataSource.apply(that, arguments).then(function () {
        return sheet.getSlotFilter(complex);
      }).then(function (slotFilter) {
        return that.setSlots(slotFilter);
      });
    };
    builder.buildAll = function () {
      var that = this,
        complex = that.getDataSource();
      return Promise.all([that.getKeys(), buildAll.apply(that, arguments)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
          keys = _ref2[0];
        var toggleDoms = _.map(keys, function (key) {
          return Promise.resolve(that.getDomFor(key)).then(function (dom) {
            var slot = complex.getSlot(key);
            if (slot) {
              dom.toggle(sheet.$shouldShowSlot(slot));
            }
          });
        });
        return Promise.all(toggleDoms);
      });
    };
    builder.getConfigFor = function (key) {
      return Promise.all([getConfigFor.apply(this, arguments), sheet.getOrdBase()]).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          config = _ref4[0],
          ordBase = _ref4[1];
        var type = config.type,
          complex = builder.getDataSource(),
          RowCtor = sheet.$getRowConstructor(),
          props = sheet.properties().subset(INHERITED_PROPERTIES).toValueMap(),
          shouldHide = !sheet.$shouldShowSlot(complex.getSlot(key));
        config.data = {
          builder: builder,
          key: key
        };
        config.properties = _.extend(props, config.properties, {
          alt: {
            value: !!props.alt,
            hidden: true
          },
          ordBase: ordBase,
          sheetReadonly: sheet.isReadonly()
        });
        if (shouldHide) {
          config.type = HideMeWidget;
        } else {
          if (type !== RowCtor) {
            //slot filter might specify a display widget. this will get
            //passed directly to PropertySheetRow's constructor so it knows
            //how to instantiate its display widget for its value.
            config.data.displayWidget = type;
          }
          config.type = RowCtor;
        }
        return config;
      });
    };

    /**
     * TODO: remove this optimization after switching away from jQuery promises
     * each individual row will result in its own call to
     * servletViews.getEntries so it can figure out what type of field
     * editor to load in. since we started batching rows, this will
     * result in one network call for every {batch size} rows - deadly
     * on a jace 3. so pre-fetch all the agent registration info for all
     * rows to ensure it goes into one single network call.
     *
     * @private
     * @returns {Promise}
     */
    builder.$preloadAgentInfo = function () {
      var that = this;
      return Promise.resolve(that.getKeys()).then(function (keys) {
        var typeSpecs = _.chain(keys).map(function (key) {
          var value = that.getValueFor(key);
          return baja.hasType(value) ? getSuperTypeChain(value.getType()) : undefined;
        }).compact().flatten().uniq().value();
        return Promise.all(typeSpecs.map(function (typeSpec) {
          return servletViews.getEntries(typeSpec);
        }));
      });
    };
    if (!sheet.properties().getValue('buildSync')) {
      /**
       * TODO: this should disappear after reworking html generation.
       * Yield the UI thread in between building each row so the entire browser
       * doesn't lock up as the sheet builds.
       *
       * @private
       * @returns {*}
       */
      builder.$loadAll = function () {
        var that = this,
          ROW_BATCH_SIZE = 3,
          //force yield to UI thread after this many rows
          ROW_RENDER_LIMIT = 20; //resolve load promise after this many rows, even if not done

        return Promise.all([that.getKeys(), that.$preloadAgentInfo()]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 1),
            keys = _ref6[0];
          var renderCount = 0;

          // eslint-disable-next-line promise/avoid-new
          return new Promise(function (resolve, reject) {
            (function buildFor(keys) {
              setTimeout(function () {
                if (!keys.length || !sheet.isInitialized()) {
                  //we're done, or we got destroyed before we were done
                  return resolve();
                }
                if (renderCount >= ROW_RENDER_LIMIT) {
                  //we're not done, but user is sick of waiting, so go ahead
                  //and show the sheet and hope the pop-pop-pop is off the screen
                  resolve();
                }
                var toRender = Math.min(keys.length, ROW_BATCH_SIZE);
                Promise.all(keys.slice(0, toRender).map(function (key) {
                  return that.$loadFor(key);
                })).then(function () {
                  renderCount += toRender;
                  buildFor(keys.slice(toRender));
                }, reject);
              }, 0);
            })(keys);
          });
        });
      };
    }
    return builder;
  };

  /**
   * Creates a `<table>` element to hold the property sheet values. Also
   * adds a `PropertySheet` CSS class for styling.
   *
   * Arms an event handler for selecting property sheet rows.
   *
   * @param {JQuery} dom
   */
  PropertySheet.prototype.doInitialize = function (dom) {
    var that = this,
      properties = that.properties();
    dom.html(tplPropertySheet({
      showHeader: properties.getValue('showHeader') !== false,
      showControls: properties.getValue('showControls') !== false,
      showFooter: properties.getValue('showFooter') !== false,
      headerDisplayName: webEditorsLex.get('displayName'),
      headerValue: webEditorsLex.get('value'),
      headerCommands: bajauxLex.get('commands'),
      headerName: webEditorsLex.get('name'),
      headerFlags: webEditorsLex.get('flags'),
      headerType: webEditorsLex.get('type'),
      headerFacets: webEditorsLex.get('facets')
    })).addClass('PropertySheet');
    if (!that.$isNested()) {
      dom.addClass('ux-fullscreen');
    }

    //c.f. NCCB-11271, NCCB-25584
    dom.on('keydown', '.editor input', function (e) {
      if (e.keyCode === ENTER_KEY && !that.$isNested()) {
        if (that.isModified()) {
          that.$getSaveCommand().invoke()["catch"](logSevere);
        }
        return false;
      }
    });
    return CompositeEditor.prototype.doInitialize.apply(that, arguments);
  };

  /**
   * @private
   * @returns {JQuery}
   */
  PropertySheet.prototype.$getTableContainer = function () {
    return this.jq().children('.PropertySheet-table-container');
  };

  /**
   * @private
   * @returns {boolean}
   */
  PropertySheet.prototype.$isNested = function () {
    return !!this.properties().getValue('nested');
  };

  /**
   * Adds Baja event listeners to add/remove `PropertySheetRow`s as the
   * loaded component has slots added or removed.
   *
   * @param {module:nmodule/webEditors/rc/fe/baja/util/Attachable} attachable
   */
  PropertySheet.prototype.attach = function (attachable) {
    var that = this;
    attachable.attach({
      added: function added(prop) {
        return that.$builder.$loadFor(prop).then(function () {
          return that.$subscribeKids(that.value());
        });
      },
      removed: function removed(prop) {
        var ed = that.$getRowForKey(prop);
        if (ed) {
          var jq = ed.jq();
          that.$builder.destroyFor(prop).then(function () {
            jq.remove();
          })["catch"](logSevere);
        }
      },
      flagsChanged: function flagsChanged(prop) {
        that.$rebuildForSlot(prop);
      },
      reordered: function reordered() {
        doReorder(that);
      }
    });
  };

  /**
   * Loads the component. If the component is mounted and has actions to fire,
   * the "actions" command will be enabled.
   *
   * @param {baja.Complex} complex
   * @returns {Promise} promise to be resolved when the complex has
   * loaded and the actions command has been enabled or disabled.
   */
  PropertySheet.prototype.doLoad = function (complex) {
    var that = this;
    return CompositeEditor.prototype.doLoad.apply(that, arguments).then(function () {
      applyEvenOdd(that);

      // Insert the loaded table into the body and switch the fragment for the real DOM.
      var tbodyJq = that.$getTableContainer().children('table').children('tbody');
      tbodyJq.append(that.$tableBody);
      that.$tableBody = tbodyJq;
      that.$subscribeKids(complex)["catch"](logSevere); //don't wait on it, just kick it off
      return null; //squelch "promise not returned"
    });
  };
  PropertySheet.prototype.doRead = function () {
    var _this = this;
    var readBehavior = this.properties().getValue("readBehavior");
    return CompositeEditor.prototype.doRead.apply(this, arguments).then(function (diff) {
      if (readBehavior === "copy") {
        var copy = _this.value().newCopy(true);
        return diff.apply(copy);
      }
      return diff;
    });
  };

  /**
   * After destroying all child editors, removes the `PropertySheet` class
   * added in `initialize()`.
   *
   * @returns {Promise} promise to be resolved when all child editors
   * are destroyed and CSS classes are removed
   */
  PropertySheet.prototype.doDestroy = function () {
    var that = this,
      kidsToDestroy = _.filter(that.getChildEditors(), function (kid) {
        //individual rows will destroy their own sub-sheets - don't double dip
        return kid instanceof BaseEditor && !(kid instanceof PropertySheet);
      });
    return Promise.all(_.invoke(kidsToDestroy, 'destroy')).then(function () {
      that.jq().removeClass('PropertySheet ux-fullscreen');
      setTimeout(function () {
        that.$unsubscribeKids()["catch"](logSevere);
      }, UNSUBSCRIBE_DELAY);
    });
  };

  /**
   * Overridden to ensure that child editors are read directly from the table
   * if no element specified (prevent control editors from being included).
   *
   * @param dom
   * @returns {*}
   */
  PropertySheet.prototype.getChildEditors = function (dom) {
    return CompositeEditor.prototype.getChildEditors.call(this, dom || this.$getTableBody());
  };
  PropertySheet.prototype.validate = function () {
    return CompositeEditor.prototype.validate.apply(this, arguments)["catch"](function (err) {
      if (err instanceof CompositeError) {
        var errDetails = _.map(err.map, function (err, key) {
          return webEditorsLex.get(VALIDATE_FAIL_KEY, key, err);
        });
        throw new Error(errDetails.join('\n'));
      }
      throw err;
    });
  };
  return PropertySheet;
});
