function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/util/PatternFilter
 */
define(['underscore'], function (_) {
  'use strict';

  var any = _.any;
  var pfToRegex = {
    '*': '.*',
    '?': '.'
  };

  /**
   * JS reimplementation of Java PatternFilter class, for legacy use.
   * @class
   * @alias module:nmodule/webEditors/rc/util/PatternFilter
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function () {
    /**
     * @param {string} pattern where `*` means zero or more characters and `?` means exactly one
     * character.
     */
    function PatternFilter(pattern) {
      _classCallCheck(this, PatternFilter);
      this.$regex = new RegExp('^' + pattern.replace(/[*?]/g, function (match) {
        return pfToRegex[match];
      }) + '$');
    }

    /**
     * @param {string} str
     * @returns {boolean} if the given string matches this PatternFilter
     */
    return _createClass(PatternFilter, [{
      key: "accept",
      value: function accept(str) {
        return this.$regex.test(str);
      }

      /**
       * @param {string|module:nmodule/webEditors/rc/util/PatternFilter} pattern
       * @returns {module:nmodule/webEditors/rc/util/PatternFilter}
       */
    }], [{
      key: "parse",
      value: function parse(pattern) {
        if (pattern instanceof PatternFilter) {
          return pattern;
        }
        return new PatternFilter(pattern);
      }

      /**
       * @param {string} list
       * @param {string} [delimiter=' \t,;']
       * @returns {Array.<module:nmodule/webEditors/rc/util/PatternFilter>}
       */
    }, {
      key: "parseList",
      value: function parseList(list) {
        var delimiter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '[ \t,;]+';
        return list.split(new RegExp(delimiter)).filter(function (s) {
          return s;
        }).map(PatternFilter.parse);
      }

      /**
       * @param {Array.<string>} strings
       * @param {Array.<string|module:nmodule/webEditors/rc/util/PatternFilter>} patterns
       */
    }, {
      key: "anyMatch",
      value: function anyMatch(strings, patterns) {
        patterns = patterns.map(PatternFilter.parse);
        return any(strings, function (string) {
          return any(patterns.map(function (pattern) {
            return pattern.accept(string);
          }));
        });
      }
    }]);
  }();
});
