function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/*eslint-env browser */ /*jshint browser: true */
/* globals niagara */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/destination/StationFileDestinationType
 */
define(['baja!', 'lex!webEditors', 'jquery', 'Promise', 'underscore', 'nmodule/export/rc/ExportDestinationType', 'nmodule/webEditors/rc/servlets/views', 'nmodule/webEditors/rc/transform/exportUtils', 'nmodule/webEditors/rc/transform/transformer/ExporterTransformer', 'nmodule/webEditors/rc/util/fileUtils'], function (baja, lexes, $, Promise, _, ExportDestinationType, views, exportUtils, ExporterTransformer, fileUtils) {
  'use strict';

  var _lexes = _slicedToArray(lexes, 1),
    webEditorsLex = _lexes[0],
    getFileName = exportUtils.getFileName,
    getFilePath = exportUtils.getFilePath;

  /**
   * Destination for sending an export operation to a file in the file user home on the station.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/transform/destination/StationFileDestinationType
   */
  var StationFileDestinationType = /*#__PURE__*/function (_ExportDestinationTyp) {
    function StationFileDestinationType() {
      _classCallCheck(this, StationFileDestinationType);
      return _callSuper(this, StationFileDestinationType, arguments);
    }
    _inherits(StationFileDestinationType, _ExportDestinationTyp);
    return _createClass(StationFileDestinationType, [{
      key: "checkValid",
      value:
      /**
       * @throws {Error} if BajaScript is offline
       */
      function checkValid() {
        if (baja.isOffline()) {
          throw new Error('BajaScript is offline');
        }
      }
    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        return webEditorsLex.get('export.destination.stationFile.displayName');
      }
    }, {
      key: "prepare",
      value: function prepare(transformOp) {
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var fileOrd = cx.fileOrd;
        return checkPermissions(fileOrd).then(function () {
          return fileUtils.confirmServerFileWrite(fileOrd);
        });
      }

      /**
       * Writes the file found in cx.fileOrd to the server.
       *
       * @param {module:nmodule/export/rc/TransformOperation} transformOp
       * @param {object} [cx]
       * @param {string} [cx.fileOrd]
       * @param {string} [cx.viewOnExport=false]
       * @returns {Promise}
       */
    }, {
      key: "transform",
      value: function transform(transformOp) {
        var _this = this;
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var fileOrd = cx.fileOrd;
        return checkPermissions(fileOrd).then(function () {
          return _this.$saveToStation(transformOp, cx);
        })["catch"](function () {
          throw new Error(webEditorsLex.get('export.fileUploadFailed'));
        });
      }

      /**
       * @private
       * @param {module:nmodule/export/rc/TransformOperation} transformOp
       * @param {object} cx
       */
    }, {
      key: "$saveToStation",
      value: function $saveToStation(transformOp, cx) {
        var _this2 = this;
        var fileOrd = cx.fileOrd;
        var saveToStation = function saveToStation() {
          var transformer = transformOp.getTransformer();
          if (transformer instanceof ExporterTransformer) {
            return transformer.getTransformOrd(transformOp.getTransformedObject()).then(function (ordToExport) {
              return exportUtils.exportToStationFile(ordToExport, fileOrd, transformer.getExporterTypeSpec(), cx);
            });
          }
          return transformOp.doTransform(cx).then(function (data) {
            return fileUtils.upload(fileOrd, data);
          });
        };
        return saveToStation().then(function () {
          return cx.viewOnExport && _this2.$showView(cx);
        });
      }

      /**
       * Get the component to be loaded in as the destination config
       *
       * @param {module:nmodule/export/rc/TransformOperation} transformOp The transform operation this destination type is a target for
       * @returns {baja.Component} The destination config component.
       */
    }, {
      key: "getDestinationConfig",
      value: function getDestinationConfig(transformOp) {
        var comp = baja.$('baja:Component'),
          fileName = getFileName(transformOp, this),
          filePath = getFilePath(transformOp, this),
          fullFileName = filePath ? filePath + "/" + fileName : fileName;
        comp.add({
          slot: 'fileName',
          value: fullFileName,
          cx: {
            displayName: webEditorsLex.get('export.fileName')
          }
        });
        comp.add({
          slot: 'viewOnExport',
          value: false,
          cx: {
            displayName: webEditorsLex.get('export.viewOnExport')
          }
        });
        return comp;
      }

      /**
       * Converts a config Component into a destination context object.
       *
       * @param {baja.Component} config The destination config component
       * @returns {object|Promise<object>}
       */
    }, {
      key: "getDestinationContextObject",
      value: function getDestinationContextObject(config) {
        var cx = _superPropGet(StationFileDestinationType, "getDestinationContextObject", this, 3)([config]);
        return _.extend({
          fileOrd: 'file:^' + cx.fileName
        }, _.omit(cx, 'fileName'));
      }

      /**
       * @private
       */
    }, {
      key: "$getViewOrd",
      value: function $getViewOrd(viewList) {
        return viewList.length > 1 ? viewList.filter(function (view) {
          return view.typeName !== 'FileDownloadView' && view.moduleName !== 'web';
        })[0].ord : viewList[0].ord;
      }

      /**
       * @private
       */
    }, {
      key: "$showView",
      value: function $showView(cx) {
        var _this3 = this;
        return views.listViews(cx.fileOrd).then(function (viewList) {
          var resultOrd = _this3.$getViewOrd(viewList);
          return niagara.env.hyperlink(resultOrd);
        });
      }
    }]);
  }(ExportDestinationType);
  /**
   * @param {String} ord file ORD to write to
   * @returns {Promise} to be resolved if the user has write permissions, or
   * rejected if not
   */
  function checkPermissions(ord) {
    return fileUtils.isWritable(ord).then(function (writable) {
      if (!writable) {
        throw new Error('not writable');
      }
    });
  }
  return StationFileDestinationType;
});
