function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/numberUtils'], function (baja, Promise, _, numberUtils) {
  'use strict';

  var toDisplay = numberUtils.toDisplay;

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/fe/baja/util/rangeUtils
   */
  var exports = {};

  /**
   * Gets min/max info from the facets, and a string representation
   * of that range in the form `[min - max]`. `min` and `max` default to
   * `-inf` and `+inf` if not present.
   *
   * `min` and `max` will be converted to number with `valueOf`, so `RelTime`s
   * etc. work as well.
   *
   * @param {Object|baja.Facets} facets
   * @returns {Promise.<{ min: number, max: number, rangeStr: string }>}
   */
  exports.getRangeInfo = function (facets) {
    if (!facets || _typeof(facets) !== 'object') {
      return Promise.reject(new Error('facets required'));
    }
    var obj = toObject(facets),
      max = obj.max,
      min = obj.min,
      rangeStr = '';
    if (!min && min !== 0) {
      min = baja.Double.NEGATIVE_INFINITY;
    }
    if (!max && max !== 0) {
      max = baja.Double.POSITIVE_INFINITY;
    }
    if (!((min === baja.Float.NEGATIVE_INFINITY || min === baja.Double.NEGATIVE_INFINITY) && (max === baja.Float.POSITIVE_INFINITY || max === baja.Double.POSITIVE_INFINITY))) {
      return Promise.all([toDisplay(min, obj), toDisplay(max, obj)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          minDisplay = _ref2[0],
          maxDisplay = _ref2[1];
        return {
          min: min.valueOf(),
          max: max.valueOf(),
          rangeStr: '[' + minDisplay + ' - ' + maxDisplay + ']'
        };
      });
    }
    return Promise.resolve({
      min: min.valueOf(),
      max: max.valueOf(),
      rangeStr: rangeStr
    });
  };

  /**
   * Checks to see if the given value is in range according to any `min` or
   * `max` values set on the given facets. Throws an appropriate message if
   * out of range, otherwise returns nothing.
   *
   * @param {Number} value number to check, or any value that can convert to
   * a number with `valueOf`
   * @param {Object|baja.Facets} facets
   * @returns {Promise} promise to be rejected if value is out of range
   */
  exports.inRange = function (value, facets) {
    var obj = toObject(facets),
      min = obj.min,
      max = obj.max,
      num = value.valueOf(),
      tmpFacets = _.extend({}, obj);
    if (baja.hasType(value, 'baja:Integer') || baja.hasType(value, 'baja:Long')) {
      if (min === baja.Float.NEGATIVE_INFINITY || min === baja.Double.NEGATIVE_INFINITY) {
        tmpFacets.min = baja.Long.MIN_VALUE;
      }
      if (max === baja.Float.POSITIVE_INFINITY || max === baja.Double.POSITIVE_INFINITY) {
        tmpFacets.max = baja.Long.MAX_VALUE;
      }
    }
    return exports.getRangeInfo(tmpFacets).then(function (rangeInfo) {
      var rangeStr = rangeInfo.rangeStr;
      if (max !== undefined && max !== null && num > max) {
        return Promise.all([toDisplay(value, obj), toDisplay(max, obj)]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            valueDisplay = _ref4[0],
            maxDisplay = _ref4[1];
          throw new Error(valueDisplay + ' > ' + maxDisplay + ' ' + rangeStr);
        });
      } else if (min !== undefined && min !== null && num < min) {
        return Promise.all([toDisplay(value, obj), toDisplay(min, obj)]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            valueDisplay = _ref6[0],
            minDisplay = _ref6[1];
          throw new Error(valueDisplay + ' < ' + minDisplay + ' ' + rangeStr);
        });
      }
    });
  };

  /**
   * Given an ordinal and an `EnumRange`, resolve the display string for the
   * associated tag.
   *
   * If the range has a `lexicon` facet specified, resolve that lexicon and look
   * for an entry matching the tag. Otherwise, return the tag itself (unescaped
   * according to `SlotPath` rules).
   *
   * @param {Number} ordinal
   * @param {baja.EnumRange} range
   * @returns {Promise} promise to be resolved with a display string for the
   * tag denoted by the given ordinal
   */
  exports.getEnumRangeDisplay = function (ordinal, range) {
    return baja.DynamicEnum.make(ordinal).toString({
      range: range
    });
  };
  function toObject(facets) {
    return baja.hasType(facets, 'baja:Facets') ? facets.toObject() : facets;
  }
  return exports;
});
