/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/PermissionsEditor
 */
define(['baja!', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'bajaux/events', 'jquery', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe'], function (baja, BaseEditor, events, $, _, Promise, fe) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * A field editor for working with a Permissions object.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/PermissionsEditor
   */
  var PermissionsEditor = function PermissionsEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend(true, {
      keyName: 'PermissionsEditor'
    }, params));
  };
  PermissionsEditor.prototype = Object.create(BaseEditor.prototype);
  PermissionsEditor.prototype.constructor = PermissionsEditor;

  /**
   * Creates a Permissions element.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  PermissionsEditor.prototype.doInitialize = function (dom) {
    var that = this;

    //if a row is modified, set myself modified
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return fe.buildFor({
      dom: $('<span class="stringEncoding"/>').appendTo(dom),
      value: '',
      // default value, the actual value will be loaded in doLoad.
      formFactor: 'mini'
    }).then(function (stringEditor) {
      that.$stringEncodingEditor = stringEditor;
      return stringEditor.setReadonly(true);
    });
  };

  /**
   * Loads the given baja.Permissions into the editor.
   *
   * @param {baja.Permissions} permissions
   */
  PermissionsEditor.prototype.doLoad = function (permissions) {
    var that = this;
    return that.$getStringEncodingEditor().load(permissions.encodeToString());
  };

  /**
   * Read the child editor and assemble it into a `Permissions` object
   *
   * @returns {Promise.<baja.Permissions>} promise to be resolved with a `baja.Permissions` value
   */
  PermissionsEditor.prototype.doRead = function () {
    var that = this;
    return that.$getStringEncodingEditor().read().then(function (stringEncoding) {
      return baja.Permissions.DEFAULT.decodeFromString(stringEncoding);
    });
  };

  /**
   * Return the superUser checkbox editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  PermissionsEditor.prototype.$getStringEncodingEditor = function () {
    return this.$stringEncodingEditor;
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  PermissionsEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return PermissionsEditor;
});
