function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/schedule/bacnetScheduleMgr
 * @since Niagara 4.14
 */

define(['baja!', 'baja!bacnet:BacnetObjectType', 'log!nmodule.bacnet.rc.wb.mgr.schedule.BacnetScheduleManager', 'nmodule/bacnet/rc/wb/mgr/model/BacnetScheduleLearnModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'Promise', 'underscore'], function (baja, types, log, BacnetScheduleLearnModel, compUtils, addMgrLearnSupport, TreeNode, Promise, _) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var constant = _.constant;
  var DISCOVERY_SCHEDULE_ICON = baja.Icon.make(['module://icons/x16/schedule.png']),
    DISCOVERY_CALENDAR_SCHEDULE_ICON = baja.Icon.make(['module://icons/x16/calendar.png']);
  var OBJECT_TYPE_ENUM = baja.$('bacnet:BacnetObjectType');
  function getIcon(objectId) {
    var objectType = objectId.getObjectType();
    var calendar = OBJECT_TYPE_ENUM.get('calendar');
    if (objectType === calendar.getOrdinal()) {
      return DISCOVERY_CALENDAR_SCHEDULE_ICON;
    }
    return DISCOVERY_SCHEDULE_ICON;
  }
  function makeDiscoveryTableNode(schedule) {
    var scheduleName = schedule.getObjectName();
    var node = new TreeNode(scheduleName, scheduleName);
    node.getIcon = constant(getIcon(schedule.getObjectId()));
    node.mayHaveKids = constant(false);
    node.value = constant(schedule);
    return node;
  }

  /**
   * 
   * @param {object} params 
   * @param {module:nmodule/driver/rc/wb/mgr/DriverMgr} params.extends
   * @returns {Function} construct to make a Bacnet schedule import/export manager
   */
  function bacnetScheduleMgr(params) {
    var Super = params["extends"];
    var BacnetScheduleManager = /*#__PURE__*/function (_Super) {
      function BacnetScheduleManager() {
        var _this;
        _classCallCheck(this, BacnetScheduleManager);
        _this = _callSuper(this, BacnetScheduleManager, arguments);
        addMgrLearnSupport(_this);
        return _this;
      }

      /**
       * 
       * @param {JQuery} dom 
       * @return {Promise}
       */
      _inherits(BacnetScheduleManager, _Super);
      return _createClass(BacnetScheduleManager, [{
        key: "doInitialize",
        value: function doInitialize(dom) {
          var _this2 = this;
          this.on('jobcomplete', function (job) {
            _this2.$doDiscoveryJobComplete(job)["catch"](logSevere);
          });
          return _superPropGet(BacnetScheduleManager, "doInitialize", this, 3)(arguments);
        }

        /**
         * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
         */
      }, {
        key: "makeLearnModel",
        value: function makeLearnModel() {
          return BacnetScheduleLearnModel.make();
        }

        /**
         * @returns {Promise}
         */
      }, {
        key: "doDiscover",
        value: function doDiscover() {
          var _this3 = this;
          var schedulesExt = this.getSchedulesExt();
          return schedulesExt.submitScheduleDiscoveryJob().then(function (ord) {
            ord = baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: ord.relativizeToSession()
            });
            return _this3.setJob(ord);
          });
        }

        /**
         * @returns {baja.Component}
         */
      }, {
        key: "getSchedulesExt",
        value: function getSchedulesExt() {
          return compUtils.closest(this.value(), 'bacnet:BacnetScheduleDeviceExt');
        }

        /**
         *
         * @returns {object}
         */
      }, {
        key: "saveStateForOrd",
        value: function saveStateForOrd() {
          var obj = {};
          if (this.$discoveredSchedules) {
            obj.discoveredSchedules = this.$discoveredSchedules.map(function (schedule) {
              return baja.bson.encodeValue(schedule);
            });
          }
          return obj;
        }

        /**
         * @param {object} param
         * @param {Array} param.discoveredSchedules
         * @returns {Promise}
         */
      }, {
        key: "restoreStateForOrd",
        value: function restoreStateForOrd(_ref) {
          var _this4 = this;
          var discoveredSchedules = _ref.discoveredSchedules;
          if (discoveredSchedules) {
            return Promise.all(discoveredSchedules.map(function (schedule) {
              return baja.bson.decodeAsync(schedule);
            })).then(function (decodedSchedules) {
              _this4.$discoveredSchedules = decodedSchedules;
              return _this4.$updateLearnTableModel();
            });
          }
          return Promise.resolve();
        }

        /**
         * @private
         * @returns {Promise}
         */
      }, {
        key: "$doDiscoveryJobComplete",
        value: function $doDiscoveryJobComplete(job) {
          if (job.getType().is('bacnet:BacnetDiscoverSchedulesJob')) {
            this.$discoveredSchedules = job.getSlots().is('bacnet:DiscoverySchedule').toValueArray();
            return this.$updateLearnTableModel();
          }
        }

        /**
         * @private
         * @returns {Promise}
         */
      }, {
        key: "$updateLearnTableModel",
        value: function $updateLearnTableModel() {
          var learnModel = this.getLearnModel();
          var nodes = this.$discoveredSchedules.map(makeDiscoveryTableNode);
          return learnModel.clearRows().then(function () {
            return learnModel.insertRows(nodes, 0);
          });
        }
      }]);
    }(Super);
    return BacnetScheduleManager;
  }
  return bacnetScheduleMgr;
});
