/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn
 */
define(['baja!', 'lex!bacnet', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'baja!bacnet:BacnetDeviceObject'], function (baja, lexs, PropertyPathMgrColumn, Column) {
  'use strict';

  var bacnetLex = lexs[0],
    DEVICE_ID_ORDINAL = 8,
    DEVICE_ID_TAG = 'Device';

  /**
   * Manager column for a BACnet device id.
   *
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn}
   * @alias module:nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn
   */
  var DeviceIdMgrColumn = function DeviceIdMgrColumn() {
    PropertyPathMgrColumn.call(this, 'config/deviceObject/objectId', {
      displayName: bacnetLex.get('deviceManager.deviceId'),
      type: baja.lt('bacnet:BacnetDeviceObject'),
      flags: Column.flags.EDITABLE
    });
  };
  DeviceIdMgrColumn.prototype = Object.create(PropertyPathMgrColumn.prototype);
  DeviceIdMgrColumn.prototype.constructor = DeviceIdMgrColumn;

  /**
   * Configure this column to use the BACnet object id editor, but with the range
   * of object types constrained to just the device id type.
   *
   * @param rows
   * @returns {*}
   */
  DeviceIdMgrColumn.prototype.getConfigFor = function (rows) {
    var config = PropertyPathMgrColumn.prototype.getConfigFor.apply(this, arguments);
    config.properties.add('range', baja.EnumRange.make({
      ordinals: [DEVICE_ID_ORDINAL],
      tags: [DEVICE_ID_TAG]
    }));
    return config;
  };
  return DeviceIdMgrColumn;
});
