function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/history/BacnetHistoryImportUxManager
 * @since Niagara 4.14
 */
define(['baja!', 'baja!bacnet:BacnetHistoryImport,bacnet:BacnetTrendLogMultipleImport,bacnet:AbstractBacnetHistory,bacnet:BacnetHistoryDeviceExt,bacnet:DiscoveryLog,bacnet:BacnetObjectType', 'log!nmodule.bacnet.rc.wb.mgr.history.BacnetHistoryImportUxManager', 'nmodule/bacnet/rc/wb/mgr/model/BacnetHistoryImportLearnModel', 'nmodule/bacnet/rc/wb/mgr/model/BacnetHistoryImportModel', 'nmodule/driver/rc/wb/mgr/history/HistoryImportManager', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'Promise', 'underscore'], function (baja, types, log, BacnetHistoryImportLearnModel, BacnetHistoryImportModel, HistoryImportManager, compUtils, addMgrLearnSupport, MgrTypeInfo, TreeNode, Promise, _) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var constant = _.constant;
  var DISCOVERY_LOG_ICON = baja.Icon.make(['module://icons/x16/history.png']);
  var OBJECT_TYPE_ENUM = baja.$('bacnet:BacnetObjectType');
  var _types = _slicedToArray(types, 2),
    BACNET_HISTORY_IMPORT_TYPE = _types[0],
    BACNET_TREND_LOG_MULTIPLE_TYPE = _types[1];
  function makeDiscoveryTableNode(log) {
    var logName = log.getObjectName();
    var node = new TreeNode(logName, logName);
    node.getIcon = constant(DISCOVERY_LOG_ICON);
    node.mayHaveKids = constant(false);
    node.value = constant(log);
    return node;
  }

  /**
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/history/BacnetHistoryImportUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/history/HistoryImportManager
   */
  return /*#__PURE__*/function (_HistoryImportManager) {
    function BacnetHistoryImportUxManager(params) {
      var _this;
      _classCallCheck(this, BacnetHistoryImportUxManager);
      _this = _callSuper(this, BacnetHistoryImportUxManager, [Object.assign({
        moduleName: 'bacnet',
        keyName: 'BacnetHistoryImportUxManager',
        editableTypes: [baja.lt('bacnet:AbstractBacnetHistory')],
        getComponentStatus: function getComponentStatus(c) {
          return baja.Status.getStatusFromIStatus(c);
        },
        subscriptionDepth: 3
      }, params)]);
      addMgrLearnSupport(_this);
      return _this;
    }

    /**
     * 
     * @param {JQuery} dom 
     * @return {Promise}
     */
    _inherits(BacnetHistoryImportUxManager, _HistoryImportManager);
    return _createClass(BacnetHistoryImportUxManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        this.on('jobcomplete', function (job) {
          _this2.$doDiscoveryJobComplete(job)["catch"](logSevere);
        });
        return _superPropGet(BacnetHistoryImportUxManager, "doInitialize", this, 3)(arguments);
      }

      /**
       * @param {baja.Component} trendLogsContainer
       * @returns {Promise.<module:nmodule/bacnet/rc/wb/mgr/model/BacnetHistoryImportModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(trendLogsContainer) {
        return BacnetHistoryImportModel.make(trendLogsContainer);
      }

      /**
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return BacnetHistoryImportLearnModel.make();
      }

      /**
       * 
       * @param {baja.Struct} discoveryLog the 'bacnet:DiscoveryLog' object
       * @param {baja.Component} bacnetHistoryObj the 'bacnet:AbstractBacnetHistory' object
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(discoveryLog, bacnetHistoryObj) {
        if (!baja.hasType(bacnetHistoryObj, 'bacnet:AbstractBacnetHistory')) {
          return false;
        }
        return discoveryLog.get('objectId').equals(bacnetHistoryObj.get('objectId'));
      }

      /**
       *
       * @returns {object}
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        var obj = {};
        if (this.$discoveredTrendLogs) {
          obj.discoveredTrendLogs = this.$discoveredTrendLogs.map(function (trendLog) {
            return baja.bson.encodeValue(trendLog);
          });
        }
        return obj;
      }

      /**
       * @param {object} param
       * @param {Array} param.discoveredTrendLogs
       * @returns {Promise}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(_ref) {
        var _this3 = this;
        var discoveredTrendLogs = _ref.discoveredTrendLogs;
        if (discoveredTrendLogs) {
          return Promise.all(discoveredTrendLogs.map(function (trendLog) {
            return baja.bson.decodeAsync(trendLog);
          })).then(function (decodedTrendLogs) {
            _this3.$discoveredTrendLogs = decodedTrendLogs;
            return _this3.$updateLearnTableModel();
          });
        }
        return Promise.resolve();
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this4 = this;
        var trendLogsExt = this.getTrendLogsExt();
        return trendLogsExt.submitTrendLogDiscoveryJob().then(function (ord) {
          ord = baja.Ord.make({
            base: baja.Ord.make('station:'),
            child: ord.relativizeToSession()
          });
          return _this4.setJob(ord);
        });
      }

      /**
       * @returns {baja.Component}
       */
    }, {
      key: "getTrendLogsExt",
      value: function getTrendLogsExt() {
        return compUtils.closest(this.value(), 'bacnet:BacnetHistoryDeviceExt');
      }

      /**
       * @param {baja.Struct} subject a `bacnet:DiscoveryLog`
       * @returns {Promise.resolve<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        var objectType = subject.getObjectId().getObjectType();
        var trendLogMultiple = OBJECT_TYPE_ENUM.get('trendLogMultiple');

        // Setting concreateTypes: true just to ensure we pick all the third-party implementations
        // of supported trendlog import types.
        if (objectType === trendLogMultiple.getOrdinal()) {
          return MgrTypeInfo.make({
            from: BACNET_TREND_LOG_MULTIPLE_TYPE,
            concreteTypes: true
          });
        }
        return MgrTypeInfo.make({
          from: BACNET_HISTORY_IMPORT_TYPE,
          concreteTypes: true
        });
      }

      /**
       * 
       * @param {baja.Struct} discovery a `bacnet:DiscoveryLog` 
       * @param {baja.Component} bacnetHistoryImport 
       * @returns {Object}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, bacnetHistoryImport) {
        return {
          name: bacnetHistoryImport && bacnetHistoryImport.getName() || discovery.getObjectName(),
          values: {
            objectId: discovery.getObjectId(),
            discoveryHistoryType: discovery.getDataType()
          }
        };
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doDiscoveryJobComplete",
      value: function $doDiscoveryJobComplete(job) {
        if (job.getType().is('bacnet:BacnetDiscoverTrendLogsJob')) {
          this.$discoveredTrendLogs = job.getSlots().is('bacnet:DiscoveryLog').toValueArray();
          return this.$updateLearnTableModel();
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateLearnTableModel",
      value: function $updateLearnTableModel() {
        var learnModel = this.getLearnModel();
        var nodes = this.$discoveredTrendLogs.map(makeDiscoveryTableNode);
        return learnModel.clearRows().then(function () {
          return learnModel.insertRows(nodes, 0);
        });
      }
    }]);
  }(HistoryImportManager);
});
