function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/bacnet/rc/wb/export/BacnetNiagaraLogExportUxManager
 */

define(['baja!', 'baja!bacnet:IBacnetExportObject,control:ControlPoint', 'Promise', 'underscore', 'nmodule/bacnet/rc/wb/mgr/commands/ChangeHistoryDeviceNameCommand', 'nmodule/bacnet/rc/baja/enums/BacnetObjectType', 'nmodule/driver/rc/wb/mgr/DriverMgr', 'nmodule/bacnet/rc/wb/mgr/export/BacnetExportUxManager', 'nmodule/driver/rc/wb/mgr/history/HistoryExportLearnNode', 'nmodule/bacnet/rc/wb/mgr/model/BacnetNiagaraLogExportModel', 'nmodule/bacnet/rc/wb/mgr/model/BacnetNiagaraLogExportLearnModel', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils'], function (baja, types, Promise, _, ChangeHistoryDeviceNameCommand, BacnetObjectType, DriverMgr, BacnetExportUxManager, HistoryExportLearnNode, BacnetNiagaraLogExportModel, BacnetNiagaraLogExportLearnModel, MgrLearn, MgrTypeInfo, mgrUtils) {
  'use strict';

  var HISTORY_ALL_DEVICES_NAV_NAME = 'history:///';
  function getName(bacnetExportObject, instanceNumber) {
    var objectId = bacnetExportObject.getObjectId();
    var instance = instanceNumber || objectId.getInstanceNumber();
    return BacnetObjectType.tagForId(objectId.getObjectType()) + '_' + instance;
  }

  /**
   * Manager for BacnetNiagaraLogs
   * @class
   * @alias module:nmodule/bacnet/rc/wb/export/BacnetNiagaraLogExportUxManager
   * @extends module:nmodule/bacnet/rc/wb/mgr/export/BacnetExportUxManager
   */
  var BacnetNiagaraLogExportUxManager = /*#__PURE__*/function (_BacnetExportUxManage) {
    function BacnetNiagaraLogExportUxManager(params) {
      _classCallCheck(this, BacnetNiagaraLogExportUxManager);
      return _callSuper(this, BacnetNiagaraLogExportUxManager, [Object.assign({
        moduleName: 'bacnet',
        keyName: 'BacnetNiagaraLogExportUxManager',
        getComponentStatus: function getComponentStatus(c) {
          return baja.Status.getStatusFromIStatus(c);
        },
        editableTypes: [baja.lt('bacnet:IBacnetExportObject')],
        subscriptionDepth: 3,
        folderType: baja.lt('bacnet:BacnetExportFolder')
      }, params)]);
    }

    /**
     * @param {baja.Component} exportContainer
     * @returns {Promise.<module:nmodule/bacnet/rc/wb/mgr/model/BacnetExportModel>}
     */
    _inherits(BacnetNiagaraLogExportUxManager, _BacnetExportUxManage);
    return _createClass(BacnetNiagaraLogExportUxManager, [{
      key: "makeModel",
      value: function makeModel(exportContainer) {
        return BacnetNiagaraLogExportModel.make(exportContainer);
      }
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return BacnetNiagaraLogExportLearnModel.make();
      }
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var _this = this;
        this.$historyDeviceNameCommand = new ChangeHistoryDeviceNameCommand(this);
        return DriverMgr.prototype.makeCommands.apply(this, arguments).then(function (cmds) {
          cmds.push(_this.$historyDeviceNameCommand);
          return cmds;
        });
      }
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this2 = this;
        return this.$resolveHistorySpace().then(function (children) {
          return children.filter(function (child) {
            return child.getNavName() !== "AuditHistory" && child.getNavName() !== "AlarmHistory";
          });
        }).then(function (children) {
          _this2.$discoveredLogs = children;
          return children && _this2.$updateTable(children, _this2.getLearnModel());
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<baja.NavNode>>} a promise that will be resolved
       * once the nav children of historySpace have been retrieved.
       */
    }, {
      key: "$resolveHistorySpace",
      value: function $resolveHistorySpace() {
        return baja.Ord.make("history:").get().then(function (historySpace) {
          return historySpace.getNavChildren();
        }).then(function (children) {
          var allDeviceHistoryFolder = children.find(function (node) {
            return node.getNavName() === HISTORY_ALL_DEVICES_NAV_NAME;
          });
          return allDeviceHistoryFolder && allDeviceHistoryFolder.getNavChildren() || children;
        }).then(function (devices) {
          return Promise.all(devices.map(function (device) {
            return device.getNavChildren();
          }));
        }).then(function (children) {
          return _.flatten(children);
        });
      }

      /**
       * @private
       * @param {Array.<Object>|Object} data the data returned from the station
       * @param learnModel
       * @returns {Promise}
       */
    }, {
      key: "$updateTable",
      value: function $updateTable(data, learnModel) {
        if (Array.isArray(data)) {
          return Promise.all(data.map(function (device) {
            return new HistoryExportLearnNode(device);
          })).then(function (devices) {
            return learnModel.clearRows().then(function () {
              return learnModel.insertRows(devices);
            });
          });
        }
        return Promise.resolve();
      }
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        return MgrTypeInfo.make('bacnet:BacnetNiagaraHistoryDescriptor');
      }
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, history) {
        return this.$getProposedInstanceNumber(history).then(function (instanceNumber) {
          return {
            name: getName(history, instanceNumber),
            values: {
              objectOrd: baja.Ord.make('history:' + discovery.historyId),
              objectName: discovery.historyId.encodeToString(),
              instanceNumber: baja.Integer.make(instanceNumber),
              targetName: discovery.displayName
            }
          };
        });
      }

      /**
       * @private
       * @param {baja.Component} exportObject
       * @return {Promise<baja.Integer>}
       */
    }, {
      key: "$getProposedInstanceNumber",
      value: function $getProposedInstanceNumber(exportObject) {
        var name = exportObject.getName();
        // If the export object is already in the database then this is most likely
        // called from a Match operation and the next available instance number needs to be looked up.
        if (name && this.$getExportTable().has(name)) {
          var objectType = exportObject.getObjectId().getObjectType();
          return this.$generateInstanceNumber(objectType);
        }
        // Otherwise the instance number is already looked up so just return it
        return Promise.resolve(exportObject.getObjectId().getInstanceNumber());
      }

      /**
       *
       * @param {baja.Component} discovery
       * @param {baja.Value} exportObject
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(discovery, exportObject) {
        if (!baja.hasType(exportObject, 'bacnet:IBacnetExportObject') || baja.hasType(exportObject, 'bacnet:BacnetExportFolder')) {
          return false;
        }
        return discovery.historyId.encodeToString() === exportObject.getId().encodeToString();
      }

      // TODO To be implemented in NCCB-59950
      // /**
      //  *
      //  * @returns {object}
      //  */
      // saveStateForOrd() {
      //   let obj = {};
      //
      //   if (this.$discoveredLogs) {
      //     obj.discoveredLogs = this.$discoveredLogs;
      //   }
      //   return obj;
      // }
      //
      // /**
      //  * @param {object} param
      //  * @param {Array} param.discoveredLogs
      //  * @returns {Promise}
      //  */
      // restoreStateForOrd({ discoveredLogs }) {
      //   if (discoveredLogs) {
      //     this.$discoveredLogs = discoveredLogs;
      //     return this.$updateTable(this.$discoveredLogs, this.getLearnModel());
      //   }
      //
      //   return Promise.resolve();
      // }

      /**
       * @priavte
       * @returns {module:nmodule/bacnet/rc/wb/mgr/commands/ChangeHistoryDeviceNameCommand}
       */
    }, {
      key: "$getChangeHistoryDeviceNameCommand",
      value: function $getChangeHistoryDeviceNameCommand() {
        return this.$historyDeviceNameCommand;
      }

      /**
       * Enables or disables the
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this3 = this;
        return _superPropGet(BacnetNiagaraLogExportUxManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var deviceNameCmd = _this3.$historyDeviceNameCommand;
          var mainTableSelection = selectedSubjects.mainTableSelection;
          if (deviceNameCmd) {
            var enabled = mainTableSelection.length > 0;
            mainTableSelection.forEach(function (subject) {
              if (baja.hasType(subject, 'bacnet:BacnetExportFolder')) {
                enabled = false;
              }
            });
            deviceNameCmd.setEnabled(enabled);
          }
        });
      }
    }]);
  }(BacnetExportUxManager);
  return BacnetNiagaraLogExportUxManager;
});
