function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager
 */
define(['baja!', 'lex!bacnet,webEditors', 'Promise', 'underscore', 'nmodule/bacnet/rc/baja/datatypes/BacnetAddress', 'nmodule/bacnet/rc/baja/datatypes/BacnetUnsigned', 'nmodule/bacnet/rc/baja/datatypes/DiscoveryNetworks', 'nmodule/bacnet/rc/wb/mgr/commands/ChangeIdCommand', 'nmodule/bacnet/rc/wb/mgr/commands/TimeSynchCommand', 'nmodule/bacnet/rc/wb/mgr/commands/WhoHasCommand', 'nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceLearnModel', 'nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceMgrModel', 'nmodule/driver/rc/wb/mgr/DeviceMgr', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/wb/util/subscriptionUtil', 'hbs!nmodule/bacnet/rc/wb/mgr/template/BacnetDeviceUxManager', 'css!nmodule/bacnet/rc/bacnet', 'baja!bacnet:BacnetDevice,' + 'bacnet:BacnetDeviceFolder,' + 'bacnet:BacnetObjectIdentifier,' + 'bacnet:BacnetObjectType,' + 'bacnet:DiscoveryDevice,' + 'bacnet:BacnetNetwork'], function (baja, lexs, Promise, _, BacnetAddress, BacnetUnsigned, DiscoveryNetworks, ChangeIdCommand, TimeSynchCommand, WhoHasCommand, BacnetDeviceLearnModel, BacnetDeviceMgrModel, DeviceMgr, feDialogs, compUtils, componentStatusUtils, MgrTypeInfo, mgrUtils, addMgrLearnSupport, TreeNode, subscriptionUtil, tplBacnetDeviceUxManager) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bacnetLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var addComponentStatusCss = componentStatusUtils.addComponentStatusCss;
  var DISCOVERY_NODE_ICON = baja.Icon.make(['module://icons/x16/device.png']),
    BACNET_DEVICE_TYPE = baja.lt('bacnet:BacnetDevice'),
    BACNET_FOLDER_TYPE = baja.lt('bacnet:BacnetDeviceFolder'),
    BACNET_NETWORK_TYPE = baja.lt('bacnet:BacnetNetwork');
  var basicSubscriptionFilter = subscriptionUtil.basicSubscriptionFilter;
  function lex(key) {
    return bacnetLex.get(key);
  }
  function subscribeDeviceObjects(device, sub) {
    return device.getConfig().loadSlots().then(function () {
      return sub.subscribe(device.getConfig().getDeviceObject());
    });
  }

  ////////////////////////////////////////////////////////////////
  // BacnetDeviceUxManager
  ////////////////////////////////////////////////////////////////

  /**
   * BacnetDeviceUxManager constructor. Mixes in learn support.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgr
   * @mixes module:nmodule/webEditors/rc/wb/mgr/MgrLearn
   * @param {Object} params
   */
  var BacnetDeviceUxManager = function BacnetDeviceUxManager(params) {
    var superFinishDiscoveryRow;
    DeviceMgr.call(this, _.extend({
      moduleName: 'bacnet',
      keyName: 'BacnetDeviceUxManager',
      folderType: BACNET_FOLDER_TYPE,
      subscribeCallback: function subscribeCallback(_ref) {
        var comp = _ref.comp,
          sub = _ref.sub;
        var isDevice = comp.getType().is(BACNET_DEVICE_TYPE);
        if (!isDevice) {
          return;
        }
        return subscribeDeviceObjects(comp, sub);
      },
      subscriptionFilter: function subscriptionFilter(filterParams) {
        return basicSubscriptionFilter(Object.assign({
          containerTypes: [BACNET_FOLDER_TYPE, BACNET_NETWORK_TYPE],
          componentTypes: [BACNET_FOLDER_TYPE, BACNET_DEVICE_TYPE]
        }, filterParams));
      }
    }, params));
    addMgrLearnSupport(this);
    superFinishDiscoveryRow = this.finishDiscoveryTableRow;
    this.finishDiscoveryTableRow = function (row, dom) {
      return superFinishDiscoveryRow.call(this, row, dom).then(function () {
        if (row.getSubject().getDuplicate()) {
          addComponentStatusCss(baja.Status.fault, dom);
        }
        return dom;
      });
    };
  };
  BacnetDeviceUxManager.prototype = Object.create(DeviceMgr.prototype);
  BacnetDeviceUxManager.prototype.constructor = BacnetDeviceUxManager;

  /**
   * Overrides the device manager's doInitialize() function. This uses a template
   * with the elements slightly re-arranged, such that the job bar is outside of
   * the discovery pane and can therefore be used for other non-discovery jobs.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  BacnetDeviceUxManager.prototype.doInitialize = function (dom) {
    var that = this;
    that.on('jobcomplete', function (job) {
      if (job.getType().is('bacnet:BacnetDiscoverDevicesJob')) {
        that.$discoveryJobComplete(job, that);
      }
    });
    return DeviceMgr.prototype.doInitialize.call(that, dom, {
      html: tplBacnetDeviceUxManager({
        databaseTitle: webEditorsLex.get('mgr.titlePane.database'),
        discoveryTitle: webEditorsLex.get('mgr.titlePane.discovered')
      })
    });
  };

  /**
   * Override of the function called when the subscriber reports a component has
   * changed. This is overridden to avoid updating the table for certain properties
   * that have no significance for any of the columns in the table.
   *
   * @param {baja.Component} component
   * @param {baja.Property} prop
   */
  BacnetDeviceUxManager.prototype.componentChanged = function (component, prop) {
    // Filter out device time changes: these happen quite frequently and we
    // don't want the performance hit of updating the the table for those.

    if (prop.getName() !== 'localTime') {
      return DeviceMgr.prototype.componentChanged.apply(this, arguments);
    }
  };

  /**
   * This will enable/disable the ChangeIdCommand in addition to the default behavior.
   * @inheritDoc
   */
  BacnetDeviceUxManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var _this = this;
    return DeviceMgr.prototype.onTableSelectionChanged.call(this, selectedSubjects).then(function () {
      var mainTableSelection = selectedSubjects.mainTableSelection;
      var changeIdCmd = mgrUtils.findCommand(_this, ChangeIdCommand);
      changeIdCmd.setEnabled(_this.isSingleDeviceSelected(mainTableSelection));
    });
  };

  /**
   * Return the commands for the manager. This includes the basic commands
   * for a device manager with discovery support, and also adds the BACnet
   * specific commands.
   *
   * @returns {Promise.<Array.<module:bajaux/commands/Command>>}
   */
  BacnetDeviceUxManager.prototype.makeCommands = function () {
    var _this2 = this;
    return DeviceMgr.prototype.makeCommands.apply(this, arguments).then(function (cmds) {
      return cmds.concat([new WhoHasCommand(_this2), new TimeSynchCommand(_this2), new ChangeIdCommand(_this2)]);
    });
  };

  /**
   * Return the BacnetNetwork from the source component (which may be the network or may
   * be a device folder several levels deep).
   *
   * @returns {baja.Component}
   */
  BacnetDeviceUxManager.prototype.getNetwork = function () {
    return compUtils.closest(this.value(), baja.lt('bacnet:BacnetNetwork'));
  };

  /**
   * Test that we have a single item selected in the main database table,
   * and that it is a device, not a folder.
   *
   * @private
   * @param {Array.<*>|undefined} subjects the current selected subjects in the main table
   * @returns {Boolean}
   */
  BacnetDeviceUxManager.prototype.isSingleDeviceSelected = function (subjects) {
    return subjects.length === 1 && subjects[0].getType().is('bacnet:BacnetDevice');
  };

  ////////////////////////////////////////////////////////////////
  // Main Table
  ////////////////////////////////////////////////////////////////

  /**
   * Makes the model for the main database table.
   *
   * @param {baja.Component} component - a bacnet network or bacnet device folder instance.
   * @returns {Promise.<module:nmodule/driver/rc/wb/mgr/DeviceMgrModel>}
   */
  BacnetDeviceUxManager.prototype.makeModel = function (component) {
    return BacnetDeviceMgrModel.make(component, [BACNET_DEVICE_TYPE], this.getFolderType());
  };

  ////////////////////////////////////////////////////////////////
  // Learn Table
  ////////////////////////////////////////////////////////////////

  /**
   * Make a tree node for an item in the discovery table. Device discovery
   * nodes never have any children.
   *
   * @param  {Object} discovery - a discovered object.
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */
  function makeDiscoveryTableNode(discovery) {
    var name = String(discovery.deviceName),
      node = new TreeNode(name, name);
    node.getIcon = _.constant(DISCOVERY_NODE_ICON);
    node.mayHaveKids = _.constant(false);
    node.value = _.constant(discovery);
    return node;
  }

  /**
   * Reloads the contents of the discovery table following the completion
   * of the discovery job.
   *
   * @param mgr - the manager instance.
   * @returns {Promise}
   */
  function reloadLearnModel(mgr) {
    var model = mgr.getLearnModel(),
      currentCount = model.getRows().length,
      nodes,
      promise;
    nodes = _.map(mgr.$discoveries || [], makeDiscoveryTableNode);
    promise = currentCount ? model.removeRows(0, currentCount) : Promise.resolve();
    return promise.then(function () {
      return model.insertRows(nodes, 0);
    });
  }

  /**
   * Make the model for the discovery table. In most cases, the column's value
   * will be a property on a BDiscoveryDevice struct.
   *
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */
  BacnetDeviceUxManager.prototype.makeLearnModel = function () {
    return BacnetDeviceLearnModel.make();
  };

  ////////////////////////////////////////////////////////////////
  // Discovery
  ////////////////////////////////////////////////////////////////

  /**
   * Called when the discovery job completes, this will get the discovered
   * items from the job and reload the table.
   *
   * @private
   * @param {baja.Component} job - the network discovery job.
   */
  BacnetDeviceUxManager.prototype.$discoveryJobComplete = function (job) {
    var that = this;
    job.loadSlots().then(function () {
      var prom;
      if (job.isMounted()) {
        prom = job.lease({
          comps: [job],
          time: baja.RelTime.make({
            minutes: 1
          })
        });
      }
      return prom;
    }).then(function () {
      var props = job.getSlots().properties();
      that.$discoveries = props.is('bacnet:DiscoveryDevice').toValueArray();
      return reloadLearnModel(that);
    })["catch"](baja.error);
  };

  /**
   * Get the router table for the network. This is used when creating the DiscoveryNetworks
   * instance for the discovery and who-has commands.
   *
   * @param {baja.Component} network - the bacnet network instance.
   * @returns {Promise} a Promise resolving to a BacnetRouterTable instance for the network.
   */
  BacnetDeviceUxManager.prototype.$getRouterTable = function (network) {
    return baja.Ord.make(String(network.getNavOrd()) + '/bacnetComm/network/routerTable').get();
  };

  /**
   * Returns a promise that will resolve to a new `DiscoveryNetworks` instance
   * for the given network. This is used by the discovery job and the who-has
   * job, to indicate which networks should be the target of the job.
    * @returns {Promise}
   */
  BacnetDeviceUxManager.prototype.makeDiscoveryNetworks = function (network) {
    return this.$getRouterTable(network).then(function (routerTable) {
      var entries, dnets;
      entries = routerTable.getSlots().properties().is("bacnet:BacnetRouterEntry").toValueArray();
      dnets = _.invoke(entries, 'getDnet');
      return DiscoveryNetworks.make(false, dnets);
    });
  };

  /**
   * Show a dialog to obtain the configuration parameters for the network discovery job.
   * Returns the configuration object to be passed to the action that will submit the
   * job.
   *
   * @param {baja.Component} network - the bacnet network component
   * @returns {Promise} a promise resolving to a DeviceDiscoveryConfig instance, or null
   * if the user cancels the discovery.
   */
  BacnetDeviceUxManager.prototype.showDiscoveryConfigDialog = function (network) {
    return this.makeDiscoveryNetworks(network).then(function (networks) {
      var conf = baja.$('bacnet:DeviceDiscoveryConfig', {
        networks: networks
      });
      return feDialogs.props(conf, {
        title: lex('deviceManager.discover.description')
      });
    });
  };

  /**
   * Start the discovery work. This will pop up a dialog with an editor
   * for a DeviceDiscoveryConfig instance. Once the parameters have been
   * set, we can submit the discovery job and set it on the manager.
   *
   * @returns {Promise}
   */
  BacnetDeviceUxManager.prototype.doDiscover = function () {
    var that = this,
      network = that.getNetwork();
    return that.showDiscoveryConfigDialog(network).then(function (conf) {
      if (conf) {
        return network.submitDeviceManagerJob(conf).then(function (ord) {
          ord = baja.Ord.make({
            base: baja.Ord.make('station:'),
            child: ord.relativizeToSession()
          });
          return that.setJob(ord);
        });
      }
    });
  };

  /**
   * Return the types available to be created from a given discovery item. In the
   * case of the BACnet device manager, the only option is a new BBacnetDevice.
   *
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
   */
  BacnetDeviceUxManager.prototype.getTypesForDiscoverySubject = function () {
    return MgrTypeInfo.make(BACNET_DEVICE_TYPE);
  };

  /**
   * Get the values to be set as the proposals on the batch component editor for
   * the rows being added via the `AddCommand`. These are mostly the property values
   * read directly from the DiscoveryDevice object, cloned where appropriate, but for
   * the max APDU length, we need to convert from an int to a BacnetUnsigned.
   *
   * @param {baja.Struct} discovery - a DiscoveryDevice struct instance.
   * @param {module:baja/comp/ControlPoint} dbObject when a match is done, it is the database object that we are matching to
   * @returns {Object} - an object populated with properties to be used for the new row.
   */
  BacnetDeviceUxManager.prototype.getProposedValuesFromDiscovery = function (discovery, dbObject) {
    var SUBSCRIBE_COV_BIT_INDEX = 5,
      address = discovery.getAddress(),
      addressType = address.getAddressType(),
      mac = address.getMacAddress(),
      subscribeCov = !!discovery.getServicesSupported().isBitSet(SUBSCRIBE_COV_BIT_INDEX);
    return {
      name: dbObject && dbObject.getName() ? dbObject.getName() : discovery.getDeviceName(),
      values: {
        objectId: discovery.getObjectId(),
        macAddress: BacnetAddress.bytesToString(addressType, mac.getBytes()),
        networkNumber: baja.Integer.make(discovery.getAddress().getNetworkNumber()),
        maxAPDULengthAccepted: BacnetUnsigned.make(discovery.getMaxApduLengthAccepted()),
        segmentationSupported: discovery.getSegmentationSupported(),
        vendorName: discovery.getVendorName(),
        modelName: discovery.getModelName(),
        firmwareRevision: discovery.getFirmwareRevision(),
        applicationSoftwareVersion: discovery.getApplicationSoftwareVersion(),
        characterSet: discovery.getEncoding(),
        useCov: subscribeCov
      }
    };
  };

  /**
   * Test whether the given object matches the component in the station.
   * The comparison is based on the bacnet object identifier.
   *
   * @param discovery
   * @param {baja.Component} comp
   * @returns {boolean} - true if the discovery item and station component match.
   */
  BacnetDeviceUxManager.prototype.isExisting = function (discovery, comp) {
    var config;
    if (baja.hasType(comp, 'bacnet:BacnetDevice')) {
      config = comp.getConfig();
      return discovery.getObjectId().encodeToString() === config.getDeviceObject().getObjectId().encodeToString();
    }
    return false;
  };

  ////////////////////////////////////////////////////////////////
  // State
  ////////////////////////////////////////////////////////////////

  /**
   * Save the state we require for restoring after a hyperlink or page reload.
   * In addition to the visible columns saved by the base type, this will save
   * the last set of discovered devices and the ord of any job we may be displaying
   * in the job bar.
   *
   * @returns {Object} an object with the state to be persisted
   */
  BacnetDeviceUxManager.prototype.saveStateForOrd = function () {
    var that = this,
      obj = {};
    if (that.$discoveries) {
      obj.$discoveries = _.map(that.$discoveries, function (discovery) {
        return baja.bson.encodeValue(discovery);
      });
    }
    return obj;
  };

  /**
   * Restore the state we saved in the call to saveStateForOrd(). This
   * will reinstate the learn model from any BDiscoveryDevice instances
   * we persisted.
   *
   * @param {Object} obj - an object with data retrieved from the browser storage.
   * @returns {Promise.<*>}
   */
  BacnetDeviceUxManager.prototype.restoreStateForOrd = function (obj) {
    if (obj.$discoveries) {
      this.$discoveries = _.map(obj.$discoveries, function (discovery) {
        return baja.bson.decodeValue(discovery);
      });
      return reloadLearnModel(this);
    } else {
      return Promise.resolve();
    }
  };
  return BacnetDeviceUxManager;
});
