function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetAnyEditor
 */
define(['baja!', 'bajaux/events', 'bajaux/Widget', 'bajaux/mixin/batchSaveMixin', 'bajaux/mixin/subscriberMixIn', 'lex!bacnet', 'nmodule/bacnet/rc/baja/datatypes/BacnetAny', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'Promise', 'underscore', 'css!nmodule/bacnet/rc/bacnet'], function (baja, events, Widget, batchSaveMixin, subscriberMixin, lexs, BacnetAny, fe, BaseEditor, OrderedMapEditor, Promise, _) {
  'use strict';

  var bacnetLex = lexs[0],
    TYPE_MAP = BacnetAny.prototype.TYPE_MAP,
    TYPE = 'bacnet:BacnetAny',
    MODIFY_EVENT = events.MODIFY_EVENT,
    CHOICES = function () {
      var map = new baja.OrderedMap();
      _.each(TYPE_MAP, function (arg) {
        var choice = arg[0],
          lex = arg[2],
          text = arg[3];
        map.put(bacnetLex.get({
          key: lex,
          def: text
        }), choice);
      });
      return map;
    }();

  /**
   * Field editor for working with `bacnet:BacnetAny` instances.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/fe/BacnetAnyEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var BacnetAnyEditor = function BacnetAnyEditor() {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
    subscriberMixin(this);
  };
  BacnetAnyEditor.prototype = Object.create(BaseEditor.prototype);
  BacnetAnyEditor.prototype.constructor = BacnetAnyEditor;

  /**
   * Set event handlers to rebuild the `value` editor depending on which choice
   * is selected.
   *
   * @param {JQuery} dom
   */
  BacnetAnyEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html('<div class="js-choice"/><div class="js-value"/>');
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.js-choice', function () {
      var choice = that.$getChoiceEditor().getSelectedValue(),
        valueEd = that.$getValueEditor();
      valueEd.read().then(function (value) {
        return that.$loadAny(choice, value);
      })["catch"](baja.error);
    });
    return fe.buildFor({
      dom: dom.children('.js-choice'),
      formFactor: 'mini',
      type: OrderedMapEditor,
      value: CHOICES
    });
  };

  /**
   * @param {baja.Component} BacnetAny the `bacnet:BacnetAny` to load
   *
   * @returns {Promise}
   */
  BacnetAnyEditor.prototype.doLoad = function (bacnetAny) {
    return this.$loadAny(bacnetAny.get('choice'), bacnetAny.get('value'));
  };

  /**
   * Read a new `BacnetAny` with currently selected values.
   *
   * @returns {Promise.<baja.Component>}
   */
  BacnetAnyEditor.prototype.doRead = function () {
    return this.getChildEditors().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        choice = _ref2[0],
        value = _ref2[1];
      return baja.$(TYPE, {
        choice: choice,
        value: value
      });
    });
  };

  /**
   * Apply the currently entered `choice` and `value` values back to the
   * `BacnetAny`. Respects the `batchSaveMixin` contract.
   *
   * @param {baja.Component} bacnetAny - a `bacnet:BacnetAny` to save
   *
   * @param {Object} params
   */
  BacnetAnyEditor.prototype.doSave = function (bacnetAny, params) {
    var that = this,
      value = that.value(),
      batch = params && params.batch,
      progressCallback = params && params.progressCallback;
    var prom = Promise.all([value.set({
      slot: 'choice',
      value: bacnetAny.get('choice'),
      batch: batch
    }), value.set({
      slot: 'value',
      value: bacnetAny.get('value'),
      batch: batch
    })]);
    if (progressCallback) {
      progressCallback(batchSaveMixin.COMMIT_READY);
    }
    return prom;
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {boolean} enabled
   *
   * @returns {Promise}
   */
  BacnetAnyEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {boolean} readonly
   *
   * @returns {Promise}
   */
  BacnetAnyEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  BacnetAnyEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * Update the selected choice and value values, rebuilding the `value` editor
   * in the process as the choice may have changed.
   *
   * @private
   *
   * @param {number|baja.Integer} choice
   *
   * @param {*} value
   *
   * @returns {Promise}
   */
  BacnetAnyEditor.prototype.$loadAny = function (choice, value) {
    var that = this,
      valueEd = that.$getValueEditor(),
      type = TYPE_MAP[choice][1];
    choice = choice.valueOf();
    var getValue = baja.hasType(value, type) ? value : baja.importTypes([type]).then(function () {
      return baja.$(type);
    });
    return Promise.all([getValue, valueEd && valueEd.destroy()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
        value = _ref4[0];
      that.$getChoiceEditor().setSelectedValue(choice, true);
      return fe.buildFor({
        value: value,
        formFactor: 'mini',
        dom: that.$getValueElement()
      });
    });
  };

  /**
   * Get the editor for the selected choice.
   *
   * @private
   *
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  BacnetAnyEditor.prototype.$getChoiceEditor = function () {
    return Widget["in"](this.$getChoiceElement());
  };

  /**
   * Get the editor for the `value` slot.
   *
   * @private
   *
   * @returns {*}
   */
  BacnetAnyEditor.prototype.$getValueEditor = function () {
    return Widget["in"](this.$getValueElement());
  };

  /**
   * @private
   *
   * @returns {JQuery} element containing the `choice` editor
   */
  BacnetAnyEditor.prototype.$getChoiceElement = function () {
    return this.jq().children('.js-choice');
  };

  /**
   * @private
   *
   * @returns {JQuery} element containing the `value` editor
   */
  BacnetAnyEditor.prototype.$getValueElement = function () {
    return this.jq().children('.js-value');
  };
  return BacnetAnyEditor;
});
