/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetMultistate
 */
define(['nmodule/bacnet/rc/baja/BacnetObject', 'nmodule/webEditors/rc/baja/bajaUtils'], function (BacnetObject, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetMultistate` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/BacnetObject}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetMultistate}
   */
  var BacnetMultistate = function BacnetMultistate() {
    BacnetObject.apply(this, arguments);
    proxySlotFacets(this, {
      '^presentValue$': 'facets'
    });
  };
  BacnetMultistate.prototype = Object.create(BacnetObject.prototype);
  BacnetMultistate.prototype.constructor = BacnetMultistate;
  return BacnetMultistate;
});
