/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetBinaryOutput
 */
define(['nmodule/bacnet/rc/baja/config/BacnetBinary', 'nmodule/webEditors/rc/baja/bajaUtils'], function (BacnetBinary, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetBinaryOutput` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/config/BacnetBinary}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetBinaryOutput}
   */
  var BacnetBinaryOutput = function BacnetBinaryOutput() {
    BacnetBinary.apply(this, arguments);
    proxySlotFacets(this, {
      '^priorityArray$': 'facets'
    });
  };
  BacnetBinaryOutput.prototype = Object.create(BacnetBinary.prototype);
  BacnetBinaryOutput.prototype.constructor = BacnetBinaryOutput;
  return BacnetBinaryOutput;
});
