/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'lex!mobile'], function (baja, lexs) {

  "use strict";

  var mobileLex = lexs[0];

  /**
   * Get the display name for a component - try `getDisplayName` first, then
   * `getName`, then undefined if neither exists.
   * 
   * @memberOf niagara.util
   * @private
   * 
   * @param {baja.Complex} component
   * @returns {String}
   */
  function getComponentName(component) {
    if (!(component instanceof baja.Complex)) {
      return undefined;
    }

    return component.getDisplayName() || component.getName() || mobileLex.get('propsheet.station');
  }

  return {
    getComponentName: getComponentName
  };
});
