/**
 * @file Functions relating to the Niagara Mobile Property Sheet
 * user interface, HTML generation, event handling, etc.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*globals niagara */

/**
 * @namespace
 * @name niagara.propSheet.ui
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/util/ord', 'mobile/util/aop', 'mobile/util/mobile/selectview', 'mobile/util/mobile/pages', 'mobile/propsheet/PropertySheetManager', 'mobile/fieldeditors/fieldeditors.mobile', 'css!mobile/propsheet/propsheet'], function (baja, $, jqm, ordUtil, aop, views, pages, PropertySheetManager) {

  "use strict";

  var navMgr;

  /**
   * Arms event handlers on UI components, like the save/refresh/actions buttons
   * on the footer bar and the submit/cancel buttons on the action select/fire
   * divs.
   * 
   * @private
   * @memberOf niagara.propSheet.ui
   */
  function initializeUI() {
    navMgr = new PropertySheetManager();

    aop.after(navMgr, 'attachSubscriberEvents', function (args) {
      var sheet = args[0],
          sub = sheet.contentView.getSubscriber();

      sub.attach('renamed', function (prop, oldName, cx) {
        navMgr.getSelectedView().then(function (selectedView) {
          return navMgr.navbar.refresh(selectedView);
        });
      });
    });

    pages.register({
      pageshow: function pageshow() {
        $(document).on('onShowCommands', 'a.commandsButton', function () {
          navMgr.getSelectedView().then(function (selectedView) {
            if (selectedView) {
              views.getViewsCommand().setOrd(ordUtil.deriveOrd(selectedView.value()));
            }
          });
        });

        $.mobile.changePage(baja.Ord.make(niagara.view.ord).toUri(), {
          transition: "none",
          changeHash: false
        });
      }
    });

    navMgr.registerPages();
  }

  return initializeUI;
});
