/**
 * @file Niagara Mobile History
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Jason Spangler
 */

/*global niagara */

define(['baja!mobile:MobileHistoryAppTableView,' + 'mobile:HistoryServerSideHandler,history:HistoryRecord,' + 'history:NumericTrendRecord,history:BooleanTrendRecord,' + 'history:EnumTrendRecord,history:StringTrendRecord,' + 'history:AuditRecord,history:LogRecord', 'css!mobile/history/HistoryApp', 'css!mobile/history/css/HistoryTable', 'baja!', 'lex!mobile', 'jquery', 'bajaux/commands/Command', 'mobile/util/mobile/commands', 'mobile/util/mobile/dialogs', 'mobile/fieldeditors/fieldeditors.dialogs', 'mobile/util/mobile/mobile', 'mobile/util/mobile/touchscroll', 'mobile/history/table/DataTableView'], function (types, unusedCss1, unusedCss2, baja, lexs, $, Command, commands, dialogs, feDialogs, mobileUtil, touchScroll, DataTableView) {

  // Use ECMAScript 5 Strict Mode
  "use strict";

  //local vars

  var tableView,
      mobileLex = lexs[0],
      escapeHtml = mobileUtil.escapeHtml,
      currentParamString = niagara.view.history.query,


  //constants
  TIME_RANGE_BTN_DISPLAY_KEY = 'history.timeRange.select',
      TABLE_VIEW_ID = 'mobile:MobileHistoryAppTableView',
      HISTORY_SCHEME = 'history',
      PAGE_ID = '#historyTable',
      CONTENT_DIV_ID = '#historyTableContent',
      PAGE_TITLE_ID = '#historyTableTitle',
      DEFAULT_LIMIT = 20,
      colMenuHtml = '<div class="colMenu"><div data-role="fieldcontain"><fieldset data-role="controlgroup"></fieldset></div>',
      colMenuCheckboxHtml = '<input type="checkbox" name="checkbox-{i}" id="checkbox-{i}" data-theme="a" />' + '<label for="checkbox-{i}" >{display}</label>';

  /**
   * Default fail callback handler.
   *
   * @private
   */
  function defFail(err) {
    dialogs.unrecoverableError(err);
  }

  /**
   * This method forces a redirect of the current page to the chart view
   * of the current view ORD with the configured time query parameters (if any).
   * 
   */
  function redirect(paramString) {
    var query,
        queryList,
        historyOrd,
        ord = niagara.view.history.query;

    //parse the view ord from the view
    queryList = baja.Ord.make(ord).parse();
    queryList.getCursor().each(function (value) {
      if (value.getSchemeName() === HISTORY_SCHEME) {
        historyOrd = value.toString();
        //remove trailing parameters if present
        if (historyOrd.indexOf('?') > 0) {
          historyOrd = historyOrd.substring(0, historyOrd.indexOf('?'));
        }

        //add time query range if defined
        if (paramString) {
          historyOrd += paramString;
        }

        if (query !== undefined) {
          query += "|" + historyOrd;
        } else {
          query = historyOrd;
        }
      }
    });

    query = baja.Ord.make(query, {
      viewQuery: new baja.ViewQuery(TABLE_VIEW_ID)
    });
    tableView.load(query);
  }

  //Main


  function buildTimeQueryEditor() {
    var showDelta = tableView && tableView.$recordType && tableView.$recordType.is('baja:Number');

    //open a dialog with our editor
    return feDialogs.fieldEditor({
      title: mobileLex.get(TIME_RANGE_BTN_DISPLAY_KEY),
      value: currentParamString,
      showDelta: showDelta,
      key: 'historyQueryParams'
    }).then(function (paramString) {
      if (paramString !== null) {
        currentParamString = paramString;
        redirect(paramString);
      }
    });
  }

  /**
   * Binds the Show Columns menu to the given DOM anchor.
   * 
   * @memberOf niagara.mobile.table.DataTableView#
   * 
   * @param anchor - DOM anchor to bind our menu display to.
   */
  function bindShowColumnsMenu(anchor) {
    var colMenu = $(colMenuHtml),
        contents = colMenu.find('fieldset'),
        expandedClass = 'expanded',
        slideSpeed = 'medium';

    colMenu.appendTo($(anchor)).hide();

    anchor.click(function (e) {
      if ($(e.target).closest('.ui-checkbox').length) {
        return;
      }

      if (anchor.hasClass(expandedClass)) {
        colMenu.slideUp(slideSpeed, function () {
          anchor.removeClass(expandedClass);
        });
      } else {
        anchor.addClass(expandedClass);
        colMenu.slideDown(slideSpeed);
      }
      anchor.toggleClass('ui-icon-arrow-u ui-icon-check');
    });

    //append check boxes for each column to our column selector menu
    baja.iterate(tableView.columns, function (col) {

      //create a code-friendly version of the display name
      var id = escapeHtml(col.getDisplayName().replace(/\s/g, "-")),
          colMenuCheckBox = $(colMenuCheckboxHtml.patternReplace({
        i: id,
        display: escapeHtml(col.getDisplayName())
      }));

      //create the menu item checkbox with function and append
      colMenuCheckBox
      //include a click function for each checkbox item to show/hide
      //table columns
      .attr('checked', 'checked').appendTo(contents).click(function () {
        //if the checkbox is currently checked, our click event will
        //uncheck the checkbox, which means we really want to hide
        //the indicated table column. If our checkbox is not checked,
        //it means it is about to be checked, and we want to show
        //the selected column
        tableView.toggleColumnDisplay(id);
      });
    });
    colMenu.find('input').checkboxradio().addClass('ui-btn-icon-left');
  }

  /**
   * this method sets the title for this page.
   */
  function setPageTitle() {
    var pageTitle = niagara.view.history.displayName;
    document.title = pageTitle;
    $(PAGE_TITLE_ID).text(pageTitle);
  }

  /**
   * This method initializes our table content by creating a new menu and
   * creating the footer navigation bars along with loading the table data.
   */
  function initTable() {
    var ord = niagara.view.history.query,
        page = $(PAGE_ID),
        pageHeader = page.children(':jqmData(role=header)'),
        menuBtn = pageHeader.find('a.colMenuBtn'),
        footer = page.children(':jqmData(role=footer)'),
        contentDiv = $(CONTENT_DIV_ID);

    //create our table view content
    tableView = new DataTableView({
      limit: DEFAULT_LIMIT,
      ord: ord
    });

    tableView.onpageswap = function (contentDiv) {
      var tableContainer = contentDiv.find('.tableContainer');
      touchScroll(tableContainer, { horiz: true, showBlockade: true });
    };

    return tableView.initialize(contentDiv).then(function () {
      tableView.bindFooter(footer);
      return tableView.load(baja.Ord.make(ord));
    }).then(function () {
      //bind our page functionality
      bindShowColumnsMenu(menuBtn);
    });
  }

  /**
   * This method assumes the view is already initialized and simply loads the
   * data resolved from the current view ORD into the table model.
   */
  function loadTableData() {
    return tableView.load(baja.Ord.make(niagara.view.history.query));
  }

  /**
   * Initialize our view
   */
  function initAppView() {

    var page = $('#historyTable'),
        pageHeader = page.children(':jqmData(role=header)'),
        queryCmd = new Command(mobileLex.get(TIME_RANGE_BTN_DISPLAY_KEY), buildTimeQueryEditor);

    commands.prependDefaultCommand(queryCmd);

    $("#commandsButton").click(commands.showCommandsHandler);

    setPageTitle();

    //set our page header CSS
    pageHeader.css({
      '-webkit-transform': 'none',
      'overflow': 'visible'
    });

    if (tableView === undefined) {
      initTable().catch(defFail);
    } else {
      loadTableData().catch(defFail);
    }
  }

  return initAppView;
});
