var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'lex!mobile', 'jquery', 'Promise', 'mobile/util/slot', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, lexs, $, Promise, slotUtil, asyncUtils) {

  'use strict';

  var doRequire = asyncUtils.doRequire,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];


  var bajaTimeFormat = void 0,
      defaultDateboxTimeOptions = void 0;

  /**
   * @private
   * @exports mobile/fieldeditors/mobile/feUtils
   */
  var exports = {};

  /**
   * Keep the actual date object up to date when typing manually. Otherwise
   * if you bind 'modified.fieldeditor' to this editor, read() will return
   * out of date information.
   */
  exports.dateboxArmHandlers = function dateboxArmHandlers(element) {
    var timeInput = element.find('input:jqmData(role=datebox)');
    timeInput.on('keyup', function () {
      var $this = $(this),
          val = $this.val();
      $this.trigger('datebox', { method: 'set', value: val });
    });
  };

  /**
   * Get the pattern string to be used for formatting time values. The
   * returned string is a pattern in the baja TimeFormat style. It needs
   * to be converted before use with the datebox options, which uses a different
   * format.
   */
  exports.getBajaTimeFormat = function getBajaTimeFormat() {
    if (!bajaTimeFormat) {
      bajaTimeFormat = baja.getTimeFormatPattern() || 'HH:mm';

      // Filter out just the time related fields
      bajaTimeFormat = getTimePatternsFromBajaDateFormat(bajaTimeFormat);

      //
      // Due to the use of non-greedy quantifiers in a regex used by the
      // datebox js, we need to make sure there is whitespace between
      // the AM/PM indicator and any following fields.
      //
      if (bajaTimeFormat.match(/a\S+/g)) {
        bajaTimeFormat = bajaTimeFormat.replace('a', 'a ');
      }
    }
    return bajaTimeFormat;
  };

  exports.getDateboxDefaultOptions = function getDateboxDefaultOptions() {
    var options = {
      centerHoriz: true,
      centerVert: true,
      daysOfWeek: mobileLex.get({
        key: 'propsheet.datebox.daysOfWeek',
        def: 'Sunday Monday Tuesday Wednesday Thursday Friday Saturday'
      }).split(' '),
      daysOfWeekShort: mobileLex.get({
        key: 'propsheet.datebox.daysOfWeekShort',
        def: 'Su Mo Tu We Th Fr Sa'
      }).split(' '),
      monthsOfYear: mobileLex.get({
        key: 'propsheet.datebox.monthsOfYear',
        def: 'January February March April May June July August September October November December'
      }).split(' '),
      monthsOfYearShort: mobileLex.get({
        key: 'propsheet.datebox.monthsOfYearShort',
        def: 'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec'
      }).split(' '),
      setDateButtonLabel: mobileLex.get({
        key: 'propsheet.datebox.setDateButtonLabel',
        def: 'Set Date'
      })
    };

    // If we haven't already done so, create the default time related options from the
    // baja time format we should have obtained from the system channel.

    defaultDateboxTimeOptions = defaultDateboxTimeOptions || makeDateboxTimeOptionsFromBajaTimeFormat();

    options.overrideTimeOutput = defaultDateboxTimeOptions.timeOutput;
    options.overrideTimeFieldOrder = defaultDateboxTimeOptions.timeFieldOrder;
    options.overrideTimeFormat = defaultDateboxTimeOptions.timeFormat;

    return options;
  };

  exports.getEnumRangeDisplay = function getEnumRangeDisplay(ordinal, range) {
    return Promise.try(function () {
      var lexicon = range.getOptions().get('lexicon'),
          got = range.get(ordinal),
          tag = got.getTag();

      if (lexicon) {
        return doRequire(['lex!' + lexicon]).spread(function (lex) {
          return lex.get({ key: tag, def: tag });
        });
      } else {
        return baja.SlotPath.unescape(got.toString());
      }
    }).catch(function () {
      return String(ordinal);
    });
  };

  exports.getFacets = function getFacets(editor) {
    var facets = editor.facets,
        container = editor.container;

    if (facets && facets !== baja.Facets.NULL) {
      return facets;
    } else if (container) {
      return slotUtil.getFacets(container, editor.slot);
    } else {
      return baja.Facets.DEFAULT;
    }
  };

  exports.minMaxCheck = function minMaxCheck(ed, min, max, value) {
    return new Promise(function (resolve, reject) {
      var err;

      if (min !== undefined && min !== null && value < min || max !== undefined && max !== null && value > max) {

        err = "Cannot save property \"" + ed.slot + "\". ";
        if (value < min) {
          err += value + " < " + min;
        } else {
          err += value + " > " + max;
        }
        err += " [" + min + " - " + max + "]";
        reject(new Error(err));
      } else {
        resolve();
      }
    });
  };

  /**
   * Function to iterate the baja date format, extracting only the time
   * related patterns.
   */
  function getTimePatternsFromBajaDateFormat(bajaPattern) {
    var seps = '',
        pattern = '',
        fieldCount = 0,
        ch,
        i;

    // Go through the patterns in the string, if we find a time
    // pattern, add it to the output and start accumulating
    // characters between the time patterns.

    for (i = 0; i < bajaPattern.length; i++) {
      ch = bajaPattern.charAt(i);
      switch (ch) {
        case 'Y':
        case 'M':
        case 'D':
        case 'W':
        case 'w':
        case 'z':
        case 's':
          // Not a time of day related pattern we want, so ignore it and
          // throw away any separator characters we have accumulated.
          // Note that we are not including seconds in the supported
          // fields for the mobile editor.
          seps = '';
          break;
        case 'h':
        case 'H':
        case 'm':
        case 'a':
          // Add on any separator characters we have accumulated since
          // the last time format field. Follow this with the pattern char.
          if (seps.length) {
            pattern = pattern + seps;
            seps = '';
          }
          pattern = pattern + ch;
          fieldCount++;
          break;
        default:
          // Accumulate the separator character. If it is prior to the first field,
          // we shall ignore it (the same as the Java TimeFormat class does).
          if (fieldCount > 0) {
            seps = seps + ch;
          }
          break;
      }
    }

    return pattern;
  }

  /**
   * Create the default time-of-day related options for the datebox.
   * This will convert the baja style format string into the equivalent
   * in the POSIX format for the 'timeOutput' property, and infer the
   * 'timeOutput' and 'timeFieldOrder' properties as it does so.
   */
  function makeDateboxTimeOptionsFromBajaTimeFormat() {
    var i,
        j,
        ch,
        bajaPattern = exports.getBajaTimeFormat(),
        patterns = [],
        timeOutput = '',
        timeFieldOrder = [],
        timeFormat = 12;

    // Count the number of occurrences of the format characters

    for (i = 0; i < bajaPattern.length; i++) {
      ch = bajaPattern.charAt(i);
      if (patterns.length > 0 && patterns[patterns.length - 1].ch === ch) {
        patterns[patterns.length - 1].count++;
      } else {
        patterns.push({
          ch: ch,
          count: 1
        });
      }
    }

    // Build up the datebox property options from the format string. We can infer the
    // time field order and time format (12hr/24hr) from the patterns we find in the
    // output format string. We also convert to the POSIX format pattern style here.

    for (i = 0; i < patterns.length; i++) {

      switch (patterns[i].ch) {
        case 'Y':
          {
            timeOutput += patterns[i].count <= 2 ? '%y' : '%Y';
            break;
          }
        case 'M':
          {
            switch (patterns[i].count) {
              case 1:
                {
                  timeOutput += '%-m';
                  break;
                }
              case 2:
                {
                  timeOutput += '%m';
                  break;
                }
              case 3:
                {
                  timeOutput += '%b';
                  break;
                }
              case 4:
              /* fall through */
              default:
                {
                  timeOutput += '%B';
                  break;
                }
            }
            break;
          }
        case 'D':
          {
            timeOutput += patterns[i].count === 1 ? '%-d' : '%d';
            break;
          }
        case 'h':
          {
            timeOutput += patterns[i].count === 1 ? '%-l' : '%l';
            timeFieldOrder.push('h');
            timeFormat = 12;
            break;
          }
        case 'H':
          {
            timeOutput += patterns[i].count === 1 ? '%-k' : '%k';
            timeFieldOrder.push('h');
            timeFormat = 24;
            break;
          }
        case 'm':
          {
            timeOutput += patterns[i].count === 1 ? '%-M' : '%M';
            timeFieldOrder.push('i');
            break;
          }
        case 's':
          {
            timeOutput += 'ss';
            break;
          }
        case 'a':
          {
            timeOutput += '%p';
            timeFieldOrder.push('a');
            break;
          }
        case 'z':
        case 'Z':
          {
            break;
          }
        case 'W':
          {
            timeOutput += patterns[i].count === 1 ? '%a' : '%A';
            break;
          }
        case 'w':
          {
            timeOutput += '%W';
            break;
          }
        case '%':
          {
            for (j = 0; j < patterns[i].count; j++) {
              timeOutput += '%%';
            }
            break;
          }
        default:
          {
            for (j = 0; j < patterns[i].count; j++) {
              timeOutput += patterns[i].ch;
            }
            break;
          }
      }
    }

    return {
      timeOutput: timeOutput,
      timeFieldOrder: timeFieldOrder,
      timeFormat: timeFormat
    };
  }

  return exports;
});
