var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/OrdComponentSelector
 */
define(['baja!', 'lex!mobile', 'jquery', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/util/ord'], function (baja, lexs, $, MobileFieldEditor, ordUtil) {

  'use strict';

  var equivalent = ordUtil.equivalent,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/OrdComponentSelector
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */
  var OrdComponentSelector = function OrdComponentSelector() {
    MobileFieldEditor.apply(this, arguments);
  };
  OrdComponentSelector.prototype = Object.create(MobileFieldEditor.prototype);
  OrdComponentSelector.prototype.constructor = OrdComponentSelector;

  /**
   * Builds an empty select dropdown (to be populated in `doLoad`)
   */
  OrdComponentSelector.prototype.doInitialize = function (dom) {
    //initial html: empty. building up of dropdown will occur in load
    var select = $('<select data-role="selectmenu" data-theme="a" />')
    //                     .attr('id', this.name)
    .attr('name', this.name).appendTo(dom);

    select.append($('<option/>').text(mobileLex.get('loading')));
  };

  /**
   * Populates a select dropdown with the results of a BQL query.
   *
   * @param {baja.Ord} value the ORD with which we want to retrieve a list of
   * available components - this ORD should be in the form of a BQL query and
   * return at least the fields `slotPathOrd` and `displayName`.
   *
   * Example: `station:|slot:/|bql: select displayName, slotPathOrd from schedule:CalendarSchedule`
   */
  OrdComponentSelector.prototype.doLoad = function (value) {
    var editorDiv = this.jq(),
        select = editorDiv.find('select');

    select.html($('<option/>').text(mobileLex.get('loading')));

    try {
      validateSelector(value);
    } catch (e) {
      editorDiv.text(e);
    }

    return baja.Ord.make(String(value)).get({
      cursor: {
        before: function before() {
          select.empty();
        },
        each: function each() {
          var slotPathOrd = this.get('slotPathOrd'),
              displayName = this.get('displayName'),
              option = $('<option/>').val(slotPathOrd).text(displayName);

          if (equivalent(value, slotPathOrd)) {
            option.attr('selected', 'selected');
          }
          option.appendTo(select);
        },
        after: function after() {
          select.selectmenu('refresh');
        },
        limit: 100
      }
    });
  };

  OrdComponentSelector.prototype.doRead = function () {
    return baja.Ord.make(this.jq().find('select').val());
  };

  function validateSelector(selector) {
    selector = String(selector);

    if (selector.indexOf('slotPathOrd') < 0 || selector.indexOf('displayName') < 0) {
      throw "Must select slotPathOrd and displayName";
    }
  }

  return OrdComponentSelector;
});
