/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/DynamicEnumEditor
 */
define(['baja!', 'mobile/fieldeditors/mobile/EnumEditor'], function (baja, EnumEditor) {

  'use strict';

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/DynamicEnumEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */

  var DynamicEnumEditor = function DynamicEnumEditor() {
    EnumEditor.apply(this, arguments);
  };
  DynamicEnumEditor.prototype = Object.create(EnumEditor.prototype);
  DynamicEnumEditor.prototype.constructor = DynamicEnumEditor;

  DynamicEnumEditor.prototype.doRead = function () {
    var select = this.jq().find('select'),
        range = this.range; //set in load

    return baja.DynamicEnum.make({
      ordinal: Number(select.val()),
      range: range
    });
  };

  return DynamicEnumEditor;
});
