/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'jquery', 'underscore', 'mobile/fieldeditors/mobile/RelTimeEditor', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, $, _, RelTimeEditor, asyncUtils) {

  'use strict';

  var doRequire = asyncUtils.doRequire,
      durationOptions = [["override.perm", 0], ["override.min1", 60000], ["override.min15", 15 * 60000], ["override.min30", 30 * 60000], ["override.hour1", 60 * 60000], ["override.hour2", 120 * 60000], ["override.hour3", 180 * 60000], ["override.custom", -1]];


  var DurationSelectRelTimeEditor = function DurationSelectRelTimeEditor() {
    RelTimeEditor.apply(this, arguments);
  };
  DurationSelectRelTimeEditor.prototype = Object.create(RelTimeEditor.prototype);
  DurationSelectRelTimeEditor.prototype.constructor = DurationSelectRelTimeEditor;

  /**
   * Creates a select dropdown with predetermined choices for selecting
   * an override duration (permanent, 1 minute, 15 minutes, etc.)
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  DurationSelectRelTimeEditor.prototype.doInitialize = function (dom) {
    var select = $('<select class="durationChoice" data-theme="a" />'),
        that = this;

    return doRequire('lex!control').spread(function (controlLex) {
      var max = that.facets.get('max');

      // for a RelTime, only support "max" facets of type RelTime,
      // c.f. WritableSupport#getMaxOverrideDuration()
      if (max !== null && !max.getType().is('baja:RelTime')) {
        max = null;
      }

      function addOption(name, millis) {
        var option = $('<option value="' + millis + '"/>');
        option.text(controlLex.get(name));
        option.appendTo(select);
      }

      _.each(durationOptions, function (opt) {
        var name = opt[0],
            millis = opt[1];

        // add to dropdown if there is no max set, if it's a custom duration,
        // or the duration is less than the max
        if (max === null || millis === -1 || millis > 0 && millis <= max.getMillis()) {
          addOption(name, millis);
        }
      });

      dom.append(select);
    });
  };

  /**
   * Sets the value of the duration select dropdown depending on the value
   * in millis of the input RelTime.
   */
  DurationSelectRelTimeEditor.prototype.doLoad = function (value) {
    var millis = value ? value.getMillis() : '-1',
        select = this.jq().find('select'),
        option = select.find('option[value="' + millis + '"]');
    if (option.length) {
      select.val(String(millis));
    } else {
      select.val('-1');
    }
    select.trigger('change');
    select.selectmenu('refresh');
  };

  /**
   * Gets a RelTime depending on the currently selected duration. If
   * Custom is selected, returns -1 (since we have no RelTime.NULL).
   */
  DurationSelectRelTimeEditor.prototype.doRead = function () {
    var select = this.jq().find('select'),
        val = Number(select.val());
    return val === -1 ? -1 : baja.RelTime.make(Number(val));
  };

  return DurationSelectRelTimeEditor;
});
