/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/util/modelUtil
 */
define(['baja!', 'baja!control:ControlPoint', 'nmodule/ndriver/rc/util/columnUtil', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/ndriver/rc/column/OutMgrColumn', 'nmodule/ndriver/rc/column/NTypeMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn'], function (baja, types, columnUtil, Column, OutMgrColumn, NTypeMgrColumn, IconMgrColumn, PathMgrColumn, NameMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, DeviceExtsMgrColumn) {
  'use strict';

  // flag descriptions taken from javax.baja.workbench.mgr.MgrColumn
  var UNSEEN = Column.flags.UNSEEN,
    // The unseen flag is used on columns which are not shown
    //   by default until the user turns them on via table options
    EDITABLE = Column.flags.EDITABLE,
    // Editable indicates a column which is included for edits
    //   via the MgrEdit APIs.
    READONLY = Column.flags.READONLY; // The Readonly flag is used on editable columns which are displayed
  //   via the MgrEdit dialog, but not user modifiable

  /**
   * A utility class for dealing with ndriver manager models
   *
   * API Status: **Private**
   * @exports nmodule/ndriver/rc/util/modelUtil
   */
  var exports = {};

  /**
   * Create the appropriate columns for this manager/component
   *
   * @param {module:nmodule/ndriver/rc/Automanager} manager
   * @param {baja.Component} component
   * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>}
   * @throws {Error}
   */
  exports.makeColumns = function (manager, component) {
    var componentInstance,
      columns = [
      // Icon, Path, Name & Type always apply
      new IconMgrColumn(), new PathMgrColumn({
        flags: UNSEEN
      }), new NameMgrColumn({
        flags: EDITABLE
      }), new NTypeMgrColumn({
        flags: EDITABLE
      })];

    // For device managers, BNNetwork or BNDeviceFolder
    if (baja.hasType(component, 'driver:IDeviceFolder')) {
      if (!manager.getDeviceTypeSpec()) {
        throw new Error('Manager has no DeviceTypeSpec value');
      }
      columns.push(new DeviceExtsMgrColumn('exts', {
        component: baja.$(manager.getDeviceTypeSpec())
      }));

      // use component's getDeviceType in getColumnsFor
      componentInstance = baja.$(manager.getDeviceTypeSpec());

      // for Point Managers, BNPointFolder or BPointDeviceExt
    } else if (baja.hasType(component, 'driver:IPointFolder')) {
      if (!manager.getProxyExtTypeSpec()) {
        throw new Error('Manager has no ProxyExtTypeSpec value');
      }
      columns.push(new OutMgrColumn({
        moduleName: component.getType().getModuleName(),
        flags: READONLY
      }), new PropertyMgrColumn('facets', {
        type: baja.lt('control:ControlPoint'),
        flags: UNSEEN | EDITABLE
      }));
      componentInstance = baja.$(manager.getProxyExtTypeSpec());
    } else {
      throw new Error('unsupported component: ' + component.getType());
    }
    columns = columnUtil.getColumnsFor(componentInstance, columns);
    return columns;
  };
  return exports;
});
