function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/software/InstallSoftwareWidget
 */

define(['baja!', 'bajaux/spandrel', 'lex!provisioningNiagara', 'Promise', 'nmodule/provisioningNiagara/rc/baja/software/InstallableSpecNode', 'nmodule/provisioningNiagara/rc/baja/software/InstallableSummaryNode', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/tree/TreeTable', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel'], function (baja, spandrel, lexs, Promise, InstallableSpecNode, InstallableSummaryNode, Column, IconColumn, Table, TreeTable, TreeTableModel) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-InstallSoftwareWidget'
      }
    };
  };

  /**
   * @class
   * @inner
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   */
  var InstallableSummaryColumn = /*#__PURE__*/function (_Column) {
    function InstallableSummaryColumn() {
      _classCallCheck(this, InstallableSummaryColumn);
      return _callSuper(this, InstallableSummaryColumn, arguments);
    }
    _inherits(InstallableSummaryColumn, _Column);
    return _createClass(InstallableSummaryColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        return row.getTreeNode().toDisplay().then(function (display) {
          return dom.text(display);
        });
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject();
      }
    }]);
  }(Column);
  /**
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/software/InstallSoftwareWidget
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function InstallSoftwareWidget(params) {
      _classCallCheck(this, InstallSoftwareWidget);
      return _callSuper(this, InstallSoftwareWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * 
     * @returns <Array.<baja.Struct>> of type provisioningNiagara:InstallableSpec
     */
    _inherits(InstallSoftwareWidget, _spandrel);
    return _createClass(InstallSoftwareWidget, [{
      key: "doRead",
      value: function doRead() {
        return this.$getTable().getSelectedRows().filter(function (row) {
          // Only filter InstallableSpecNodes
          return row.getTreeNode() instanceof InstallableSpecNode;
        }).map(function (row) {
          return row.getTreeNode().getSpec();
        });
      }

      /**
       * @private
       * @param {baja.Component} softwareContainer
       * @return {Promise.<Array.<baja.Component>>} array of componentnts of type provisioningNiagara:InstallableSummary
       */
    }, {
      key: "$getInstallables",
      value: function $getInstallables(softwareContainer) {
        // This is a promise right now to future proof integrating a different software source
        return Promise.resolve(softwareContainer.getSlots().properties().is('provisioningNiagara:InstallableSummary').toValueArray());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} 
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('container/table');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} 
       */
    }, {
      key: "$getFilterWidget",
      value: function $getFilterWidget() {
        return this.queryWidget('container/filter/1');
      }

      /**
       * @private
       * @param {String} filterText
       * @returns {Promise}
       */
    }, {
      key: "$applyFilter",
      value: function $applyFilter(filterText) {
        var model = this.$getTable().getModel();
        var containsTextInSummary = function containsTextInSummary(row, filterText) {
          // Only apply the filter text to summary nodes 
          if (row.getTreeNode() instanceof InstallableSpecNode) {
            return true;
          }
          return baja.SlotPath.unescape(String(row.getTreeNode().getName())).indexOf(filterText) !== -1;
        };
        // At this point the toDisplay promise of the tree nodes should be fulfilled. Currently the row filter function 
        // is expected to be synchromous hence the reason to use the unescaped getName for filtering.
        var filterFunc = function filterFunc(row) {
          return containsTextInSummary(row, filterText);
        };
        return model.setRowFilter(filterFunc);
      }
    }]);
  }(spandrel(function (softwareContainer, _ref) {
    var self = _ref.self;
    return self.$getInstallables(softwareContainer).then(function (installableSummaries) {
      return Promise.all(installableSummaries.map(function (summary) {
        return new InstallableSummaryNode(summary);
      }));
    }).then(function (summaryNodes) {
      return spandrel.jsx("div", {
        spandrelKey: "container",
        className: "-t-InstallSoftwareWidget-container"
      }, spandrel.jsx("label", null, provisioningNiagaraLex.get('InstallSoftwareFactory.filterMessage')), spandrel.jsx("div", {
        className: "-t-InstallSoftwareWidget-filter",
        spandrelKey: "filter"
      }, spandrel.jsx("any", {
        value: baja.Icon.make(['module://icons/x16/filter.png'])
      }), spandrel.jsx("input", {
        type: "text",
        placeholder: provisioningNiagaraLex.get('InstallSoftwareFactory.filter'),
        onKeyup: function onKeyup(event) {
          return self.$applyFilter(event.target.value);
        }
      })), spandrel.jsx(TreeTable, {
        spandrelKey: "table",
        value: new TreeTableModel({
          rows: summaryNodes,
          columns: [new IconColumn(), new InstallableSummaryColumn('summary', {
            displayName: ' '
          })]
        }),
        on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (event, table) {
          return self.setModified(true);
        })
      }));
    });
  }, {
    strategy: 'niagara'
  }));
});
