function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SetSystemPassphraseStepFactory
 */

define(['baja!', 'lex!provisioningNiagara', 'jquery', 'Promise', 'nmodule/webEditors/rc/baja/PasswordStrength', 'nmodule/webEditors/rc/servlets/password', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/provisioningNiagara/rc/baja/SystemPassphraseEditor', 'css!nmodule/provisioningNiagara/rc/provisioningNiagara'], function (baja, lexs, $, Promise, PasswordStrength, password, UxJobStepFactory, feDialogs, SystemPassphraseEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];

  /**
   * A 'provisioningNiagara:SetSystemPassphraseStepFactory' factory implementation.
   *
   * @since Niagara 4.14
   * @class
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   * @alias module:nmodule/provisioningNiagara/rc/baja/SetSystemPassphraseStepFactory
   */
  var SetSystemPassphraseStepFactory = /*#__PURE__*/function (_UxJobStepFactory) {
    function SetSystemPassphraseStepFactory() {
      _classCallCheck(this, SetSystemPassphraseStepFactory);
      return _callSuper(this, SetSystemPassphraseStepFactory, [{
        module: 'provisioningNiagara',
        lex: 'SetSystemPassphraseStepFactory'
      }]);
    }

    /**
     * Resolves to 'provisioningNiagara:SetSystemPassphraseStepFactory'.
     *
     * @returns {Promise.<baja.Component>} resolves to a provisioningNiagara:SetSystemPassphraseJobStep.
     */
    _inherits(SetSystemPassphraseStepFactory, _UxJobStepFactory);
    return _createClass(SetSystemPassphraseStepFactory, [{
      key: "makeStep",
      value: function makeStep() {
        return this.editStep({
          step: null
        });
      }

      /**
       * @param {baja.Component} step
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(_ref) {
        var step = _ref.step;
        return this.$promptUserToSetSystemPassphrase(step).then(function (step) {
          if (step) {
            step.setFactoryType(baja.$('baja:TypeSpec', 'provisioningNiagara:SetSystemPassphraseStepFactory'));
          }
          return step;
        });
      }

      /**
       * @private
       * @param {baja.Component} step
       * @returns {Promise<baja.Component>}
       */
    }, {
      key: "$promptUserToSetSystemPassphrase",
      value: function $promptUserToSetSystemPassphrase(step) {
        return this.$getPasswordStrengthForFipsAndNonFips().then(function (_ref2) {
          var fipsPasswordStrength = _ref2.fipsPasswordStrength,
            nonFipsPasswordStrength = _ref2.nonFipsPasswordStrength;
          step = step || baja.$('provisioningNiagara:SetSystemPassphraseJobStep');
          return feDialogs.showFor({
            title: provisioningNiagaraLex.get('SetSystemPassphraseStepDialog.title'),
            summary: provisioningNiagaraLex.get('SetSystemPassphraseStepDialog.topText'),
            dom: $('<div class="-t-SetSystemPassphraseFactory-SetSystemPassphraseEditorDialog"/>'),
            type: SystemPassphraseEditor,
            value: step,
            properties: {
              fipsPasswordStrength: fipsPasswordStrength,
              nonFipsPasswordStrength: nonFipsPasswordStrength
            }
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<{fipsPasswordStrength: baja.Component, nonFipsPasswordStrength: baja.Component}>}
       */
    }, {
      key: "$getPasswordStrengthForFipsAndNonFips",
      value: function $getPasswordStrengthForFipsAndNonFips() {
        var _this = this;
        return Promise.all([this.$getPasswordStrengthFromRpc(true), this.$getPasswordStrengthFromRpc(false)]).then(function (passwordStrengths) {
          var _passwordStrengths = _slicedToArray(passwordStrengths, 2),
            encodedFipsPasswordStrength = _passwordStrengths[0],
            encodedNonFipsPasswordStrength = _passwordStrengths[1];
          return Promise.all([_this.$decodePasswordStrength(encodedFipsPasswordStrength), _this.$decodePasswordStrength(encodedNonFipsPasswordStrength)]).then(function (passwordStrengths) {
            var _passwordStrengths2 = _slicedToArray(passwordStrengths, 2),
              fipsPasswordStrength = _passwordStrengths2[0],
              nonFipsPasswordStrength = _passwordStrengths2[1];
            return {
              fipsPasswordStrength: fipsPasswordStrength,
              nonFipsPasswordStrength: nonFipsPasswordStrength
            };
          });
        });
      }

      /**
       * @private
       * @param {boolean} isFips
       * @returns {Promise<baja.Struct>}
       */
    }, {
      key: "$getPasswordStrengthFromRpc",
      value: function $getPasswordStrengthFromRpc(isFips) {
        return password.getPasswordStrength(isFips);
      }

      /**
       * @private
       * @param {string} encodedPasswordStrength
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$decodePasswordStrength",
      value: function $decodePasswordStrength(encodedPasswordStrength) {
        return this.$decodeAsyncPasswordStrength(encodedPasswordStrength).then(function (passwordStrength) {
          if (passwordStrength instanceof PasswordStrength) {
            return passwordStrength;
          }
          return baja.$('baja:PasswordStrength');
        });
      }

      /**
       * @private
       * @param {string} encodedPasswordStrength
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$decodeAsyncPasswordStrength",
      value: function $decodeAsyncPasswordStrength(encodedPasswordStrength) {
        return baja.bson.decodeAsync(JSON.parse(encodedPasswordStrength));
      }
    }]);
  }(UxJobStepFactory);
  return SetSystemPassphraseStepFactory;
});
