function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SecurityGroupStepFactory
 */

define(['baja!', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/servlets/registry'], function (baja, Promise, asyncUtils, UxJobStepFactory, registry) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  var getTypes = registry.getTypes,
    getTypeInfo = registry.getTypeInfo,
    getAgentOnInfo = registry.getAgentOnInfo;

  /**
   * A Step factory that calls each of the security steps in turn to add to the job list
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/SecurityGroupStepFactory
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   */
  var SecurityGroupStepFactory = /*#__PURE__*/function (_UxJobStepFactory) {
    function SecurityGroupStepFactory() {
      _classCallCheck(this, SecurityGroupStepFactory);
      return _callSuper(this, SecurityGroupStepFactory, [{
        module: 'provisioningNiagara',
        lex: 'SecurityGroupStepFactory'
      }]);
    }

    /**
     * Calls $makeStep which resolves to an array of steps to be added to the job
     * list
     * @param {Object} params
     * @returns {Promise<Array<baja.Component>|undefined>}
     */
    _inherits(SecurityGroupStepFactory, _UxJobStepFactory);
    return _createClass(SecurityGroupStepFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        return this.$makeStep(params);
      }

      /**
       * Calls each of the security job factories in order and resolves to an array of steps to
       * be added to the job list
       * @private
       * @param params
       * @returns {Promise<Array<baja.Component>|undefined>}
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(params) {
        var _this = this;
        var steps = [];
        var cont = true;
        return this.$getFactories().then(function (factories) {
          return factories.reduce(function (prom, factory) {
            return prom.then(function () {
              return Promise.resolve(cont && _this.$callFactoryMakeStep(factory, params)).then(function (step) {
                if (!step) {
                  cont = false;
                } else {
                  steps.push(step);
                }
              });
            });
          }, Promise.resolve([]));
        }).then(function () {
          if (cont) {
            return steps;
          }
        });
      }

      /**
       * Returns the factories for the Security Group steps
       * @Private
       * @returns {Promise<Array<batchJob:IUxJobStepFactory>>}
       */
    }, {
      key: "$getFactories",
      value: function $getFactories() {
        return getTypes({
          targetType: 'provisioningNiagara:ISecurityJobStepFactory',
          showAbstract: false,
          showInterface: false
        }).then(function (jobSteps) {
          return getTypeInfo(jobSteps.map(function (jobStep) {
            return jobStep.type;
          }));
        }).then(function (jobStepTypeInfos) {
          return Promise.all(jobStepTypeInfos.map(function (jobStepTypeinfo) {
            return getAgentOnInfo(jobStepTypeinfo.type, {
              is: 'batchJob:IUxJobStepFactory'
            }).then(function (agents) {
              if (agents.length > 0) {
                var agent = agents[0];
                return doRequire(agent.js.id, agent.js.deps);
              }
            }).then(function (Factory) {
              return Factory && new Factory();
            });
          })).then(function (factories) {
            return factories.filter(function (factory) {
              return factory && factory.$isValidFor();
            });
          });
        });
      }

      /**
       * Calls the factory makeStep function
       * @private
       * @param factory
       * @param params
       * @returns {*}
       */
    }, {
      key: "$callFactoryMakeStep",
      value: function $callFactoryMakeStep(factory, params) {
        return factory.makeStep(params);
      }
    }]);
  }(UxJobStepFactory);
  return SecurityGroupStepFactory;
});
