function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/WebWidget
 */
define(['baja!', 'log!nmodule.bajaui.rc.ux.WebWidget', 'bajaux/events', 'bajaux/spandrel', 'bajaux/container/util', 'bajaux/util/CommandButtonGroup', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/bajaui/rc/baja/binding/LoadBinding', 'nmodule/bajaui/rc/mixin/PreferredSizeSupport', 'nmodule/bajaui/rc/model/UxModelSupport', 'nmodule/gx/rc/baja/Size', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'css!nmodule/bajaui/rc/bajaui'], function (baja, log, events, spandrel, util, CommandButtonGroup, Promise, _, switchboard, LoadBinding, PreferredSizeSupport, UxModelSupport, Size, ICollectionSupport) {
  'use strict';

  var applyWebPropertyToWidget = util.applyWebPropertyToWidget;
  var isFunction = _.isFunction;
  var logWarning = log.warning.bind(log);
  var logSevere = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-WebWidget bajaux-container ux-fg ux-root',
        js: baja.Ord.DEFAULT,
        preferredSize: Size.make(640, 480)
      }
    };
  };

  /**
   * bajaux implementation of `WebWidget`.
   * @class
   * @alias module:nmodule/bajaui/rc/ux/WebWidget
   * @extends module:bajaux/Widget
   * @mixes module:nmodule/bajaui/rc/mixin/PreferredSizeSupport
   */
  return /*#__PURE__*/function (_spandrel) {
    function WebWidget(params) {
      var _this;
      _classCallCheck(this, WebWidget);
      _this = _callSuper(this, WebWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      UxModelSupport(_this);
      PreferredSizeSupport(_this);
      switchboard(_this, {
        $resolveAndLoad: {
          allow: 'oneAtATime'
        }
      });
      return _this;
    }

    /**
     * @override
     * @returns {module:nmodule/bajaui/rc/mixin/PreferredSizeSupport~Size|undefined}
     */
    _inherits(WebWidget, _spandrel);
    return _createClass(WebWidget, [{
      key: "getPreferredSize",
      value: function getPreferredSize() {
        var size = this.properties().getValue('preferredSize');
        if (!size || size === Size.NULL) {
          return;
        }
        var width = size.getWidth();
        var height = size.getHeight();
        return {
          width: width,
          height: height,
          minWidth: width,
          minHeight: height,
          maxWidth: width,
          maxHeight: height
        };
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var contentWidget = this.$getContentWidget();
        return contentWidget.save();
      }

      /**
       * Apply the configured `preferredSize` property if the WebWidget is
       * statically sized.
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.applySize(this.jq()[0]);
      }

      /**
       * @returns {boolean} true iff the content widget is modified
       */
    }, {
      key: "isModified",
      value: function isModified() {
        var contentWidget = this.$getContentWidget();
        return !!(contentWidget && contentWidget.isModified());
      }

      /**
       * @private
       * @returns {Promise.<string>} the type of the web widget to load
       */
    }, {
      key: "$getWebWidgetType",
      value: function $getWebWidgetType() {
        var js = this.properties().getValue('js');
        var queryList = js.parse();
        var viewQuery = queryList.get('view');
        if (viewQuery) {
          return Promise.resolve(viewQuery.getBody());
        }
        var fileQuery = queryList.get('file');
        if (fileQuery) {
          return js.get().then(function (file) {
            return file.getReadUri();
          });
        }
        return Promise.reject(new Error('invalid js ord: ' + js));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getContentWidget",
      value: function $getContentWidget() {
        return this.queryWidget('container/content');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getToolbar",
      value: function $getToolbar() {
        return this.queryWidget('toolbar');
      }

      /**
       * Return true if the `contentWidget` has `ICollectionSupport` turned on.
       * @see module:nmodule/webEditors/rc/wb/util/ICollectionSupport#isOn
       * @private
       * @return {boolean}
       */
    }, {
      key: "$hasICollectionSupport",
      value: function $hasICollectionSupport() {
        var contentWidget = this.$getContentWidget();
        return contentWidget && ICollectionSupport.isOn(contentWidget);
      }

      /**
       * This will complete a resolve and load after the primary load has completed.
       * @private
       *
       * @param {module:baja/ord/OrdTarget} ordTarget
       * @returns {Promise}
       */
    }, {
      key: "$extraLoad",
      value: function $extraLoad(ordTarget) {
        var _this2 = this;
        // eslint-disable-next-line promise/avoid-new
        return new Promise(function (resolve, reject) {
          var contentWidget = _this2.$getContentWidget();
          var jq = _this2.jq();
          if (!contentWidget || contentWidget.value() === null) {
            jq.one(events.LOAD_EVENT, ".-t-WebWidget-inner", function () {
              resolve(_this2.$resolveAndLoad(ordTarget));
            });
            jq.one(events.LOAD_FAIL_EVENT, ".-t-WebWidget-inner", function (error) {
              reject(error);
            });
          } else {
            resolve(_this2.$resolveAndLoad(ordTarget));
          }
        });
      }

      /**
       * This will resolve and load the content widget when no other calls to `$resolveAndLoad` are happening.
       * @private
       *
       * @param {module:baja/ord/OrdTarget} ordTarget
       * @returns {Promise}
       */
    }, {
      key: "$resolveAndLoad",
      value: function $resolveAndLoad(ordTarget) {
        var contentWidget = this.$getContentWidget();

        //inner widget is in the process of reloading, so wait for it
        if (!contentWidget) {
          this.$extraLoad(ordTarget)["catch"](logSevere);
          return Promise.resolve();
        }
        var resolveParams = {
          existingOrdTarget: ordTarget
        };
        return contentWidget.resolve(ordTarget.getOrd(), resolveParams).then(function (value) {
          return contentWidget.load(value);
        });
      }
    }]);
  }(spandrel(function (model, _ref) {
    var _this3 = this;
    var self = _ref.self,
      properties = _ref.properties,
      rootElement = _ref.rootElement;
    var value = model.getValue();
    var bindingList = model.getBindingList();
    var hideCommandBar = properties.hideCommandBar;
    var widgetDom = document.createElement('div');
    widgetDom.classList.add('-t-WebWidget-inner');
    widgetDom.classList.add('bajaux-widget');
    var containerDom = document.createElement('div');
    containerDom.classList.add('bajaux-widget-container');
    containerDom.classList.add('ux-fullscreen-support');
    this.applySize(containerDom, rootElement);
    var heritableProperties = self.properties().get().filter(function (_ref2) {
      var name = _ref2.name;
      return name !== 'js' && name !== 'preferredSize';
    });
    return this.$getWebWidgetType().then(function (widgetType) {
      return {
        toolbar: {
          dom: '<div class="bajaux-toolbar-outer"/>',
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          }
        },
        container: {
          dom: containerDom,
          kids: {
            content: {
              dom: widgetDom,
              formFactors: ['max', 'compact', 'mini'],
              type: widgetType,
              properties: {
                $quiet: false
              },
              value: value,
              hooks: {
                instantiated: function instantiated(widget) {
                  return Promise.all(heritableProperties.map(function (prop) {
                    return applyWebPropertyToWidget(prop, widget);
                  }));
                },
                preLoad: function preLoad(widget, buildContext) {
                  return resolveBindings(widget, bindingList, buildContext);
                },
                postLoad: function postLoad(widget) {
                  if (hideCommandBar) {
                    return;
                  }
                  var toolBar = _this3.$getToolbar();
                  return toolBar && toolBar.load(widget.getCommandGroup());
                }
              },
              //prevent key events if the widget is disabled.
              //mouse events prevented via pointer-events: none.
              on: ['keydown', function () {
                return _this3.isEnabled();
              }]
            }
          }
        }
      };
    });
  }, {
    strategy: 'niagara'
  }));

  /**
   * Resolve all non-secondary Bindings against the Widget and ensure the Widget's
   * desired value is loaded.
   *
   * @param {module:bajaux/Widget} widget
   * @param {module:nmodule/bajaui/rc/model/BindingList} bindingList
   * @param {module:bajaux/lifecycle/WidgetManager~BuildContext} buildContext
   * @return {Promise}
   */
  function resolveBindings(widget, bindingList, buildContext) {
    return bindingList.map(function (binding) {
      if (!(binding instanceof LoadBinding)) {
        return;
      }
      if (isFunction(binding.$isPrimaryBinding)) {
        if (!binding.$isPrimaryBinding()) {
          return;
        }
      }
      var ordTarget = binding.getOrdTarget();
      if (!ordTarget) {
        return;
      }
      return Promise["try"](function () {
        return widget.resolve(ordTarget.getOrd(), {
          existingOrdTarget: ordTarget
        }).then(function (value) {
          //If the widget changes the value to load (Like a WebHistoryTable on a HistoryExt),
          //this modification ensures that the widget's desired value is loaded.
          buildContext.value = value;
        });
      })["catch"](logWarning);
    });
  }
});
