function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['baja!', 'baja!bajaui:Layout', 'lex!bajaui', 'log!nmodule.bajaui.rc.rpc.uxBuilder', 'jquery', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/model/UxModel', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry'], function (baja, types, lexs, log, $, Promise, _, Binding, UxModel, NullWidget, asyncUtils, StationRegistry) {
  'use strict';

  var compact = _.compact,
    constant = _.constant,
    difference = _.difference,
    flatten = _.flatten,
    memoize = _.memoize,
    uniq = _.uniq;
  var _lexs = _slicedToArray(lexs, 1),
    bajauiLex = _lexs[0];
  var logInfo = log.info.bind(log);
  var doRequire = asyncUtils.doRequire;
  var KIDS = 'k';
  var NAME = 'n';
  var ORD = 'o';
  var PROPERTIES = 'p';
  var TARGETS = 'ta';
  var TYPE_SPEC = 't';
  var VALUE = 'v';
  var retrieveFromServlet = memoize(function (ord) {
    return $.get('/uxBuilder/ux/data/' + baja.SlotPath.escape(String(ord)))["catch"](function (err) {
      var msg = err.responseText || bajauiLex.get('uxBuilderServlet.couldNotRetrievePxData');
      throw new Error(msg);
    });
  });

  /**
   * API Status: **Private**
   * @exports nmodule/bajaui/rc/rpc/uxBuilder
   */
  var exports = {};
  var lastWbContainerInitialize;

  /**
   * @param {string|baja.Ord} ord
   * @returns {Promise.<module:nmodule/bajaui/rc/model/UxModel>}
   */
  exports.fromPxOrd = function (ord) {
    return log.timing(function () {
      //clear cache if a WebWidget has been reused incase a px page has been changed
      if (window.$wbContainerInitialize && lastWbContainerInitialize !== window.$wbContainerInitialize) {
        lastWbContainerInitialize = window.$wbContainerInitialize;
        retrieveFromServlet.cache = {};
      }
      return retrieveFromServlet(ord);
    }, 'FINE', 'Retrieved UxBuilderServlet data from {} in {}ms', ord).then(function (json) {
      return log.timing(function () {
        return exports.$pxJsonToUxModel(json);
      }, 'FINE', 'Converted UxBuilderServlet data from {} to UxModel in {}ms', ord);
    });
  };

  /**
   * @private
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxDocumentEncoding} json
   * @returns {Promise.<module:nmodule/bajaui/rc/model/UxModel>}
   */
  exports.$pxJsonToUxModel = function (_ref) {
    var props = _ref.props,
      content = _ref.content,
      _ref$typeMap = _ref.typeMap,
      typeMap = _ref$typeMap === void 0 ? {} : _ref$typeMap;
    var types = scanForTypes(content);
    if (props) {
      types = types.concat(props.map(scanForTypes));
    }
    types = difference(uniq(types), getWidgetTypeSpecs(typeMap));
    //types = uniq(types);

    return baja.importTypes(types).then(function () {
      return Promise.all([toUxModel(content, typeMap), props && decodePxProperties(props)]);
    }).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        modelData = _ref3[0],
        decodedProps = _ref3[1];
      // TODO: use symbol to avoid theoretical "pxProperties" conflict
      if (props) {
        modelData.properties.pxProperties = decodedProps;
      }
      return UxModel.make(modelData);
    });
  };

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} widgetNode
   * @param {object} typeMap
   * @returns {Promise.<object>} resolves to a config object used to construct
   * a `UxModel`
   */
  function toUxModel(widgetNode, typeMap) {
    var name = widgetNode[NAME],
      _widgetNode$KIDS = widgetNode[KIDS],
      kids = _widgetNode$KIDS === void 0 ? [] : _widgetNode$KIDS,
      _widgetNode$PROPERTIE = widgetNode[PROPERTIES],
      properties = _widgetNode$PROPERTIE === void 0 ? [] : _widgetNode$PROPERTIE,
      typeSpec = widgetNode[TYPE_SPEC];
    return Promise.all([resolveJsWidget(typeSpec, typeMap), decodeWidgetProperties(properties.concat(kids.filter(isSimple))), decodeKids(kids, typeMap)]).then(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 3),
        type = _ref5[0],
        properties = _ref5[1],
        _ref5$ = _ref5[2],
        widgets = _ref5$.widgets,
        bindings = _ref5$.bindings;
      return {
        name: name,
        type: type,
        properties: properties,
        kids: widgets,
        bindings: bindings
      };
    });
  }

  /**
   * Decode child components of a Px node. Widgets will be decoded to UxModel
   * children, and bindings will be decoded to their actual Component instances.
   *
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} kids
   * @param {object} typeMap
   * @returns {{ widgets: Array.<object>, bindings: Array.<baja.Component> }}
   */
  function decodeKids(kids, typeMap) {
    var widgets = [];
    var bindings = [];
    // we must do these in sequential order so slot order is respected.
    return kids.reduce(function (prom, kid) {
      return prom.then(function () {
        var typeSpec = kid[TYPE_SPEC];
        var type = baja.lt(kid[TYPE_SPEC]);
        var mapObj = typeMap[typeSpec];
        if (mapObj && mapObj.w || type && type.is('bajaui:Widget')) {
          return toUxModel(kid, typeMap).then(function (obj) {
            return widgets.push(obj);
          });
        }
        if (mapObj && mapObj.b || type && type.is('bajaui:Binding')) {
          return decodeValue(kid).then(function (comp) {
            if (comp instanceof Binding) {
              comp.getName = constant(kid.n);
              bindings.push(comp);
            }
          });
        }
      });
    }, Promise.resolve()).then(function () {
      return {
        widgets: widgets,
        bindings: bindings
      };
    });
  }

  /**
   * @param {string} typeSpec
   * @param {object} typeMap
   * @returns {Promise.<Function>} resolves to the appropriate Widget constructor
   */
  function resolveJsWidget(typeSpec, typeMap) {
    var id = typeMap[typeSpec];
    return Promise.resolve(id && doRequire(id.js, id.dg)).then(function (Widget) {
      if (Widget) {
        return Widget;
      }
      return StationRegistry.getInstance().resolveFirst(typeSpec, {
        hasAll: ['bajaux:IJavaScriptWidget']
      });
    }).then(function (Widget) {
      if (!Widget) {
        throw new Error('No bajaux:IJavaScriptWidget agent found for ' + typeSpec);
      }
      if (Widget === NullWidget) {
        logInfo('No bajaux:IJavaScriptWidget agent found for ' + typeSpec);
      }
      return Widget;
    });
  }

  /**
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} properties
   * @returns {Promise.<object>} resolves to a properties object to be applied
   * to a widget
   */
  function decodeWidgetProperties(properties) {
    return Promise.all(properties.map(decodeValue)).then(function (values) {
      var props = {};
      properties.forEach(function (prop, i) {
        props[prop[NAME]] = values[i];
      });
      if (props.enabled === undefined) {
        props.enabled = true;
      }
      if (props.visible === undefined) {
        props.visible = true;
      }
      if (props.layout === undefined) {
        props.layout = baja.$('bajaui:Layout');
      }
      return props;
    });
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} valueNode
   * @returns {Promise.<baja.Value>}
   */
  function decodeValue(valueNode) {
    return isSimple(valueNode) ? decodeSimple(valueNode) : decodeComplex(valueNode);
  }
  function isSimple(valueNode) {
    var typeSpec = valueNode[TYPE_SPEC];
    var type = baja.lt(typeSpec);
    return type && type.is('baja:Simple');
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} complexNode
   * @returns {Promise.<baja.Complex>}
   */
  function decodeComplex(complexNode) {
    var _complexNode$KIDS = complexNode[KIDS],
      kids = _complexNode$KIDS === void 0 ? [] : _complexNode$KIDS,
      _complexNode$PROPERTI = complexNode[PROPERTIES],
      properties = _complexNode$PROPERTI === void 0 ? [] : _complexNode$PROPERTI,
      typeSpec = complexNode[TYPE_SPEC];
    var obj = {};
    return kids.concat(properties).reduce(function (prom, valueNode) {
      return prom.then(function () {
        return decodeValue(valueNode);
      }).then(function (value) {
        obj[valueNode[NAME]] = value;
      });
    }, Promise.resolve()).then(function () {
      return baja.$(typeSpec, obj);
    });
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} simpleNode
   * @returns {Promise.<baja.Simple>}
   */
  function decodeSimple(_ref6) {
    var value = _ref6[VALUE],
      typeSpec = _ref6[TYPE_SPEC];
    return Promise.resolve(baja.$(typeSpec).decodeAsync(value));
  }

  /**
   * @param {Array.<Object>} props
   * @returns {Promise.<Object>} resolves to the property values with an Object that maps the
   * properties name to an object containing the type / targets.
   */
  function decodePxProperties(props) {
    return Promise.all(props.map(function (prop) {
      var name = prop[NAME],
        typeSpec = prop[TYPE_SPEC],
        value = prop[VALUE],
        targets = prop[TARGETS];
      return Promise.all([name, baja.$(typeSpec).decodeAsync(value), targets.map(function (_ref7) {
        var ord = _ref7[ORD];
        return ord.replace(/^slot:/, '').split('/');
      })]);
    })).then(function (resultVals) {
      var result = {};
      resultVals.forEach(function (_ref8) {
        var _ref9 = _slicedToArray(_ref8, 3),
          name = _ref9[0],
          value = _ref9[1],
          targets = _ref9[2];
        result[name] = {
          value: value,
          targets: targets
        };
      });
      return result;
    });
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} valueNode
   * @returns {string[]} all type specs found in the value node
   */
  function scanForTypes(valueNode) {
    var typeSpec = valueNode[TYPE_SPEC],
      _valueNode$PROPERTIES = valueNode[PROPERTIES],
      properties = _valueNode$PROPERTIES === void 0 ? [] : _valueNode$PROPERTIES,
      _valueNode$KIDS = valueNode[KIDS],
      kids = _valueNode$KIDS === void 0 ? [] : _valueNode$KIDS;
    return compact(flatten([typeSpec, properties.map(scanForTypes), kids.map(scanForTypes)]));
  }
  function getWidgetTypeSpecs(typeMap) {
    return Object.keys(typeMap).filter(function (typeSpec) {
      var obj = typeMap[typeSpec];
      return obj && obj.w;
    });
  }

  /**
   * Encoding of a Px document as provided by `UxBuilderServlet`.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxDocumentEncoding
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxPropertyEncoding>} [props] - encoding of Px properties
   * @property {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} content - encoding of the root widget
   * @property {object} typeMap - mapping of type specs to RequireJS info `module:nmodule/bajaui/rc/rpc/uxBuilder~RequireJSEncoding`
   */

  /**
   * Encoding of a RequireJS info provided by `UxBuilderServlet`.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~RequireJSEncoding
   * @property {String} [js] - encoding of RequireJS id
   * @property {Array.<Array.<String>>} [dg] - the RequireJS IDs necessary to preload before loading this JavaScript resource
   */

  /**
   * Encoding of a Px Property in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxPropertyEncoding
   * @property {string} n - Px Property name
   * @property {string} t - Px Property type spec
   * @property {string} v - string encoding of value
   * @property {Array.<{ o: string }>} ta - array of ORDs (SlotPaths) this property maps to
   */

  /**
   * Encoding of a Baja value in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding
   * @property {string} [n] - component name (never present for root widget)
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} p  - component properties
   * @property {string} t - widget type spec
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} k - encoding of child components
   */

  exports.$retrieveFromServlet = retrieveFromServlet;
  return exports;
});
