/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/mixin/SpecialPropertySupport
 */
define(['log!nmodule.bajaui.rc.mixin.SpecialPropertySupport', 'jquery', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (log, $, mixinUtils) {
  'use strict';

  var MIXIN_NAME = 'specialPropertySupport';
  var applyMixin = mixinUtils.applyMixin;
  var logSevere = log.severe.bind(log);
  var SpecialPropertySupport = function SpecialPropertySupport() {};
  function applySpecialPropertySupport(target) {
    if (!applyMixin(target, MIXIN_NAME, SpecialPropertySupport.prototype)) {
      return;
    }
    var initialize = target.initialize;
    var changed = target.changed;
    target.initialize = function (dom) {
      if (this.properties().getValue("visible") === false) {
        dom.toggleClass("bajaux-invisible", true);
      }
      if (this.properties().getValue("enabled") === false) {
        this.setEnabled(false);
      }
      return initialize.apply(this, arguments);
    };
    target.changed = function (name, value) {
      if (name === "visible") {
        this.jq().toggleClass("bajaux-invisible", value === false);
      } else if (name === 'enabled') {
        /*
        there is a tradeoff here.
         manually calling setEnabled here results in a double-rerender on dynamic spandrel widgets
        when the enabled property changes (actually three calls to rerender(): two from duplicate
        doEnabled() calls, and one from the doChanged()).
         what i *want* to do is manually set this.$enabled and manually toggle the bajaux-disabled
        class, so it only renders once. but there's more extra stuff than that in setEnabled like
        ENABLED_EVENT and so on, and the more private API i access here the ickier it gets.
         so: cleanliness over performance. if rapid-fire enabled property toggles become a problem,
        revisit.
         */
        this.setEnabled(!!value)["catch"](logSevere);
      }
      return changed.apply(this, arguments);
    };
  }
  return applySpecialPropertySupport;
});
