function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/wb/mgr/schedule/ScheduleImportManager
 * @since Niagara 4.14
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/DriverMgr', 'nmodule/driver/rc/wb/mgr/schedule/ScheduleImportCommand', 'nmodule/driver/rc/wb/mgr/schedule/ScheduleImportModel', 'nmodule/driver/rc/wb/mgr/schedule/scheduleMgrUtils', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils'], function (baja, Promise, _, DriverMgr, ScheduleImportCommand, ScheduleImportModel, scheduleMgrUtils, componentStatusUtils) {
  'use strict';

  var every = _.every;
  var getExt = scheduleMgrUtils.getExt;
  /**
   * Base class for schedule import managers (Niagara, Bacnet, etc.)
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/schedule/ScheduleImportManager
   * @extends module:nmodule/driver/rc/wb/mgr/DriverMgr
   */
  return /*#__PURE__*/function (_DriverMgr) {
    function ScheduleImportManager(params) {
      _classCallCheck(this, ScheduleImportManager);
      return _callSuper(this, ScheduleImportManager, [Object.assign({
        moduleName: 'driver',
        keyName: 'ScheduleImportManager',
        editableTypes: [baja.lt('schedule:BooleanSchedule'), baja.lt('schedule:EnumSchedule'), baja.lt('schedule:NumericSchedule'), baja.lt('schedule:CalendarSchedule'), baja.lt('schedule:StringSchedule'), baja.lt('schedule:TriggerSchedule')]
      }, params)]);
    }

    /**
     * Add ScheduleImportCommand.
     * @returns {Promise.<Array.<module:bajaux/commands/Command>>}
     */
    _inherits(ScheduleImportManager, _DriverMgr);
    return _createClass(ScheduleImportManager, [{
      key: "makeCommands",
      value: function makeCommands() {
        var _this = this;
        return _superPropGet(ScheduleImportManager, "makeCommands", this, 3)([]).then(function (cmds) {
          return cmds.concat(new ScheduleImportCommand(_this));
        });
      }

      /**
       * Overrides the basic manager `finishMainTableRow` function with some extra css information
       * based on the status of Network
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row a table row instance
       * @param {JQuery} dom
       * @returns {Promise}
       */
    }, {
      key: "finishMainTableRow",
      value: function finishMainTableRow(row, dom) {
        var ext = getExt(row.getSubject()),
          status = ext ? baja.Status.getStatusFromIStatus(ext) : baja.Status.DEFAULT;
        dom.addClass('driver-mgr-row');
        componentStatusUtils.addComponentStatusCss(status, dom);
        return Promise.resolve(dom);
      }

      /**
       * @param {baja.Component} scheduleContainer
       * @returns {Promise.<module:nmodule/driver/rc/wb/mgr/schedule/ScheduleImportModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(scheduleContainer) {
        return ScheduleImportModel.make(scheduleContainer);
      }

      /**
       * @private
       * @returns {module:nmodule/driver/rc/wb/mgr/schedule/ScheduleImportCommand}
       */
    }, {
      key: "$getScheduleImportCommand",
      value: function $getScheduleImportCommand() {
        return this.getCommandGroup().findCommand(ScheduleImportCommand);
      }

      /**
       * In addtion to the default logic, this enables/disables the ScheduleImportCommand
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this2 = this;
        return _superPropGet(ScheduleImportManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var scheduleCmd = _this2.$getScheduleImportCommand();
          var mainTableSelection = selectedSubjects.mainTableSelection;
          var enabled = !!mainTableSelection.length && every(mainTableSelection, function (c) {
            return scheduleCmd.canBeInvokedOn(c);
          });
          scheduleCmd.setEnabled(enabled);
        });
      }
    }]);
  }(DriverMgr);
});
//# sourceMappingURL=ScheduleImportManager.js.map
