function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/wb/mgr/history/ArchiveCommand
 */
define(['baja!', 'bajaux/commands/Command', 'Promise', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (baja, Command, Promise, MgrCommand) {
  'use strict';

  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;

  /**
   * Invokes the `execute` action on any selected ArchiveDescriptors.
   *
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/history/ArchiveCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    function ArchiveCommand(mgr) {
      var _this;
      _classCallCheck(this, ArchiveCommand);
      _this = _callSuper(this, ArchiveCommand, [{
        module: 'driver',
        lex: 'commands.archive',
        enabled: false,
        flags: ALL_BARS | MAIN_CONTEXT_MENU,
        func: function func() {
          var selectedArchiveDescriptors = _this.$getSelectedComponents().filter(isArchiveDescriptor);
          return Promise.all(selectedArchiveDescriptors.map(function (c) {
            return c.invoke({
              slot: 'execute'
            });
          }));
        }
      }]);
      _this.$mgr = mgr;
      return _this;
    }

    /**
     * @private
     * @returns {Array.<baja.Component>}
     */
    _inherits(ArchiveCommand, _Command);
    return _createClass(ArchiveCommand, [{
      key: "$getSelectedComponents",
      value: function $getSelectedComponents() {
        return this.$mgr.getMainTable().getSelectedRows().map(function (r) {
          return r.getSubject();
        });
      }

      /**
       * @param {baja.Component} component
       * @returns {boolean}
       */
    }, {
      key: "canBeInvokedOn",
      value: function canBeInvokedOn(component) {
        return baja.hasType(component, 'driver:AbstractDescriptor') && component.$canInvoke('execute');
      }
    }]);
  }(Command);
  function isArchiveDescriptor(c) {
    return baja.hasType(c, 'driver:ArchiveDescriptor');
  }
});
//# sourceMappingURL=ArchiveCommand.js.map
