function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/ProxyConversionEditor
 */
define(['nmodule/webEditors/rc/fe/baja/BaseEditor', 'jquery', 'Promise', 'nmodule/webEditors/rc/servlets/registry', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'baja!', 'nmodule/webEditors/rc/fe/fe', 'nmodule/driver/rc/fe/ProxyConversionMiniEditor', 'bajaux/Widget', 'css!nmodule/driver/rc/driver'], function (BaseEditor, $, Promise, registry, _, typeUtils, baja, fe, ProxyConversionMiniEditor, Widget) {
  'use strict';

  /**
   * ProxyConversionEditor is a bajaux field editor a BProxyConversion property. This property is
   * part of a composite Proxy Extension component of any protocol point.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/driver/rc/fe/ProxyConversionEditor
   */
  var ProxyConversionEditor = function ProxyConversionEditor() {
    BaseEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  ProxyConversionEditor.prototype = Object.create(BaseEditor.prototype);
  ProxyConversionEditor.prototype.constructor = ProxyConversionEditor;

  /**
   * Get the select element.
   *
   * @returns {jQuery}
   */
  ProxyConversionEditor.prototype.getSelect = function () {
    return this.jq().children('select');
  };

  /**
   * Get the field editor registered on selected type
   * @returns {*}
   */
  ProxyConversionEditor.prototype.getConversionWidget = function () {
    return this.jq().children('.js-divPlaceHolder').data('widget');
  };

  /**
   * Initial is a one-time setup activity. The select html control is
   * initialized with all possible proxy extension types available to be set.
   *
   * @param {JQuery} dom the DOM element into which to load this widget
   * @return {Promise}
   */
  ProxyConversionEditor.prototype.doInitialize = function (dom) {
    var that = this;
    //Get a list of modules with targetType is driver:ProxyConversion
    return Promise.resolve(that.getProxyConvTypes()).then(function (listOfTypes) {
      var html = _.map(listOfTypes, function (resultType) {
        return $('<option class="ux-option"/>').val(resultType.type).text(resultType.displayName);
      });
      dom.append('<select class="ux-select select-driver-ProxyConversion" />');
      dom.append('<div class="js-divPlaceHolder" />');
      that.getSelect().html(html);
      dom.on('change', 'select.select-driver-ProxyConversion', function () {
        that.setModified(true);
        that.initConversionWidget(dom)["catch"](baja.error);
        return false;
      });
    });
  };

  /**
   * Get all the types of driver:ProxyConversion
   * Override if required to filter out certain types (e.d for Shunt500OhmConversion)
   * @returns {Promise|*} Types or promise that resolves to ProxyConversion list of types
   */
  ProxyConversionEditor.prototype.getProxyConvTypes = function () {
    return registry.getTypes({
      targetType: 'driver:ProxyConversion',
      showAbstract: false
    });
  };

  /**
   * Initialize the editor for selected Proxy conversion type
   * @param {object} dom
   * @return {Promise}
   */
  ProxyConversionEditor.prototype.initConversionWidget = function (dom) {
    var that = this;
    var conWid = that.getConversionWidget();
    var loadedTypeSpec;
    return Promise.all([typeUtils.importTypes(that.getSelect().val()), conWid && conWid.destroy()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        resultType = _ref2[0];
      loadedTypeSpec = resultType[0].getTypeSpec();
      return Promise.all([fe.getDefaultConstructor(loadedTypeSpec, {
        formFactors: [Widget.formfactor.mini]
      }), fe.getDefaultConstructor(loadedTypeSpec, {
        formFactors: [Widget.formfactor.compact]
      })]);
    }).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        MiniConversionEditor = _ref4[0],
        CompactConversionEditor = _ref4[1];
      if (MiniConversionEditor === ProxyConversionEditor) {
        return false;
      }
      var val = baja.$(loadedTypeSpec);
      if (CompactConversionEditor) {
        return fe.buildFor({
          value: val,
          dom: $(".js-divPlaceHolder", dom),
          type: ProxyConversionMiniEditor,
          properties: {
            showButton: true
          },
          formFactor: Widget.formfactor.compact
        });
      }
      return fe.buildFor({
        value: val,
        dom: $(".js-divPlaceHolder", dom),
        type: MiniConversionEditor,
        formFactor: Widget.formfactor.mini
      });
    });
  };

  /**
   * The field editor is of type driver:ProxyConversion and loaded into
   * by any confirming types. The loaded in value is then set as default
   * selected value of the drop down.
   *
   * @param value description of the value to be loaded into this widget
   */
  ProxyConversionEditor.prototype.doLoad = function (value) {
    var that = this;
    that.getSelect().val(value.getType().getTypeSpec());
    var conWid = that.getConversionWidget();
    if (value.encodeToString() !== "") {
      return Promise.resolve(that.initConversionWidget(that.jq())).then(function () {
        conWid = that.getConversionWidget();
        return conWid && conWid.load(value);
      });
    }
    return Promise.resolve(conWid && conWid.destroy());
  };

  /**
   * driver:ProxyConversion is the type that is set so it matches
   * the loaded in value type.
   *
   * @returns {Promise} promise to be resolved with the current value
   */
  ProxyConversionEditor.prototype.doRead = function () {
    var that = this;
    var conWid = that.getConversionWidget();
    if (conWid) {
      return conWid.read();
    }
    var selectedValue = that.getSelect().val();
    return typeUtils.importTypes(selectedValue).then(function () {
      return baja.$(selectedValue);
    });
  };

  /**
   * Enables or disables the select dropdown.
   *
   * @param {Boolean} enabled
   */
  ProxyConversionEditor.prototype.doEnabled = function (enabled) {
    this.getSelect().prop('disabled', this.isReadonly() || !enabled);
    var conWid = this.getConversionWidget();
    if (conWid) {
      conWid.setEnabled(enabled);
    }
  };

  /**
   * Disables or enables the select dropdown.
   *
   * @param {Boolean} readonly
   */
  ProxyConversionEditor.prototype.doReadonly = function (readonly) {
    this.getSelect().prop('disabled', !this.isEnabled() || readonly);
    var conWid = this.getConversionWidget();
    if (conWid) {
      conWid.setReadonly(readonly);
    }
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  ProxyConversionEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return ProxyConversionEditor;
});
//# sourceMappingURL=ProxyConversionEditor.js.map
