function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/*global window, document, navigator, btoa */

/**
 * API Status: **Private**
 * @module  module:nmodule/maxpro/rc/maxpro/MaxproVideoStream
 */
define(['baja!', 'lex!videoDriver', 'log!nmodule.videoDriver.rc.maxpro.MaxproVideoStream', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/fe/playback/PlaybackMixin', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/maxpro/ext/axios/axios.min', 'nmodule/maxpro/ext/std-video-player/std.video.player', 'css!nmodule/videoDriver/rc/videoDriver', 'css!nmodule/maxpro/rc/maxpro'], function (baja, lexs, log, $, Promise, _, Widget, asyncUtils, PlaybackMixin, videoDriverUtils, VideoFeedMixin, rpc, BaseEditor, axios, videoPlayer) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var waitForTrue = asyncUtils.waitForTrue;
  var CONNECTION_STATUS_CHANGED_EVENT = VideoFeedMixin.CONNECTION_STATUS_CHANGED_EVENT,
    STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT,
    TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;
  var logFine = log.fine.bind(log),
    STD_VIDEO_PLAYER_PRIVATE_ID = './std-video-player/std.video.player',
    CONNECTION_SUCCESSFUL = 'connection.successful',
    CONNECTION_TIMEOUT = 'connection.timeout',
    H264_ENCODING = 'h264',
    JPEG_ENCODING = 'jpeg',
    RESPONSE_OK_LEGACY = "ReponseOk",
    ///TODO Maxpro Team: Typo
    RESPONSE_OK = "ResponseOk"; //future maxpro version might correct response to this value

  var stdVideoPlayer;

  //id='changeText', the maxpro api requires this id be present on the page(it doesn't matter if there are duplicates since we are not using it)
  //class='videoCreationDiv', need a spot to give to the library so we can grab just the video or canvas element out of it and keep everything else hidden
  var tpl = function tpl() {
    return "\n    <div class='videoCreationDiv'>\n      <video autoplay muted class='videoInsert'></video>      \n      <canvas width='718' height='531' class='videoInsert'></canvas>\n      <div id='changeText'>\n      </div>      \n    </div>    \n  ";
  };

  /**
   * Baja Widget for LiveVideo for MaxproNetwork
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/maxpro/rc/maxpro/MaxproVideoStream
   * @implements module:module:nmodule/videoDriver/rc/fe/playback/PlaybackController
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @mixes module:nmodule/videoDriver/rc/live/VideoFeedMixin
   */
  return /*#__PURE__*/function (_BaseEditor) {
    function MaxproVideoStream(params) {
      var _this;
      _classCallCheck(this, MaxproVideoStream);
      _this = _callSuper(this, MaxproVideoStream, [_.extend({
        keyName: 'MaxproVideoStream',
        moduleName: 'videoDriver'
      }, params)]);
      PlaybackMixin(_this);
      VideoFeedMixin(_this);
      _this.$paused = false;
      _this.$connectionTimeoutMillis = 25000;
      return _this;
    }

    /**
     * @private
     * @returns {Promise}
     */
    _inherits(MaxproVideoStream, _BaseEditor);
    return _createClass(MaxproVideoStream, [{
      key: "doInitialize",
      value:
      /**
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        dom.html(tpl()).addClass('MaxproVideoStream');
      }

      /**
       * @param {baja.Component} value a `maxpro:MaxproCamera}` instance
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        return MaxproVideoStream.$loadSdk();
      }

      /*
       * @private
       * @param {Object} [params]
       * @param {String} [params.width]
       * @param {String} [params.height]
       * @return {Promise}
       */
    }, {
      key: "$grabVideoElement",
      value: function $grabVideoElement() {
        var _this2 = this;
        var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return waitForTrue(function () {
          var video = $(_this2.$getVideo());
          return video.attr('src') || _this2.$useCanvas;
        }, this.$connectionTimeoutMillis)["catch"](function (err) {
          logFine(err);
          _this2.$setVideoConnectionStatus(lex.get(CONNECTION_TIMEOUT));
          throw new Error(lex.get(CONNECTION_TIMEOUT));
        }).then(function () {
          var video = $(_this2.$getVideo());
          video.addClass("videoInsert");
          _this2.jq()[0].appendChild(video[0]);
          var videoInserts = _this2.jq().find(".videoInsert");
          videoInserts.each(function () {
            var element = $(this);
            if (element.prop("tagName") === "DIV") {
              element.removeClass('videoInsert'); //maxPro moves the className from video to parent which we don't want
            }
            if (element.prop("tagName") === "VIDEO" || element.prop("tagName") === "CANVAS") {
              if (params.width) {
                element.css('width', params.width);
              }
              if (params.height) {
                element.css('height', params.height);
              }
            }
          });
        });
      }

      /**
       *
       * @private
       * @param {object} params
       * @param {string} [params.type] a `BPlaybackTypeEnum` tag
       * @param {number} [params.speed] playback speed, from 1 to 10
       * @param {Date} [params.timestamp] playback timestamp
       * @return {*}
       */
    }, {
      key: "$play",
      value: function $play(_ref) {
        var _this3 = this;
        var type = _ref.type,
          speed = _ref.speed,
          timestamp = _ref.timestamp;
        this.$setVideoConnectionStatus(lex.get("connection.inProgress"));
        this.$paused = false;
        return Promise.all([this.$resolveConnectionInfo(), MaxproVideoStream.$loadSdk()]).then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 1),
            connectionInfo = _ref3[0];
          var videoEl = $('video', _this3.jq())[0];
          var canvasEl = $('canvas', _this3.jq())[0];
          var protocol = "H265_s_WSS";
          var alternateProtocols = ["MSE_s_WSS", "MJPEG_s_WSS"];
          var encoding = _this3.$getEncoding();
          logFine("#play- encoding: ".concat(encoding));
          if (encoding === 'h264') {
            if (canvasEl) {
              canvasEl.remove();
            }
          } else {
            if (videoEl) {
              videoEl.remove();
            }
            _this3.$useCanvas = true;
            protocol = "MJPEG_s_WSS";
            alternateProtocols = [];
          }
          var retrievalType = type === 'live' ? type : 'playback';
          var host = connectionInfo.host,
            port = connectionInfo.port,
            username = connectionInfo.username,
            password = connectionInfo.password,
            webSocketPort = connectionInfo.webSocketPort,
            cameraId = connectionInfo.cameraId;
          var url = "https://" + host + ":" + port + "/UVISOM/ISOM/VideoMgmt/Media/Streams/config";
          var overrideHost = host;
          var json = {
            identifiers: {
              "id": cameraId
            },
            relation: [{
              "name": "StreamRetrievedFromCamera",
              "entityID": cameraId
            }],
            protocol: protocol,
            retrievalType: retrievalType,
            alternateProtocols: alternateProtocols
          };
          var offset = 0;
          if (retrievalType === 'playback') {
            if (!timestamp && _this3.$player) {
              //TODO: honeywell doesn't have a working "resume yet,
              //stdVideoPlayer.resume(this.$player);
              //return;

              //so we will start off a new stream where we left off
              timestamp = _this3.$currentTimestamp;
            }
            var timeEncoding = new Date(timestamp).toISOString();
            timeEncoding = timeEncoding.substring(0, 19) + "Z";
            var requestedTime = new Date(timestamp);

            //uncomment to go to a known working recording if something isn't working
            //timeEncoding = '2021-03-16T23:10:30Z';
            //requestedTime = new Date(timeEncoding);

            offset = new Date() - requestedTime;
            offset = Math.floor(offset / 1000);
            json.playbackparams = {
              startDateTime: timeEncoding
            };
            json.retrievalType = "playback";
            retrievalType = json.retrievalType;
          }
          var headers = {
            'Content-Type': 'application/json',
            'Authorization': makeBasicAuth(username, password)
          };
          var params = JSON.stringify(json);
          var width = '';
          var height = '';
          var playerOption = null;
          return axios.post(url, params, {
            headers: headers,
            timeout: _this3.$connectionTimeoutMillis
          })["catch"](function (error) {
            if (String(error).startsWith('Error: timeout')) {
              _this3.$setVideoConnectionStatus(lex.get(CONNECTION_TIMEOUT));
              return;
            }
            throw error;
          }).then(function (response) {
            if (!response) {
              return;
            }
            logFine("response: " + response);
            var streamObject = response.data;
            if (streamObject.statusCode !== RESPONSE_OK && streamObject.statusCode !== RESPONSE_OK_LEGACY) {
              _this3.$setVideoConnectionStatus(streamObject.statusCode + ":" + streamObject.statusString);
              return;
            }
            var responseData = streamObject.extension[0];
            var streamURL = _this3.$overrideStreamUrl({
              streamURL: responseData.streamURL,
              overrideHost: overrideHost,
              webSocketPort: webSocketPort
            });
            playerOption = {
              videoElement: _this3.$getVideo(),
              url: streamURL,
              videoPlayMode: retrievalType,
              playbackSecondsOffset: Math.round(offset * -1),
              playbackSpeed: getPlaybackSpeedIndex({
                type: type,
                speed: speed
              })
            };
            var videoInserts = $(_this3.$getVideo());
            if (videoInserts.length > 0) {
              width = videoInserts.css('width');
              height = videoInserts.css('height');
            }
            playerOption.onTimePosition = function (data) {
              _this3.$onTimePosition(data);
            };
            playerOption.onNotification = function (data) {
              _this3.$onNotification(data);
            };
            var isLive = retrievalType === 'live';
            if (playerOption.videoElement.parentNode && stdVideoPlayer.IsPlayerExisted(playerOption.videoElement.parentNode, retrievalType) || _this3.$useCanvas || isLive !== _this3.$isPlayerLive) {
              if (_this3.$player) {
                _this3.$disposePlayer();
                var newVideo = $("<video autoPlay muted className='videoInsert'></video>");
                if (_this3.$useCanvas) {
                  _this3.$getVideo().remove();
                  newVideo = $("<canvas className='videoInsert'></canvas>");
                }
                newVideo.appendTo(_this3.jq().find('.videoCreationDiv'));
                playerOption.videoElement = _this3.$getVideo();
              }
            }
            return Promise.resolve(stdVideoPlayer.Play(playerOption)).then(function (player) {
              //TODO: this isn't public api but seems to be the only way to get us to any websocket error
              player.stateCallback = function (data) {
                _this3.$onNotification(data);
              };
              _this3.$player = player;
              _this3.$isPlayerLive = isLive;
              return _this3.$grabVideoElement({
                width: width,
                height: height
              });
            }).then(function () {
              if (!_this3.$videoReady) {
                return _this3.$waitForVideoStream().then(function () {
                  _this3.$videoReady = true;
                  _this3.emit(STREAM_DATA_RECEIVED_EVENT);
                  _this3.$setVideoConnectionStatus(lex.get(CONNECTION_SUCCESSFUL));
                })["catch"](function () {
                  _this3.$setVideoConnectionStatus(lex.get(CONNECTION_TIMEOUT));
                });
              } else {
                _this3.$setVideoConnectionStatus(lex.get(CONNECTION_SUCCESSFUL));
              }
            });
          });
        });
      }

      /**
       * Return the encoding to use. Either `jpeg` or `h264`.
       * This can be overridden with a ViewQuery parameter with the name `encoding` in the window.location.href.
       *
       * @private
       * @return {string}
       */
    }, {
      key: "$getEncoding",
      value: function $getEncoding() {
        var viewParamEncoding = videoDriverUtils.getViewParameter('encoding');
        if (viewParamEncoding === JPEG_ENCODING || viewParamEncoding === H264_ENCODING) {
          return viewParamEncoding;
        }
        if (!this.$canPlayWithVideoTag()) {
          return JPEG_ENCODING;
        }
        return H264_ENCODING;
      }

      /**
       * @private
       * @param {Object} params
       * @param {String} params.streamURL
       * @param {String} params.overrideHost
       * @param {Number} params.webSocketPort
       * @return {String}
       */
    }, {
      key: "$overrideStreamUrl",
      value: function $overrideStreamUrl(_ref4) {
        var streamURL = _ref4.streamURL,
          overrideHost = _ref4.overrideHost,
          webSocketPort = _ref4.webSocketPort;
        logFine("stream url before: " + streamURL);

        //replace the webSocketPort if its non-standard for this maxpro setup.
        //Port forwarding to an external network may require an alteration to this number
        if (webSocketPort !== 8080) {
          streamURL = streamURL.replace(':8080', ":" + webSocketPort);
        }

        //The hostname that the max pro server may think its using may be incorrect for an  external network with port forwarding.
        //use whatever the hostname is configured to the station.
        var firstColon = streamURL.indexOf(":");
        var secondColon = streamURL.indexOf(":", firstColon + 1);
        var ipString = streamURL.substring(streamURL.lastIndexOf("//") + 2, secondColon);
        streamURL = streamURL.replace('//' + ipString + ':', '//' + overrideHost + ':');
        logFine("stream url after: " + streamURL);
        return streamURL;
      }

      /**
       * @private
       * @param {Object} data
       * @param {Object} data.Timestamp the timestamp from the stream
       */
    }, {
      key: "$onTimePosition",
      value: function $onTimePosition(data) {
        //TODO: maxPro should not call this method when the video is paused!
        if (this.$paused || !this.$videoReady) {
          return;
        }
        this.$currentTimestamp = data.Timestamp;
        this.emit(TIMESTAMP_CHANGED_EVENT);
      }

      /**
       * @private
       * @param {Object|String} data the data from the notification
       */
    }, {
      key: "$onNotification",
      value: function $onNotification(data) {
        logFine('notification: ' + data);
        if (data === 'web_socket_.onerror') {
          this.$setVideoConnectionStatus(lex.get("connection.failed"));
        }
      }

      /**
       * @private
       * @return {Promise}
       */
    }, {
      key: "$waitForVideoStream",
      value: function $waitForVideoStream() {
        var _this4 = this;
        if (this.$useCanvas) {
          return waitForTrue(function () {
            return !_this4.$isCanvasBlank();
          }, this.$connectionTimeoutMillis);
        }
        return waitForTrue(function () {
          return _this4.$getVideoWidth() !== 0;
        }, this.$connectionTimeoutMillis);
      }

      /**
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isCanvasBlank",
      value: function $isCanvasBlank() {
        var video = this.$getVideo();
        var blank = document.createElement('canvas');
        blank.width = video.width;
        blank.height = video.height;
        return video.toDataURL() === blank.toDataURL();
      }

      /**
       * @private
       * @return {number}
       */
    }, {
      key: "$getVideoWidth",
      value: function $getVideoWidth() {
        var video = this.$getVideo();
        return video ? video.videoWidth : 0;
      }

      /**
       * @private
       */
    }, {
      key: "$pause",
      value: function $pause() {
        var player = this.$player;
        if (player && !this.$paused) {
          //stdVideoPlayer.Pause(player); //TODO: this api does not work
          if (player.pause) {
            player.pause();
          } else {
            this.$disposePlayer();
          }
          this.$paused = true;
        }
      }

      /**
       * Change the current playback type and speed.
       * @param {object} params
       * @param {string} [params.type] a `BPlaybackTypeEnum` tag
       * @param {number} [params.speed] playback speed, from 1 to 10
       * @param {Date} [params.timestamp] playback timestamp
       */
    }, {
      key: "doPlayback",
      value: function doPlayback(_ref5) {
        var type = _ref5.type,
          speed = _ref5.speed,
          timestamp = _ref5.timestamp;
        logFine("#playback - type: ".concat(type, ", speed: ").concat(speed));
        var video = this.$getVideo();
        if (!video) {
          return;
        }
        switch (type) {
          case 'slowRew':
          case 'fastRew':
          case 'slowFwd':
          case 'fastFwd':
          case 'live':
          case 'play':
            return this.$play({
              type: type,
              speed: speed,
              timestamp: timestamp
            });
          case 'pause':
            return this.$pause();
        }
      }

      /**
       * @private
       * @return {Promise.<{ username: string, password: string, hostname: string, port: string, webSocketPort: string, cameraId: string }>}
       */
    }, {
      key: "$resolveConnectionInfo",
      value: function $resolveConnectionInfo() {
        var camera = this.getCamera();
        return baja.rpc({
          ord: String(camera.getNavOrd()),
          method: "getConnectionInfo"
        });
      }

      /**
       * @private
       * @returns {HTMLVideoElement}
       */
    }, {
      key: "$getVideo",
      value: function $getVideo() {
        if (this.$useCanvas) {
          return $('canvas', this.jq())[0];
        } else {
          return $('video', this.jq())[0];
        }
      }

      /**
       * @private
       */
    }, {
      key: "$disposePlayer",
      value: function $disposePlayer() {
        if (this.$player) {
          //TODO: their API doesn't seem to do anything yet
          //stdVideoPlayer.Stop(JSON.stringify(playerOption));
          this.$player.dispose();
          this.$player = undefined;
        }
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.$disposePlayer();
        this.jq().removeClass('MaxproVideoStream');
      }

      /**
       * @returns {number} current timestamp
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "getVideoTimestamp",
      value: function getVideoTimestamp() {
        return this.$currentTimestamp;
      }

      /**
       * @returns {boolean}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "isVideoStreaming",
      value: function isVideoStreaming() {
        return !!this.$currentTimestamp;
      }

      /**
       * @returns {baja.Component} the currently loaded camera
       */
    }, {
      key: "getCamera",
      value: function getCamera() {
        return this.value();
      }

      /**
       * @returns {String}
       * @see module:nmodule/videoDriver/rc/live/VideoDriverMixin
       */
    }, {
      key: "getVideoConnectionStatus",
      value: function getVideoConnectionStatus() {
        return this.$currentStatus;
      }

      /**
       * Calls the updated status callback if set.
       * @private
       * @param {String} status
       */
    }, {
      key: "$setVideoConnectionStatus",
      value: function $setVideoConnectionStatus(status) {
        this.$currentStatus = status;
        this.emit(CONNECTION_STATUS_CHANGED_EVENT);
      }

      /**
       * Return true if video can be used.
       * `h264` for most browsers and `jpeg` for iOS and JxBrowser.
       * @private
       * @return {boolean}
       */
    }, {
      key: "$canPlayWithVideoTag",
      value: function $canPlayWithVideoTag() {
        //ios 12 says it can play, but it can't
        //https://stackoverflow.com/questions/21120717/h-264-video-wont-play-on-ios

        //https://caniuse.com/#feat=mediasource ios13 with ipadPro might work if we get one to test

        if (this.$isIOS()) {
          return false;
        }

        //JxBrowser is false for now https://jxbrowser-support.teamdev.com/docs/guides/media.html#video

        return window.MediaSource && window.MediaSource.isTypeSupported('video/mp4; codecs="avc1.640029"'); //h265

        //these are the other codecs listed in the std.player example code 'test.requirejs.html', but we only check h265 for now since this aligns with JxBrowser 6.X support
        //window.MediaSource.isTypeSupported('video/mp4; codecs="mp4v.20.8"') ||
        //window.MediaSource.isTypeSupported('video/ogg; codecs="theora"') ||
        //window.MediaSource.isTypeSupported('video/webm; codecs="vp8, vorbis"'));
      }

      /**
       * Return true if this is the Safari Browser
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isSafari",
      value: function $isSafari() {
        return /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
      }

      /**
       * Return true if this is iOS
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isIOS",
      value: function $isIOS() {
        return navigator.userAgent.toLowerCase().indexOf('like mac os x') > -1;
      }
    }], [{
      key: "$loadSdk",
      value: function $loadSdk() {
        return MaxproVideoStream.$setupSdk().then(function (videoPlayer) {
          stdVideoPlayer = videoPlayer;
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$setupSdk",
      value: function $setupSdk() {
        if (require.defined(STD_VIDEO_PLAYER_PRIVATE_ID)) {
          return Promise.resolve(require(STD_VIDEO_PLAYER_PRIVATE_ID));
        }
        define(STD_VIDEO_PLAYER_PRIVATE_ID, [], function () {
          return videoPlayer;
        });

        //TODO Maxpro Team: std.video.player expects jquery here
        window.$ = $;
        return Promise.resolve(videoPlayer);
      }
    }]);
  }(BaseEditor);
  function makeBasicAuth(user, password) {
    var tok = user + ':' + password;
    var hash = btoa(tok);
    return "Basic " + hash;
  }

  /**
   * Maxpro supports 4 fast speeds and 3 slow speeds.
   * The normal speed is index 11.
   * @param {object} params
   * @param {string} [params.type] a `BPlaybackTypeEnum` tag
   * @param {number} [params.speed] playback speed, from 1 to 10
   * @return {number}
   */
  function getPlaybackSpeedIndex(_ref6) {
    var type = _ref6.type,
      speed = _ref6.speed;
    //from videojsfmp4.js
    // _this.supportedSpeeds = [
    //   "-16", 0
    //   "-8", 1
    //   "-4", 2
    //   "-2", 3
    //   "-1", 4
    //   "-1/2", 5
    //   "-1/5", 6
    //   "-1/10", 7
    //   "1/10", 8
    //   "1/5", 9
    //   "1/2", 10
    //   "1", 11 //normal speed
    //   "2", //12
    //   "4", //13
    //   "8", //14
    //   "16" //15
    // ];

    var playbackSpeed = 11; //11 is "1" forward
    if (type === 'fastRew') {
      if (speed <= 5) {
        playbackSpeed = 5 - speed; //start at "-1" speed and subtract from there
      } else {
        playbackSpeed = 0;
      }
    } else if (type === 'slowRew') {
      if (speed <= 3) {
        playbackSpeed = 4 + speed; //start at "-1/2" speed and add from there
      } else {
        playbackSpeed = 7;
      }
    }
    if (type === 'fastFwd') {
      if (speed <= 4) {
        playbackSpeed = 11 + speed; //start at "2" speed and add from there
      } else {
        playbackSpeed = 15;
      }
    } else if (type === 'slowFwd') {
      if (speed <= 3) {
        playbackSpeed = 11 - speed; //start at "-1/2" speed and subtract from there
      } else {
        playbackSpeed = 8;
      }
    }
    return playbackSpeed;
  }
});
